/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.search;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.internal.server.search.FileGrepper;
import org.eclipse.orion.internal.server.search.SearchException;
import org.eclipse.orion.internal.server.search.SearchOptions;
import org.eclipse.orion.internal.server.search.SearchResult;

public class SearchJob
extends Job {
    private SearchOptions options;
    private String username;
    public static final Object FAMILY = "org.eclipse.orion.server.search.jobs.SearchJob";
    private List<SearchResult> files;

    public String getUsername() {
        return this.username;
    }

    public boolean belongsTo(Object family) {
        return FAMILY.equals(family);
    }

    public List<SearchResult> getSearchResults() {
        return this.files;
    }

    public SearchJob(SearchOptions options) {
        super("Orion Search Job " + options.getUsername());
        this.options = options;
        this.username = options.getUsername();
    }

    protected IStatus run(IProgressMonitor monitor) {
        Status result = null;
        try {
            FileGrepper grepper = new FileGrepper(this.options);
            this.files = grepper.search(this.options);
            result = Status.OK_STATUS;
        }
        catch (SearchException exception) {
            result = new Status(4, "org.eclipse.orion.server.servlets", exception.getLocalizedMessage(), (Throwable)exception);
        }
        return result;
    }

    public static boolean isSearchJobRunning(String remoteUser) {
        Job[] jobs = Job.getJobManager().find(FAMILY);
        int count = 0;
        int i = 0;
        while (i < jobs.length) {
            SearchJob searchJob = (SearchJob)jobs[i];
            if (searchJob.getUsername().equals(remoteUser)) {
                ++count;
            }
            ++i;
        }
        return count > 5;
    }
}

