/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.orion.server.core.IOUtilities;

public class HashUtilities {
    public static final String SHA_1 = "SHA-1";

    public static String getHash(InputStream inputStream, String hashFunction) throws IOException, NoSuchAlgorithmException {
        return HashUtilities.getHash(inputStream, false, hashFunction);
    }

    public static String getHash(InputStream inputStream, boolean closeIn, String hashFunction) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(hashFunction);
        byte[] buffer = new byte[4096];
        int read = 0;
        try {
            while ((read = inputStream.read(buffer)) != -1) {
                md.update(buffer, 0, read);
            }
        }
        finally {
            if (closeIn) {
                IOUtilities.safeClose(inputStream);
            }
        }
        byte[] mdbytes = md.digest();
        return HashUtilities.bytesToHex(mdbytes);
    }

    public static String getHash(String data, String hashFunction) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(hashFunction);
        md.update(data.getBytes());
        byte[] mdbytes = md.digest();
        return HashUtilities.bytesToHex(mdbytes);
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String hexString = Integer.toHexString(0xFF & bytes[i]);
            while (hexString.length() < 2) {
                hexString = "0" + hexString;
            }
            sb.append(hexString);
            ++i;
        }
        return sb.toString();
    }
}

