/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.LogHelper;

public class SiteHostingConfig {
    private static final int DEFAULT_HOST_COUNT = 16;
    private List<String> hosts;

    private SiteHostingConfig(List<String> hosts) {
        this.hosts = hosts;
    }

    public List<String> getHosts() {
        return Collections.unmodifiableList(this.hosts);
    }

    public static SiteHostingConfig getSiteHostingConfig(String hostInfo) {
        return hostInfo == null ? SiteHostingConfig.getDefault() : SiteHostingConfig.fromString(hostInfo);
    }

    private static SiteHostingConfig fromString(String hostInfo) {
        ArrayList<String> hosts = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(hostInfo, ", ");
        if (!st.hasMoreTokens()) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.hosting", "Empty hosting configuration", null));
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            hosts.add(token);
        }
        return new SiteHostingConfig(hosts);
    }

    private static SiteHostingConfig getDefault() {
        ArrayList<String> aliases = new ArrayList<String>();
        if (!System.getProperty("os.name").startsWith("Mac OS X")) {
            InetAddress loopbackIp = SiteHostingConfig.getLoopbackAddress();
            try {
                byte[] address = loopbackIp.getAddress();
                byte lastByte = address[address.length - 1];
                int i = 0;
                int b = lastByte + 1;
                while (i < 16 && b <= 255) {
                    byte[] derivedAddress = (byte[])address.clone();
                    derivedAddress[address.length - 1] = (byte)b;
                    aliases.add(InetAddress.getByAddress(derivedAddress).getHostAddress());
                    ++i;
                    ++b;
                }
            }
            catch (UnknownHostException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.hosting", e.getMessage(), (Throwable)e));
            }
        }
        return new SiteHostingConfig(aliases);
    }

    private static InetAddress getLoopbackAddress() {
        try {
            for (NetworkInterface interfaze : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (!interfaze.isLoopback()) continue;
                for (InetAddress address : Collections.list(interfaze.getInetAddresses())) {
                    if (!(address instanceof Inet4Address)) continue;
                    return address;
                }
            }
        }
        catch (SocketException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.hosting", e.getMessage(), (Throwable)e));
        }
        return null;
    }
}

