/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.orion.server.git.IGitHubTokenProvider;

public class GitCredentialsProvider
extends UsernamePasswordCredentialsProvider {
    private URIish uri;
    private String remoteUser;
    private String knownHosts;
    private byte[] privateKey;
    private byte[] publicKey;
    private byte[] passphrase;
    private Map<String, String> tokenCache = new HashMap<String, String>();
    private static Vector<IGitHubTokenProvider> GithubTokenProviders = new Vector(9);

    public static void AddGitHubTokenProvider(IGitHubTokenProvider value) {
        GithubTokenProviders.add(value);
    }

    public static void RemoveGitHubTokenProvider(IGitHubTokenProvider value) {
        GithubTokenProviders.remove(value);
    }

    public static Enumeration<IGitHubTokenProvider> GetGitHubTokenProviders() {
        return GithubTokenProviders.elements();
    }

    public GitCredentialsProvider(URIish uri, String remoteUser, String username, char[] password, String knownHosts) {
        super(username, password);
        this.remoteUser = remoteUser;
        this.uri = uri;
        this.knownHosts = knownHosts;
    }

    public URIish getUri() {
        return this.uri;
    }

    public String getKnownHosts() {
        return this.knownHosts;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPassphrase() {
        return this.passphrase;
    }

    public void setUri(URIish uri) {
        this.uri = uri;
    }

    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public void setPassphrase(byte[] passphrase) {
        this.passphrase = passphrase;
    }

    /*
     * Unable to fully structure code
     */
    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        var6_3 = items;
        var5_4 = items.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            item = var6_3[var4_5];
            if (!(item instanceof CredentialItem.Username) && !(item instanceof CredentialItem.Password) || this.privateKey != null && this.privateKey.length != 0 || this.publicKey != null && this.publicKey.length != 0 || this.passphrase != null && this.passphrase.length != 0) ** GOTO lbl-1000
            u = new CredentialItem.Username();
            p = new CredentialItem.Password();
            super.get(uri, new CredentialItem[]{u, p});
            if (u.getValue() != null && u.getValue().length() != 0 || p.getValue() != null && p.getValue().length != 0 || uri == null || this.remoteUser == null) ** GOTO lbl-1000
            uriString = uri.toString();
            token = this.tokenCache.get(uriString);
            if (token == null) {
                i = 0;
                while (token == null && i < GitCredentialsProvider.GithubTokenProviders.size()) {
                    token = GitCredentialsProvider.GithubTokenProviders.get(i).getToken(uriString, this.remoteUser);
                    ++i;
                }
            }
            if (token != null) {
                if (item instanceof CredentialItem.Username) {
                    ((CredentialItem.Username)item).setValue(token);
                } else {
                    ((CredentialItem.Password)item).setValue(token.toCharArray());
                }
                this.tokenCache.put(uriString, token);
            } else if (super.supports(new CredentialItem[]{item})) {
                super.get(uri, new CredentialItem[]{item});
            } else if (item instanceof CredentialItem.StringType) {
                if (item.getPromptText().toLowerCase(Locale.ENGLISH).contains("passphrase") && this.passphrase != null && this.passphrase.length > 0) {
                    ((CredentialItem.StringType)item).setValue(new String(this.passphrase));
                } else {
                    ((CredentialItem.StringType)item).setValue("");
                }
            } else if (item instanceof CredentialItem.CharArrayType) {
                ((CredentialItem.CharArrayType)item).setValue(new char[0]);
            } else {
                throw new UnsupportedCredentialItem(uri, item.getPromptText());
            }
            ++var4_5;
        }
        return true;
    }
}

