/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.commands.CheckRouteCommand;
import org.eclipse.orion.server.cf.commands.ComputeTargetCommand;
import org.eclipse.orion.server.cf.commands.CreateRouteCommand;
import org.eclipse.orion.server.cf.commands.DeleteRouteCommand;
import org.eclipse.orion.server.cf.commands.GetDomainsCommand;
import org.eclipse.orion.server.cf.commands.GetRouteByGuidCommand;
import org.eclipse.orion.server.cf.commands.GetRoutesCommand;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.objects.Route;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutesHandlerV1
extends AbstractRESTHandler<Route> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public RoutesHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected Route buildResource(HttpServletRequest request, String path) throws CoreException {
        return null;
    }

    @Override
    protected CFJob handlePut(Route route, HttpServletRequest request, HttpServletResponse response, final String path) {
        JSONObject jsonData = this.extractJSONData(request);
        final JSONObject targetJSON = jsonData.optJSONObject("Target");
        final String domainName = jsonData.optString("DomainName", null);
        final String hostName = jsonData.optString("Host", null);
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTargetCommand = new ComputeTargetCommand(this.userId, targetJSON);
                    computeTargetCommand.doIt();
                    Target target = computeTargetCommand.getTarget();
                    if (target == null) {
                        return HttpUtil.createErrorStatus(2, "CF-TargetNotSet", "Target not set");
                    }
                    GetDomainsCommand getDomainsCommand = new GetDomainsCommand(target, domainName);
                    IStatus getDomainsStatus = getDomainsCommand.doIt();
                    if (!getDomainsStatus.isOK()) {
                        return getDomainsStatus;
                    }
                    CreateRouteCommand createRouteCommand = new CreateRouteCommand(target, getDomainsCommand.getDomains().get(0), hostName);
                    IStatus createRouteStatus = createRouteCommand.doIt();
                    if (!createRouteStatus.isOK()) {
                        return createRouteStatus;
                    }
                    return new ServerStatus(Status.OK_STATUS, 200, createRouteCommand.getRoute().toJSON());
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    RoutesHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    @Override
    protected CFJob handleGet(Route route, HttpServletRequest request, HttpServletResponse response, final String path) {
        final JSONObject targetJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        final JSONObject routeJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Route"));
        final String globalCheck = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"GlobalCheck");
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTargetCommand = new ComputeTargetCommand(this.userId, targetJSON);
                    computeTargetCommand.doIt();
                    Target target = computeTargetCommand.getTarget();
                    if (target == null) {
                        return HttpUtil.createErrorStatus(2, "CF-TargetNotSet", "Target not set");
                    }
                    if (routeJSON != null) {
                        if (globalCheck != null && globalCheck.equals("true")) {
                            return new CheckRouteCommand(target, routeJSON.getString("DomainName"), routeJSON.getString("Host")).doIt();
                        }
                        return new GetRoutesCommand(target, routeJSON.getString("DomainName"), routeJSON.getString("Host")).doIt();
                    }
                    return new GetRoutesCommand(target, false).doIt();
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    RoutesHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    @Override
    protected CFJob handleDelete(Route route, HttpServletRequest request, HttpServletResponse response, final String pathString) {
        final JSONObject targetJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        final JSONObject routeJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Route"));
        final String orphaned = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Orphaned");
        final String routeId = pathString != null ? new Path(pathString).segment(0) : null;
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTargetCommand = new ComputeTargetCommand(this.userId, targetJSON);
                    computeTargetCommand.doIt();
                    Target target = computeTargetCommand.getTarget();
                    if (target == null) {
                        return HttpUtil.createErrorStatus(2, "CF-TargetNotSet", "Target not set");
                    }
                    List<Route> routes = null;
                    if (routeId != null) {
                        GetRouteByGuidCommand getRouteByGuid = new GetRouteByGuidCommand(target.getCloud(), routeId);
                        IStatus getRouteByGuidStatus = getRouteByGuid.doIt();
                        if (!getRouteByGuidStatus.isOK()) {
                            return getRouteByGuidStatus;
                        }
                        if (getRouteByGuid.getRoute() != null) {
                            routes = new ArrayList<Route>();
                            routes.add(getRouteByGuid.getRoute());
                        }
                    } else if (Boolean.parseBoolean(orphaned)) {
                        GetRoutesCommand getRoutesCommand = new GetRoutesCommand(target, true);
                        IStatus getRoutesStatus = getRoutesCommand.doIt();
                        if (!getRoutesStatus.isOK()) {
                            return getRoutesStatus;
                        }
                        routes = getRoutesCommand.getRoutes();
                    } else {
                        GetDomainsCommand getDomainsCommand = new GetDomainsCommand(target, routeJSON.getString("DomainName"));
                        IStatus getDomainsStatus = getDomainsCommand.doIt();
                        if (!getDomainsStatus.isOK()) {
                            return getDomainsStatus;
                        }
                        GetRoutesCommand getRoutesCommand = new GetRoutesCommand(target, routeJSON.getString("DomainName"), routeJSON.getString("Host"));
                        IStatus getRoutesStatus = getRoutesCommand.doIt();
                        if (!getRoutesStatus.isOK()) {
                            return getRoutesStatus;
                        }
                        routes = getRoutesCommand.getRoutes();
                    }
                    if (routes == null || routes.size() == 0) {
                        return new ServerStatus(0, 404, "Host not found", null);
                    }
                    JSONArray deletedRoutesJSON = new JSONArray();
                    for (Route route : routes) {
                        DeleteRouteCommand deleteRouteCommand = new DeleteRouteCommand(target, route);
                        IStatus deleteRouteStatus = deleteRouteCommand.doIt();
                        if (!deleteRouteStatus.isOK()) {
                            return deleteRouteStatus;
                        }
                        deletedRoutesJSON.put((Object)route.toJSON());
                    }
                    JSONObject result = new JSONObject();
                    result.put("Routes", (Object)deletedRoutesJSON);
                    return new ServerStatus(Status.OK_STATUS, 200, result);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)pathString);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    RoutesHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }
}

