/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.orion.internal.server.servlets.ChangeEvent;
import org.eclipse.orion.internal.server.servlets.IFileStoreModificationListener;

public class FilesystemModificationListenerManager {
    private static final Object INSTANCE_LOCK = new Object();
    private static FilesystemModificationListenerManager instance;
    private ConcurrentHashMap<IFileStoreModificationListener, IFileStoreModificationListener> listeners = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final FilesystemModificationListenerManager getInstance() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new FilesystemModificationListenerManager();
                instance.init();
            }
            return instance;
        }
    }

    private void init() {
    }

    public void addListener(IFileStoreModificationListener l) {
        this.listeners.put(l, l);
    }

    public IFileStoreModificationListener removeListener(IFileStoreModificationListener l) {
        if (l == null) {
            return null;
        }
        return this.listeners.remove(l);
    }

    void notifyOfChange(ChangeEvent event) {
        for (IFileStoreModificationListener l : this.listeners.keySet()) {
            try {
                l.changed(event);
            }
            catch (Exception exception) {}
        }
    }

    boolean hasListeners() {
        return !this.listeners.isEmpty();
    }
}

