/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.hosting;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.resources.Base64Counter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SiteInfo {
    private String hostHint;
    private String id;
    private JSONArray mappings = new JSONArray();
    private String name;
    private String workspaceId;

    public static JSONObject getSites(UserInfo user) {
        String sites = user.getProperty("SiteConfigurations");
        if (sites != null) {
            try {
                return new JSONObject(sites);
            }
            catch (JSONException jSONException) {}
        }
        return new JSONObject();
    }

    public static SiteInfo getSite(UserInfo user, String siteId) {
        JSONObject siteObject;
        JSONObject sites = SiteInfo.getSites(user);
        try {
            siteObject = sites.getJSONObject(siteId);
        }
        catch (JSONException jSONException) {
            return null;
        }
        return new SiteInfo(siteObject);
    }

    public static SiteInfo newSiteConfiguration(UserInfo user, String name, String workspaceId) {
        SiteInfo site = new SiteInfo();
        site.setName(name);
        site.setWorkspace(workspaceId);
        site.setId(SiteInfo.nextSiteId(user));
        return site;
    }

    private static String nextSiteId(UserInfo user) {
        Base64Counter counter = new Base64Counter();
        String userName = user.getUserName();
        JSONObject sitesObject = SiteInfo.getSites(user);
        String candidate = String.valueOf(userName) + '-' + counter.toString();
        while (sitesObject.has(candidate)) {
            counter.increment();
            candidate = String.valueOf(userName) + '-' + counter.toString();
        }
        return candidate;
    }

    private SiteInfo() {
    }

    public SiteInfo(JSONObject siteObject) {
        this.id = siteObject.optString("Id");
        this.name = siteObject.optString("Name");
        this.hostHint = siteObject.optString("HostHint");
        this.workspaceId = siteObject.optString("Workspace");
        this.mappings = siteObject.optJSONArray("Mappings");
    }

    public String getHostHint() {
        return this.hostHint;
    }

    public String getId() {
        return this.id;
    }

    public JSONArray getMappingsJSON() {
        return this.mappings;
    }

    public String getName() {
        return this.name;
    }

    public String getWorkspace() {
        return this.workspaceId;
    }

    public void save(UserInfo user) throws CoreException {
        JSONObject sites = SiteInfo.getSites(user);
        try {
            sites.put(this.getId(), (Object)this.toJSON());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        user.setProperty("SiteConfigurations", sites.toString());
        OrionConfiguration.getMetaStore().updateUser(user);
    }

    public void delete(UserInfo user) throws CoreException {
        JSONObject sites = SiteInfo.getSites(user);
        if (!sites.has(this.getId())) {
            return;
        }
        sites.remove(this.getId());
        user.setProperty("SiteConfigurations", sites.toString());
        OrionConfiguration.getMetaStore().updateUser(user);
    }

    public void setHostHint(String hint) {
        this.hostHint = hint;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMappings(JSONArray newMappings) {
        this.mappings = newMappings == null ? new JSONArray() : newMappings;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWorkspace(String workspace) {
        this.workspaceId = workspace;
    }

    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        try {
            result.put("Id", (Object)this.id);
            result.put("Name", (Object)this.name);
            result.put("HostHint", (Object)this.hostHint);
            result.put("Workspace", (Object)this.workspaceId);
            result.put("Mappings", (Object)this.mappings);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

