/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.client.response;

import org.apache.oltu.oauth2.client.response.GitHubTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;

public class OAuthClientResponseFactory {
    public static OAuthClientResponse createGitHubTokenResponse(String body, String contentType, int responseCode) throws OAuthProblemException {
        GitHubTokenResponse resp = new GitHubTokenResponse();
        resp.init(body, contentType, responseCode);
        return resp;
    }

    public static OAuthClientResponse createJSONTokenResponse(String body, String contentType, int responseCode) throws OAuthProblemException {
        OAuthJSONAccessTokenResponse resp = new OAuthJSONAccessTokenResponse();
        resp.init(body, contentType, responseCode);
        return resp;
    }

    public static <T extends OAuthClientResponse> T createCustomResponse(String body, String contentType, int responseCode, Class<T> clazz) throws OAuthSystemException, OAuthProblemException {
        OAuthClientResponse resp = (OAuthClientResponse)OAuthUtils.instantiateClassWithParameters(clazz, null, null);
        resp.init(body, contentType, responseCode);
        return (T)resp;
    }
}

