/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EditSupportFilter
implements Filter {
    private static final String FILE_SERVLET_ALIAS = "/file";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURI = httpRequest.getRequestURI();
        if (httpRequest.getServletPath().equals(FILE_SERVLET_ALIAS)) {
            String host = EditSupportFilter.getHost((ServletRequest)httpRequest);
            httpResponse.addHeader("X-Edit-Server", String.valueOf(host) + httpRequest.getContextPath() + "/edit/edit.html#");
            httpResponse.addHeader("X-Edit-Token", requestURI);
        } else {
            String selfHostPath = System.getProperty("org.eclipse.orion.server.core.selfHostPath");
            if (selfHostPath != null) {
                String host = EditSupportFilter.getHost((ServletRequest)httpRequest);
                httpResponse.addHeader("X-Edit-Server", String.valueOf(host) + httpRequest.getContextPath() + "/edit/edit.html#");
                httpResponse.addHeader("X-Edit-Token", String.valueOf(httpRequest.getContextPath()) + FILE_SERVLET_ALIAS + selfHostPath + requestURI);
            }
        }
        chain.doFilter(request, response);
    }

    private static String getHost(ServletRequest request) {
        return String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort();
    }

    public void destroy() {
    }
}

