/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;

public class ServletStatusHandler
extends ServletResourceHandler<IStatus> {
    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, IStatus error) throws ServletException {
        ServerStatus serverStatus;
        int httpCode = 500;
        if (error instanceof ServerStatus) {
            serverStatus = (ServerStatus)error;
            httpCode = serverStatus.getHttpCode();
        } else {
            serverStatus = new ServerStatus(error, httpCode);
        }
        response.setCharacterEncoding("UTF-8");
        if ("TIAM".equals(PreferenceHelper.getString((String)"orion.auth.name", null))) {
            if (httpCode == 500) {
                httpCode = 599;
            }
            if (httpCode == 404) {
                httpCode = 410;
            }
        }
        response.setStatus(httpCode);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("application/json; charset=UTF-8");
        try {
            response.getWriter().print(serverStatus.toJSON().toString());
        }
        catch (IOException iOException) {
            throw new ServletException(error.getMessage(), error.getException());
        }
        return true;
    }
}

