/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteApplicationRoutesCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Delete application route";
    private String appName;
    private App app;

    public DeleteApplicationRoutesCommand(Target target, App app) {
        super(target);
        this.app = app;
    }

    @Override
    protected ServerStatus _doIt() {
        MultiServerStatus status = new MultiServerStatus();
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String appsUrl = this.target.getSpace().getCFJSON().getJSONObject("entity").getString("apps_url");
            URI appsURI = targetURI.resolve(appsUrl);
            GetMethod getAppsMethod = new GetMethod(appsURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getAppsMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            getAppsMethod.setQueryString("q=name:" + this.appName + "&inline-relations-depth=1");
            ServerStatus appsStatus = HttpUtil.executeMethod((HttpMethodBase)getAppsMethod);
            status.add(appsStatus);
            if (!status.isOK()) {
                return status;
            }
            JSONObject jsonData = appsStatus.getJsonData();
            if (!jsonData.has("resources") || jsonData.getJSONArray("resources").length() == 0) {
                return new ServerStatus(4, 404, "Application not found", null);
            }
            JSONArray apps = jsonData.getJSONArray("resources");
            String routesUrl = apps.getJSONObject(0).getJSONObject("entity").getString("routes_url");
            URI routesURI = targetURI.resolve(routesUrl);
            GetMethod getRoutesMethod = new GetMethod(routesURI.toString());
            confStatus = HttpUtil.configureHttpMethod((HttpMethod)getRoutesMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            ServerStatus routesStatus = HttpUtil.executeMethod((HttpMethodBase)getRoutesMethod);
            status.add(routesStatus);
            if (!status.isOK()) {
                return status;
            }
            jsonData = routesStatus.getJsonData();
            if (!jsonData.has("resources") || jsonData.getJSONArray("resources").length() == 0) {
                return new ServerStatus(0, 200, "No routes for the app", null);
            }
            JSONArray routes = jsonData.getJSONArray("resources");
            int i = 0;
            while (i < routes.length()) {
                JSONObject route = routes.getJSONObject(i);
                String routeUrl = route.getJSONObject("metadata").getString("url");
                URI routeURI = targetURI.resolve(routeUrl);
                DeleteMethod deleteRouteMethod = new DeleteMethod(routeURI.toString());
                confStatus = HttpUtil.configureHttpMethod((HttpMethod)deleteRouteMethod, this.target.getCloud());
                if (!confStatus.isOK()) {
                    return confStatus;
                }
                ServerStatus deleteStatus = HttpUtil.executeMethod((HttpMethodBase)deleteRouteMethod);
                status.add(deleteStatus);
                if (!status.isOK()) {
                    return status;
                }
                ++i;
            }
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    @Override
    protected IStatus validateParams() {
        try {
            ManifestParseTree manifest = this.app.getManifest();
            ManifestParseTree manifestApp = manifest.get("applications").get(0);
            if (this.app.getName() != null) {
                this.appName = this.app.getName();
                return Status.OK_STATUS;
            }
            this.appName = manifestApp.get("name").getValue();
            return Status.OK_STATUS;
        }
        catch (InvalidAccessException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
    }
}

