/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.metastore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.resources.FileLocker;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMetaStoreUtil {
    public static final String ARCHIVE = ".archive";
    public static final String FILE_SCHEMA = "file";
    public static final String METAFILE_EXTENSION = ".json";
    public static String OPERATING_SYSTEM_NAME = System.getProperty("os.name").toLowerCase();
    public static final String SEPARATOR = "-";
    public static final String SERVERWORKSPACE = "${SERVERWORKSPACE}";
    public static final String USER = "user";

    protected static void archive(File root, File file) {
        String filePath;
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
        if (!SimpleMetaStoreUtil.isMetaFolder(root, ARCHIVE) && !SimpleMetaStoreUtil.createMetaFolder(root, ARCHIVE)) {
            logger.error("SimpleMetaStore.archive: could not create archive folder at: " + root.toString() + File.separator + ARCHIVE);
            return;
        }
        String parentPath = root.toString();
        File archive = SimpleMetaStoreUtil.retrieveMetaFolder(root, ARCHIVE);
        File archivedMetaFile = new File(archive, filePath = file.toString().substring(parentPath.length()));
        File archivedMetaFileParentFolder = archivedMetaFile.getParentFile();
        if (!archivedMetaFileParentFolder.exists()) {
            archivedMetaFileParentFolder.mkdirs();
        }
        if (archivedMetaFile.exists() && file.isDirectory()) {
            file.delete();
            logger.error("Meta File Error, root contains invalid metadata: empty folder " + file.toString() + " deleted.");
        } else {
            file.renameTo(archivedMetaFile);
            if (archivedMetaFile.isDirectory()) {
                logger.error("Meta File Error, root contains invalid metadata: folder " + file.toString() + " archived to " + archivedMetaFile.toString());
            } else {
                logger.error("Meta File Error, root contains invalid metadata: file " + file.toString() + " archived to " + archivedMetaFile.toString());
            }
        }
    }

    public static boolean createMetaFile(File parent, String name, JSONObject jsonObject) {
        try {
            if (SimpleMetaStoreUtil.isMetaFile(parent, name)) {
                File savedFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
                throw new RuntimeException("Meta File Error, file " + savedFile.toString() + " already exists, use update");
            }
            if (!parent.exists()) {
                throw new RuntimeException("Meta File Error, parent folder does not exist");
            }
            if (!parent.isDirectory()) {
                throw new RuntimeException("Meta File Error, parent is not a folder");
            }
            File newFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
            FileLocker locker = new FileLocker(newFile);
            try {
                locker.lock();
            }
            catch (IOException e) {
                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
                logger.error("Meta File Error, file IO error, could not lock the file", (Throwable)e);
                throw new RuntimeException("Meta File Error, file IO error, could not lock the file", e);
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(newFile);
                Charset utf8 = Charset.forName("UTF-8");
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, utf8);
                outputStreamWriter.write(jsonObject.toString(4));
                outputStreamWriter.write("\n");
                outputStreamWriter.flush();
                outputStreamWriter.close();
                fileOutputStream.close();
            }
            finally {
                locker.release();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.error("Meta File Error, cannot create file under " + parent.toString() + ": invalid file name: " + name);
            return false;
        }
        catch (IOException e) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.error("Meta File Error, file IO error", (Throwable)e);
            throw new RuntimeException("Meta File Error, file IO error", e);
        }
        catch (JSONException e) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.error("Meta File Error, cannot create JSON file " + parent.toString() + File.separator + name + METAFILE_EXTENSION + " from disk, reason: " + e.getLocalizedMessage());
            throw new RuntimeException("Meta File Error, JSON error", e);
        }
        return true;
    }

    public static boolean createMetaFolder(File parent, String name) {
        if (!parent.exists()) {
            throw new RuntimeException("Meta File Error, parent folder does not exist");
        }
        if (!parent.isDirectory()) {
            throw new RuntimeException("Meta File Error, parent is not a folder");
        }
        File newFolder = new File(parent, name);
        if (newFolder.exists()) {
            return true;
        }
        if (!newFolder.mkdir()) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.warn("Meta File Error, cannot create folder under " + newFolder.toString() + ": invalid folder name: " + name);
            return false;
        }
        return true;
    }

    public static boolean createMetaUserFolder(File parent, String userName) {
        if (!parent.exists()) {
            throw new RuntimeException("Meta File Error, parent folder does not exist");
        }
        if (!parent.isDirectory()) {
            throw new RuntimeException("Meta File Error, parent is not a folder");
        }
        String userPrefix = userName.substring(0, Math.min(2, userName.length()));
        File orgFolder = new File(parent, userPrefix);
        if (!orgFolder.exists() && !orgFolder.mkdir()) {
            throw new RuntimeException("Meta File Error, cannot create folder");
        }
        return SimpleMetaStoreUtil.createMetaFolder(orgFolder, userName);
    }

    public static String decodeProjectContentLocation(String contentLocation) {
        if (!contentLocation.startsWith(SERVERWORKSPACE)) {
            return contentLocation;
        }
        String root = OrionConfiguration.getRootLocation().toURI().toString();
        String decodedcontentLocation = contentLocation.replace(SERVERWORKSPACE, root);
        return decodedcontentLocation;
    }

    public static String decodeProjectNameFromProjectId(String projectId) {
        if (OPERATING_SYSTEM_NAME.contains("windows")) {
            return projectId.replaceAll("---", "\\|");
        }
        return projectId;
    }

    public static String decodeUserIdFromWorkspaceId(String workspaceId) {
        if (workspaceId.lastIndexOf(SEPARATOR) == -1) {
            return null;
        }
        return workspaceId.substring(0, workspaceId.lastIndexOf(SEPARATOR));
    }

    public static String decodeWorkspaceNameFromWorkspaceId(String workspaceId) {
        if (workspaceId.lastIndexOf(SEPARATOR) == -1) {
            return null;
        }
        return workspaceId.substring(workspaceId.lastIndexOf(SEPARATOR) + 1);
    }

    public static boolean deleteMetaFile(File parent, String name) {
        if (!SimpleMetaStoreUtil.isMetaFile(parent, name)) {
            throw new RuntimeException("Meta File Error, cannot delete, does not exist.");
        }
        File savedFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
        FileLocker locker = new FileLocker(savedFile);
        try {
            try {
                locker.lock();
                if (!savedFile.delete()) {
                    throw new RuntimeException("Meta File Error, cannot delete file.");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Meta File Error, cannot delete file.", e);
            }
        }
        finally {
            locker.release();
        }
        return true;
    }

    public static boolean deleteMetaFolder(File parent, String name, boolean exceptionWhenNotEmpty) {
        if (!SimpleMetaStoreUtil.isMetaFolder(parent, name)) {
            throw new RuntimeException("Meta File Error, cannot delete, does not exist.");
        }
        File folder = SimpleMetaStoreUtil.retrieveMetaFolder(parent, name);
        if (!folder.delete()) {
            if (exceptionWhenNotEmpty) {
                throw new RuntimeException("Meta File Error, cannot delete, not empty.");
            }
            return false;
        }
        return true;
    }

    public static boolean deleteMetaUserFolder(File parent, String userName) {
        String[] files = parent.list();
        if (files.length != 0) {
            throw new RuntimeException("Meta File Error, cannot delete, not empty.");
        }
        if (!parent.delete()) {
            throw new RuntimeException("Meta File Error, cannot delete folder.");
        }
        File orgFolder = parent.getParentFile();
        files = orgFolder.list();
        if (files.length != 0) {
            return true;
        }
        if (!orgFolder.delete()) {
            throw new RuntimeException("Meta File Error, cannot delete folder.");
        }
        return true;
    }

    public static String encodeProjectContentLocation(String contentLocation) {
        if (!contentLocation.startsWith(FILE_SCHEMA)) {
            return contentLocation;
        }
        String root = OrionConfiguration.getRootLocation().toURI().toString();
        if (contentLocation.startsWith(root)) {
            String encodedcontentLocation = SERVERWORKSPACE.concat(contentLocation.substring(root.length()));
            return encodedcontentLocation;
        }
        return contentLocation;
    }

    public static String encodeProjectIdFromProjectName(String projectName) {
        if (OPERATING_SYSTEM_NAME.contains("windows")) {
            return projectName.replaceAll("\\|", "---");
        }
        return projectName;
    }

    public static String encodeWorkspaceId(String userName, String workspaceName) {
        String workspaceId = workspaceName.replace(" ", "").replace("#", "").replaceAll(SEPARATOR, "");
        return String.valueOf(userName) + SEPARATOR + workspaceId;
    }

    public static boolean isMetaFile(File parent, String name) {
        return SimpleMetaStoreUtil.retrieveMetaFile(parent, name).isFile();
    }

    public static boolean isMetaFolder(File parent, String name) {
        return SimpleMetaStoreUtil.retrieveMetaFolder(parent, name).isDirectory();
    }

    public static boolean isMetaUserFolder(File parent, String userName) {
        if (!parent.exists()) {
            throw new RuntimeException("Meta File Error, parent folder does not exist");
        }
        if (!parent.isDirectory()) {
            throw new RuntimeException("Meta File Error, parent is not a folder");
        }
        String userPrefix = userName.substring(0, Math.min(2, userName.length()));
        File orgFolder = new File(parent, userPrefix);
        if (!orgFolder.exists()) {
            return false;
        }
        if (!SimpleMetaStoreUtil.isMetaFolder(orgFolder, userName)) {
            return false;
        }
        File userFolder = SimpleMetaStoreUtil.retrieveMetaFolder(orgFolder, userName);
        return SimpleMetaStoreUtil.isMetaFile(userFolder, USER);
    }

    public static List<String> listMetaFiles(File parent) {
        ArrayList<String> savedFiles = new ArrayList<String>();
        File[] fileArray = parent.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                savedFiles.add(file.getName());
            } else if (!file.isFile() || !file.getName().endsWith(METAFILE_EXTENSION)) {
                throw new RuntimeException("Meta File Error, contains invalid metadata:" + parent.toString() + " at " + file.getName());
            }
            ++n2;
        }
        return savedFiles;
    }

    public static List<String> listMetaUserFolders(File parent) {
        ArrayList<String> userMetaFolders = new ArrayList<String>();
        File[] fileArray = parent.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.canRead()) {
                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
                logger.error("Cannot read folder, check directory permissions of " + file.getAbsolutePath());
            } else if (!(file.getName().equals(".metadata") || file.getName().equals("orion.conf") || file.getName().equals(ARCHIVE) || file.isFile() && file.getName().endsWith(METAFILE_EXTENSION) && file.getName().startsWith("metastore"))) {
                if (file.isDirectory() && file.getName().length() <= 2) {
                    File orgFolder = file;
                    if (file.list().length == 0) {
                        SimpleMetaStoreUtil.archive(parent, orgFolder);
                    } else {
                        File[] fileArray2 = orgFolder.listFiles();
                        int n3 = fileArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File userFolder = fileArray2[n4];
                            if (SimpleMetaStoreUtil.isMetaUserFolder(parent, userFolder.getName())) {
                                userMetaFolders.add(userFolder.getName());
                            } else if (!userFolder.canRead()) {
                                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
                                logger.error("Cannot read folder, check directory permissions of " + userFolder.getAbsolutePath());
                            } else {
                                SimpleMetaStoreUtil.archive(parent, userFolder);
                            }
                            ++n4;
                        }
                    }
                } else {
                    SimpleMetaStoreUtil.archive(parent, file);
                }
            }
            ++n2;
        }
        return userMetaFolders;
    }

    public static boolean moveMetaFile(File parent, String oldName, String newName) {
        if (!SimpleMetaStoreUtil.isMetaFile(parent, oldName)) {
            return false;
        }
        File oldFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, oldName);
        File newFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, newName);
        return oldFile.renameTo(newFile);
    }

    public static boolean moveMetaFolder(File parent, String oldName, String newName) {
        if (!SimpleMetaStoreUtil.isMetaFolder(parent, oldName)) {
            return false;
        }
        File oldFolder = SimpleMetaStoreUtil.retrieveMetaFolder(parent, oldName);
        File newFolder = SimpleMetaStoreUtil.retrieveMetaFolder(parent, newName);
        return oldFolder.renameTo(newFolder);
    }

    public static boolean moveUserMetaFolder(File oldUserMetaFolder, File newUserMetaFolder) {
        if (!oldUserMetaFolder.exists()) {
            throw new RuntimeException("Meta File Error, parent folder does not exist");
        }
        if (!oldUserMetaFolder.isDirectory()) {
            throw new RuntimeException("Meta File Error, parent is not a folder");
        }
        if (newUserMetaFolder.exists()) {
            throw new RuntimeException("Meta File Error, new folder already exists");
        }
        File orgFolder = newUserMetaFolder.getParentFile();
        if (!orgFolder.exists() && !orgFolder.mkdir()) {
            throw new RuntimeException("Meta File Error, mkdir failed for " + orgFolder.toString());
        }
        if (!oldUserMetaFolder.renameTo(newUserMetaFolder)) {
            throw new RuntimeException("Meta File Error, renameTo failed");
        }
        orgFolder = oldUserMetaFolder.getParentFile();
        String[] files = orgFolder.list();
        if (files.length != 0) {
            return true;
        }
        if (!orgFolder.delete()) {
            throw new RuntimeException("Meta File Error, cannot delete folder.");
        }
        return true;
    }

    public static JSONObject readMetaFile(File parent, String name) {
        JSONObject jsonObject;
        block8: {
            if (SimpleMetaStoreUtil.isMetaFile(parent, name)) break block8;
            return null;
        }
        try {
            File savedFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
            char[] chars = new char[(int)savedFile.length()];
            FileLocker locker = new FileLocker(savedFile);
            locker.lock();
            try {
                FileInputStream fileInputStream = new FileInputStream(savedFile);
                Charset utf8 = Charset.forName("UTF-8");
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, utf8);
                inputStreamReader.read(chars);
                inputStreamReader.close();
                fileInputStream.close();
            }
            finally {
                locker.release();
            }
            jsonObject = new JSONObject(new String(chars));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Meta File Error, file not found", e);
        }
        catch (IOException e) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.error("Meta File Error, file IO error", (Throwable)e);
            throw new RuntimeException("Meta File Error, file IO error", e);
        }
        catch (JSONException e) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.error("Meta File Error, cannot read JSON file " + parent.toString() + File.separator + name + METAFILE_EXTENSION + " from disk, reason: " + e.getLocalizedMessage());
            return null;
        }
        return jsonObject;
    }

    public static File readMetaFolder(File parent, String name) {
        if (!SimpleMetaStoreUtil.isMetaFolder(parent, name)) {
            return null;
        }
        return SimpleMetaStoreUtil.retrieveMetaFolder(parent, name);
    }

    public static File readMetaUserFolder(File parent, String userName) {
        String userPrefix = userName.substring(0, Math.min(2, userName.length()));
        File orgFolder = new File(parent, userPrefix);
        return new File(orgFolder, userName);
    }

    public static File retrieveMetaFile(File parent, String name) {
        return new File(parent, String.valueOf(name) + METAFILE_EXTENSION);
    }

    public static File retrieveMetaFolder(File parent, String name) {
        return new File(parent, name);
    }

    public static boolean updateMetaFile(File parent, String name, JSONObject jsonObject) {
        try {
            if (!SimpleMetaStoreUtil.isMetaFile(parent, name)) {
                throw new RuntimeException("Meta File Error, cannot update, does not exist.");
            }
            File savedFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, name);
            FileLocker locker = new FileLocker(savedFile);
            locker.lock();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(savedFile);
                Charset utf8 = Charset.forName("UTF-8");
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, utf8);
                outputStreamWriter.write(jsonObject.toString(4));
                outputStreamWriter.write("\n");
                outputStreamWriter.flush();
                outputStreamWriter.close();
                fileOutputStream.close();
            }
            finally {
                locker.release();
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Meta File Error, file not found", e);
        }
        catch (IOException e) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.error("Meta File Error, file IO error", (Throwable)e);
            throw new RuntimeException("Meta File Error, file IO error", e);
        }
        catch (JSONException e) {
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.error("Meta File Error, cannot update JSON file " + parent.toString() + File.separator + name + METAFILE_EXTENSION + " from disk, reason: " + e.getLocalizedMessage());
            throw new RuntimeException("Meta File Error, JSON error", e);
        }
        return true;
    }

    public static boolean moveMetaFolder(File parent, String oldName, File newParent, String newName) {
        if (!SimpleMetaStoreUtil.isMetaFolder(parent, oldName)) {
            throw new RuntimeException("Meta File Error, folder " + oldName + " not found in folder " + parent.getAbsolutePath(), null);
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new RuntimeException("Meta File Error, folder does not exist " + newParent.getAbsolutePath(), null);
        }
        File oldFolder = SimpleMetaStoreUtil.retrieveMetaFolder(parent, oldName);
        File newFolder = SimpleMetaStoreUtil.retrieveMetaFolder(newParent, newName);
        return oldFolder.renameTo(newFolder);
    }

    public static boolean moveMetaFile(File parent, String oldName, File newParent, String newName) {
        if (!SimpleMetaStoreUtil.isMetaFile(parent, oldName)) {
            throw new RuntimeException("Meta File Error, file " + oldName + " not found in folder " + parent.toString(), null);
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new RuntimeException("Meta File Error, folder does not exist " + newParent.toString(), null);
        }
        if (SimpleMetaStoreUtil.isMetaFile(newParent, newName)) {
            throw new RuntimeException("Meta File Error, cannot move, file " + newName + " already exists in folder " + newParent.toString(), null);
        }
        File oldMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(parent, oldName);
        File newMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(newParent, newName);
        return oldMetaFile.renameTo(newMetaFile);
    }
}

