/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSFontManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class Font
extends Resource {
    public NSFont handle;
    public int extraTraits;
    FontMetrics metrics = null;
    static final double SYNTHETIC_BOLD = -2.5;
    static final double SYNTHETIC_ITALIC = 0.2;

    Font(Device device) {
        super(device);
    }

    public Font(Device device, FontData fd) {
        super(device);
        if (fd == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(fd.getName(), fd.getHeightF(), fd.getStyle(), fd.nsName);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Font(Device device, FontData[] fds) {
        super(device);
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        int i = 0;
        while (i < fds.length) {
            if (fds[i] == null) {
                SWT.error(5);
            }
            ++i;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            FontData fd = fds[0];
            this.init(fd.getName(), fd.getHeightF(), fd.getStyle(), fd.nsName);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Font(Device device, String name, int height, int style) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(name, height, style, null);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    Font(Device device, String name, float height, int style) {
        super(device);
        this.init(name, height, style, null);
        this.init();
    }

    void addTraits(NSMutableAttributedString attrStr, NSRange range) {
        if ((this.extraTraits & 2) != 0) {
            attrStr.addAttribute(OS.NSStrokeWidthAttributeName, NSNumber.numberWithDouble(-2.5), range);
        }
        if ((this.extraTraits & 1) != 0) {
            attrStr.addAttribute(OS.NSObliquenessAttributeName, NSNumber.numberWithDouble(0.2), range);
        }
    }

    void addTraits(NSMutableDictionary dict) {
        if ((this.extraTraits & 2) != 0) {
            dict.setObject(NSNumber.numberWithDouble(-2.5), OS.NSStrokeWidthAttributeName);
        }
        if ((this.extraTraits & 1) != 0) {
            dict.setObject(NSNumber.numberWithDouble(0.2), OS.NSObliquenessAttributeName);
        }
    }

    void destroy() {
        this.handle.release();
        this.handle = null;
        this.metrics = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.handle == font.handle;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSString family = this.handle.familyName();
            String name = family.getString();
            NSString str = this.handle.fontName();
            String nsName = str.getString();
            NSFontManager manager = NSFontManager.sharedFontManager();
            int traits = manager.traitsOfFont(this.handle);
            int style = 0;
            if ((traits & 1) != 0) {
                style |= 2;
            }
            if ((traits & 2) != 0) {
                style |= 1;
            }
            if ((this.extraTraits & 1) != 0) {
                style |= 2;
            }
            if ((this.extraTraits & 2) != 0) {
                style |= 1;
            }
            Point dpi = this.device.dpi;
            Point screenDPI = this.device.getScreenDPI();
            FontData data = new FontData(name, this.handle.pointSize() * (float)screenDPI.y / (float)dpi.y, style);
            data.nsName = nsName;
            FontData[] fontDataArray = new FontData[]{data};
            return fontDataArray;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public static Font cocoa_new(Device device, NSFont handle) {
        Font font = new Font(device);
        font.handle = handle;
        return font;
    }

    public int hashCode() {
        return this.handle != null ? this.handle.id : 0;
    }

    void init(String name, float height, int style, String nsName) {
        if (name == null) {
            SWT.error(4);
        }
        if (height < 0.0f) {
            SWT.error(5);
        }
        Point dpi = this.device.dpi;
        Point screenDPI = this.device.getScreenDPI();
        float size = height * (float)dpi.y / (float)screenDPI.y;
        if (nsName != null) {
            this.handle = NSFont.fontWithName(NSString.stringWith(nsName), size);
        } else {
            NSString family = NSString.stringWith(name);
            NSFont nsFont = NSFont.fontWithName(family, size);
            if (nsFont == null) {
                nsFont = NSFont.systemFontOfSize(size);
            }
            NSFontManager manager = NSFontManager.sharedFontManager();
            if (nsFont != null) {
                if ((style & 3) == 0) {
                    this.handle = nsFont;
                } else {
                    int traits = 0;
                    if ((style & 2) != 0) {
                        traits |= 1;
                    }
                    if ((style & 1) != 0) {
                        traits |= 2;
                    }
                    this.handle = manager.convertFont(nsFont, traits);
                    if ((style & 2) != 0 && (this.handle == null || (manager.traitsOfFont(this.handle) & 1) == 0)) {
                        traits &= 0xFFFFFFFE;
                        this.handle = null;
                        if ((style & 1) != 0) {
                            this.handle = manager.convertFont(nsFont, traits);
                        }
                    }
                    if ((style & 1) != 0 && this.handle == null) {
                        traits &= 0xFFFFFFFD;
                        if ((style & 2) != 0) {
                            this.handle = manager.convertFont(nsFont, traits |= 1);
                        }
                    }
                    if (this.handle == null) {
                        this.handle = nsFont;
                    }
                }
            }
            if (this.handle == null) {
                this.handle = NSFont.systemFontOfSize(size);
            }
            if ((style & 2) != 0 && (manager.traitsOfFont(this.handle) & 1) == 0) {
                this.extraTraits |= 1;
            }
            if ((style & 1) != 0 && (manager.traitsOfFont(this.handle) & 2) == 0) {
                this.extraTraits |= 2;
            }
        }
        if (this.handle == null) {
            this.handle = this.device.systemFont.handle;
        }
        this.handle.retain();
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

