/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.SubmoduleStatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.submodule.SubmoduleStatus;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.server.core.resources.JSONSerializer;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.Serializer;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Clone")
public class Clone {
    public static final String RESOURCE = "clone";
    public static final String TYPE = "Clone";
    private String id;
    private URI contentLocation;
    private URIish uriish;
    private String name;
    private URI baseLocation;
    private String cloneUrl;
    private IPath path;
    private JSONArray parents;
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    protected Serializer<JSONObject> jsonSerializer;

    public Clone() {
        Property[] defaultProperties = new Property[]{new Property("Name"), new Property("Location"), new Property("ContentLocation"), new Property("RemoteLocation"), new Property("ConfigLocation"), new Property("HeadLocation"), new Property("CommitLocation"), new Property("BranchLocation"), new Property("TagLocation"), new Property("IndexLocation"), new Property("StashLocation"), new Property("PullRequestLocation"), new Property("StatusLocation"), new Property("DiffLocation"), new Property("GitUrl"), new Property("Children"), new Property("Parents"), new Property("SubmoduleLocation")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.jsonSerializer = new JSONSerializer();
    }

    public void setId(String id) {
        this.id = id;
    }

    private String getId() {
        return this.id;
    }

    public void setContentLocation(URI contentURI) {
        this.contentLocation = contentURI;
    }

    public URI getContentLocation() {
        return this.contentLocation;
    }

    public void setUrl(URIish gitURI) {
        this.uriish = gitURI;
    }

    public String getUrl() {
        return this.uriish.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    @PropertyDescription(name="Name")
    public String getName() {
        return this.name;
    }

    public void setBaseLocation(URI baseLocation) {
        this.baseLocation = baseLocation;
    }

    public JSONObject toJSON() throws URISyntaxException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="Location")
    private URI getLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append(RESOURCE).append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="ContentLocation")
    private URI getContentLocation2() throws URISyntaxException {
        IPath np = new Path(this.getId()).makeAbsolute();
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="RemoteLocation")
    private URI getRemoteLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("remote").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="ConfigLocation")
    private URI getConfigLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("config").append(RESOURCE).append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="HeadLocation")
    private URI getHeadLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("commit").append("HEAD").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="SubmoduleLocation")
    private URI getSubmoduleLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("submodule").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="CommitLocation")
    private URI getCommitLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("commit").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="PullRequestLocation")
    private URI getPullRequestLocation() throws URISyntaxException {
        String url = this.cloneUrl;
        if (url != null && GitUtils.isInGithub(url)) {
            IPath np = new Path("/gitapi").append("pullRequest").append(this.getId());
            return this.createUriWithPath(np);
        }
        return null;
    }

    @PropertyDescription(name="BranchLocation")
    private URI getBranchLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("branch").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="TagLocation")
    private URI getTagLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("tag").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="IndexLocation")
    private URI getIndexLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("index").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="StashLocation")
    private URI getIgnoreLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("stash").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="StatusLocation")
    private URI getStatusLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("status").append(this.getId());
        return this.createUriWithPath(np);
    }

    @PropertyDescription(name="DiffLocation")
    private URI getDiffLocation() throws URISyntaxException {
        IPath np = new Path("/gitapi").append("diff").append("Default").append(this.getId());
        return this.createUriWithPath(np);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PropertyDescription(name="Children")
    private JSONArray getChildren() throws URISyntaxException, IOException, CoreException, JSONException, GitAPIException {
        if (this.path == null) {
            return null;
        }
        IFileStore fileStore = NewFileServlet.getFileStore(null, (IPath)this.path);
        if (fileStore == null) {
            return null;
        }
        File localFile = fileStore.toLocalFile(0, null);
        File gitModule = new File(localFile, ".gitmodules");
        JSONArray submodules = null;
        if (!gitModule.exists() || gitModule.isDirectory()) return submodules;
        submodules = new JSONArray();
        Repository parentRepository = null;
        try {
            try {
                parentRepository = FileRepositoryBuilder.create((File)GitUtils.resolveGitDir(localFile));
                SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)parentRepository);
                while (walk.next()) {
                    String cloneUrl = walk.getRepository() != null ? GitUtils.getCloneUrl(walk.getRepository()) : walk.getRemoteUrl();
                    JSONArray newParents = this.parents == null ? new JSONArray() : new JSONArray(this.parents.toString());
                    newParents.put((Object)this.getLocation().getPath());
                    JSONObject submoduleCloneJSON = new Clone().toJSON(this.path.append(walk.getPath()).addTrailingSeparator(), this.baseLocation, cloneUrl, newParents);
                    SubmoduleStatus ss = (SubmoduleStatus)new SubmoduleStatusCommand(parentRepository).addPath(walk.getModulesPath()).call().values().iterator().next();
                    if (ss != null) {
                        JSONObject submoduleStatus = new JSONObject();
                        submoduleStatus.put("Type", (Object)ss.getType().toString());
                        submoduleStatus.put("Path", (Object)ss.getPath());
                        if (ss.getHeadId() != null) {
                            submoduleStatus.put("HeadSHA", (Object)ss.getHeadId().getName());
                        }
                        submoduleCloneJSON.put("SubmoduleStatus", (Object)submoduleStatus);
                    }
                    submodules.put((Object)submoduleCloneJSON);
                }
                walk.close();
                submodules = submodules.length() > 0 ? submodules : null;
                return submodules;
            }
            catch (ConfigInvalidException configInvalidException) {
                if (parentRepository == null) return submodules;
                parentRepository.close();
                return submodules;
            }
            catch (IOException iOException) {
                if (parentRepository == null) return submodules;
                parentRepository.close();
                return submodules;
            }
        }
        finally {
            if (parentRepository != null) {
                parentRepository.close();
            }
        }
    }

    @PropertyDescription(name="Parents")
    private JSONArray getParents() throws URISyntaxException, IOException, CoreException {
        return this.parents;
    }

    @PropertyDescription(name="GitUrl")
    private String getCloneUrl() {
        return this.cloneUrl;
    }

    private URI createUriWithPath(IPath path) throws URISyntaxException {
        return new URI(this.baseLocation.getScheme(), this.baseLocation.getUserInfo(), this.baseLocation.getHost(), this.baseLocation.getPort(), path.toString(), this.baseLocation.getQuery(), this.baseLocation.getFragment());
    }

    public JSONObject toJSON(IPath path, URI baseLocation, String cloneUrl) throws IOException, URISyntaxException {
        return this.toJSON(path, baseLocation, cloneUrl, null);
    }

    public JSONObject toJSON(IPath path, URI baseLocation, String cloneUrl, JSONArray parents) throws IOException, URISyntaxException {
        this.id = "/file/" + path.toString();
        this.name = path.lastSegment();
        this.path = path;
        this.cloneUrl = cloneUrl;
        this.baseLocation = baseLocation;
        this.parents = parents;
        return this.toJSON();
    }
}

