/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.metastore;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetadataInfo {
    protected static final List<String> EMPTY = Collections.emptyList();
    public static final String UNIQUE_ID = "UniqueId";
    private String fullName;
    private String id;
    private final Map<String, OperationType> operations = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> properties = Collections.synchronizedMap(new HashMap());

    public void flush() {
        this.operations.clear();
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public Map<String, OperationType> getOperations() {
        return Collections.unmodifiableMap(this.operations);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getUniqueId() {
        return this.id;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String setProperty(String key, String value) {
        if (value == null) {
            if (this.properties.containsKey(key)) {
                this.operations.put(key, OperationType.DELETE);
            }
            return this.properties.remove(key);
        }
        if (this.properties.containsKey(key)) {
            this.operations.put(key, OperationType.UPDATE);
        } else {
            this.operations.put(key, OperationType.CREATE);
        }
        return this.properties.put(key, value);
    }

    public void setUniqueId(String id) {
        this.id = id;
    }

    public static enum OperationType {
        CREATE,
        UPDATE,
        DELETE;

    }
}

