/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.objects;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.FileAppender;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.core.resources.JSONSerializer;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.Serializer;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.json.JSONObject;

@ResourceDescription(type="FileAppender")
public class FileAppenderResource {
    public static final String RESOURCE = "fileAppender";
    public static final String TYPE = "FileAppender";
    protected static ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    protected Serializer<JSONObject> jsonSerializer;
    protected URI baseLocation;
    protected String name;
    protected boolean isAppend;
    protected boolean isPrudent;
    protected boolean isStarted;

    public FileAppenderResource(FileAppender<ILoggingEvent> fileAppender, URI baseLocation) {
        Property[] defaultProperties = new Property[]{new Property("Name"), new Property("Location"), new Property("Name"), new Property("IsAppend"), new Property("IsPrudent"), new Property("IsStarted")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.jsonSerializer = new JSONSerializer();
        this.baseLocation = baseLocation;
        this.name = fileAppender.getName();
        this.isAppend = fileAppender.isAppend();
        this.isPrudent = fileAppender.isPrudent();
        this.isStarted = fileAppender.isStarted();
    }

    protected URI createUriWithPath(IPath path) throws URISyntaxException {
        return new URI(this.baseLocation.getScheme(), this.baseLocation.getUserInfo(), this.baseLocation.getHost(), this.baseLocation.getPort(), path.toString(), this.baseLocation.getQuery(), this.baseLocation.getFragment());
    }

    public JSONObject toJSON() throws URISyntaxException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @PropertyDescription(name="IsAppend")
    public boolean isAppend() {
        return this.isAppend;
    }

    public void setAppend(boolean isAppend) {
        this.isAppend = isAppend;
    }

    @PropertyDescription(name="IsPrudent")
    public boolean isPrudent() {
        return this.isPrudent;
    }

    public void setPrudent(boolean isPrudent) {
        this.isPrudent = isPrudent;
    }

    @PropertyDescription(name="IsStarted")
    public boolean isStarted() {
        return this.isStarted;
    }

    public void setStarted(boolean isStarted) {
        this.isStarted = isStarted;
    }

    public void setBaseLocation(URI baseLocation) {
        this.baseLocation = baseLocation;
    }

    @PropertyDescription(name="Location")
    public URI getLocation() throws URISyntaxException {
        IPath path = new Path("/logapi").append(RESOURCE).append(this.getName());
        return this.createUriWithPath(path);
    }
}

