/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.PrintWriter;
import java.net.URLEncoder;
import java.sql.Date;
import java.text.SimpleDateFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.osgi.util.NLS;

public class GenericDirectoryHandler
extends ServletResourceHandler<IFileStore> {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, IFileStore dir) throws ServletException {
        block6: {
            if (GenericDirectoryHandler.getMethod(request) != ServletResourceHandler.Method.GET) {
                return false;
            }
            try {
                response.setCharacterEncoding("UTF-8");
                response.setHeader("Cache-Control", "no-cache");
                response.setContentType("text/html;charset=UTF-8");
                String path = request.getPathInfo();
                IFileStore[] children = dir.childStores(0, null);
                PrintWriter writer = response.getWriter();
                writer.println("<!DOCTYPE HTML>");
                writer.println("<html>");
                writer.println(" <head>");
                writer.println("<title>Index of " + path + "</title>");
                writer.println("</head>");
                writer.println("<body>");
                writer.println("<h1>Index of " + path + "</h1>");
                writer.println("<pre>Name                          Last modified\t\tSize  ");
                writer.println("<hr>");
                IFileStore[] iFileStoreArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore child = iFileStoreArray[n2];
                    IFileInfo childInfo = child.fetchInfo(0, null);
                    String childName = child.getName();
                    String encodedChildName = URLEncoder.encode(childName, "UTF8").replace("+", "%20");
                    if (childInfo.isDirectory()) {
                        childName = String.valueOf(childName) + '/';
                        encodedChildName = String.valueOf(encodedChildName) + '/';
                    }
                    writer.print("<a href=\"" + encodedChildName + "\">" + childName + "</a>");
                    int i = childName.length();
                    while (i < 30) {
                        writer.print(' ');
                        ++i;
                    }
                    String formattedLastModified = this.dateFormat.format(new Date(childInfo.getLastModified()));
                    writer.println(String.valueOf(formattedLastModified) + "      " + childInfo.getLength());
                    ++n2;
                }
                writer.println("<hr>");
                writer.println("</pre>");
                writer.println("</body></html>");
            }
            catch (Exception e) {
                if (this.handleAuthFailure(request, response, e)) break block6;
                throw new ServletException(NLS.bind((String)"Error retrieving directory: {0}", (Object)dir), (Throwable)e);
            }
        }
        return true;
    }
}

