/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.hosting;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.orion.internal.server.hosting.HostingActivator;
import org.eclipse.orion.internal.server.hosting.ISiteHostingService;

public class HostedSiteRequestFilter
implements Filter {
    private static final String HOSTED_SITE_ALIAS = "/hosted";
    private ISiteHostingService siteHostingService;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.siteHostingService = HostingActivator.getDefault().getHostingService();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq;
        String host;
        if (this.siteHostingService != null && (host = HostedSiteRequestFilter.getHost(httpReq = (HttpServletRequest)req)) != null) {
            boolean alreadyForwarded;
            String requestUri = httpReq.getRequestURI();
            String service = httpReq.getServletPath();
            boolean isForSite = this.siteHostingService.isHosted(host) || this.siteHostingService.matchesVirtualHost(host);
            boolean bl = alreadyForwarded = httpReq.getAttribute("org.eclipse.orion.server.hosting.forwarded") != null;
            if (isForSite && !service.equals(HOSTED_SITE_ALIAS) && !alreadyForwarded) {
                StringBuffer forward = new StringBuffer(HOSTED_SITE_ALIAS);
                forward.append('/');
                forward.append(host);
                forward.append(requestUri);
                String queryString = httpReq.getQueryString();
                if (queryString != null) {
                    forward.append('?');
                    forward.append(queryString);
                }
                RequestDispatcher rd = httpReq.getRequestDispatcher(forward.toString());
                rd.forward(req, resp);
                return;
            }
        }
        chain.doFilter(req, resp);
    }

    private static String getHost(HttpServletRequest req) {
        int i;
        String host = req.getHeader("Host");
        if (host != null && (i = host.indexOf(":")) != -1) {
            return host.substring(0, i);
        }
        return host;
    }

    public void destroy() {
    }
}

