/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import java.net.URI;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.CFActivator;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.objects.Space;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacesHandlerV1
extends AbstractRESTHandler<Space> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public SpacesHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected Space buildResource(HttpServletRequest request, String pathString) throws CoreException {
        return null;
    }

    @Override
    protected CFJob handleGet(Space space, HttpServletRequest request, HttpServletResponse response, final String pathString) {
        final JSONObject targetJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    Target target;
                    URL targetUrl = null;
                    if (targetJSON != null) {
                        try {
                            targetUrl = new URL(targetJSON.getString("Url"));
                        }
                        catch (Exception exception) {}
                    }
                    if ((target = CFActivator.getDefault().getTargetRegistry().getTarget(this.userId, targetUrl)) == null) {
                        return HttpUtil.createErrorStatus(2, "CF-TargetNotSet", "Target not set");
                    }
                    Path path = new Path(pathString);
                    String spaceId = path.segment(0);
                    URI targetURI = URIUtil.toURI((URL)target.getUrl());
                    URI orgsURI = targetURI.resolve("/v2/spaces/" + spaceId);
                    GetMethod getDomainsMethod = new GetMethod(orgsURI.toString());
                    ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getDomainsMethod, target.getCloud());
                    if (!confStatus.isOK()) {
                        return confStatus;
                    }
                    getDomainsMethod.setQueryString("inline-relations-depth=1");
                    ServerStatus status = HttpUtil.executeMethod((HttpMethodBase)getDomainsMethod);
                    if (!status.isOK()) {
                        return status;
                    }
                    Space space = new Space().setCFJSON(status.getJsonData());
                    return new ServerStatus(Status.OK_STATUS, 200, space.toJSON());
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)pathString);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    SpacesHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }
}

