/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.StartAppCommand;
import org.eclipse.orion.server.cf.commands.StopAppCommand;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartAppCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private App application;

    public RestartAppCommand(Target target, App app) {
        super(target);
        Object[] bindings = new String[]{app.getName(), app.getGuid()};
        this.commandName = NLS.bind((String)"Restart application {0} (guid: {1})", (Object[])bindings);
        this.application = app;
    }

    @Override
    protected ServerStatus _doIt() {
        MultiServerStatus status = new MultiServerStatus();
        try {
            StopAppCommand stopApp = new StopAppCommand(this.target, this.application);
            ServerStatus jobStatus = (ServerStatus)stopApp.doIt();
            status.add(jobStatus);
            if (!jobStatus.isOK()) {
                return status;
            }
            StartAppCommand startApp = new StartAppCommand(this.target, this.application);
            jobStatus = (ServerStatus)startApp.doIt();
            status.add(jobStatus);
            if (!jobStatus.isOK()) {
                return status;
            }
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            status.add(new ServerStatus(4, 500, msg, (Throwable)e));
            return status;
        }
    }
}

