/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.objects;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.orion.server.cf.objects.App2;
import org.eclipse.orion.server.cf.objects.CFObject;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Route")
public class Route
extends CFObject {
    public static final String RESOURCE = "routes";
    public static final String TYPE = "Route";
    protected static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private JSONObject routeJSON;
    private List<App2> apps;

    public Route() {
        Property[] defaultProperties = new Property[]{new Property("Guid"), new Property("Host"), new Property("DomainName"), new Property("Apps")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
    }

    public Route setCFJSON(JSONObject routeJSON) {
        this.routeJSON = routeJSON;
        return this;
    }

    public JSONObject getCFJSON() {
        return this.routeJSON;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return null;
    }

    @PropertyDescription(name="Host")
    public String getHost() {
        try {
            return this.routeJSON.getJSONObject("entity").getString("host");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @PropertyDescription(name="DomainName")
    public String getDomainName() {
        try {
            return this.routeJSON.getJSONObject("entity").getJSONObject("domain").getJSONObject("entity").getString("name");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @PropertyDescription(name="Guid")
    public String getGuid() {
        try {
            return this.routeJSON.getJSONObject("metadata").getString("guid");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @PropertyDescription(name="Apps")
    private JSONArray getAppsJSON() {
        try {
            JSONArray ret = new JSONArray();
            if (this.apps == null) {
                this.apps = new ArrayList<App2>();
                JSONArray appsJSON = this.routeJSON.getJSONObject("entity").getJSONArray("apps");
                int i = 0;
                while (i < appsJSON.length()) {
                    App2 app = new App2().setCFJSON(appsJSON.getJSONObject(i));
                    this.apps.add(app);
                    ret.put((Object)app.toJSON());
                    ++i;
                }
            }
            return ret;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }
}

