/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractGitHandler
extends ServletResourceHandler<String> {
    protected ServletResourceHandler<IStatus> statusHandler;

    AbstractGitHandler(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        String msg;
        Repository db = null;
        try {
            Path p = new Path(path);
            String gitSegment = null;
            if (p.segment(1).equals("file")) {
                gitSegment = GitUtils.decode(p.segment(0));
                p = p.removeFirstSegments(1);
            }
            Path filePath = p;
            if (!AuthorizationService.checkRights((String)request.getRemoteUser(), (String)("/" + filePath.toString()), (String)request.getMethod())) {
                response.sendError(403);
                return true;
            }
            Object gitSearchPath = filePath.hasTrailingSeparator() ? filePath : filePath.removeLastSegments(1);
            Set<Map.Entry<IPath, File>> gitDirsFound = GitUtils.getGitDirs((IPath)gitSearchPath, GitUtils.Traverse.GO_UP).entrySet();
            Map.Entry<IPath, File> firstGitDir = gitDirsFound.iterator().next();
            File gitDir = firstGitDir.getValue();
            if (gitDir == null) {
                String msg2 = NLS.bind((String)"Could not find repository for {0}", (Object)filePath);
                boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg2, null));
                return bl;
            }
            String relativePath = GitUtils.getRelativePath((IPath)filePath, firstGitDir.getKey());
            db = FileRepositoryBuilder.create((File)gitDir);
            RequestInfo requestInfo = new RequestInfo(request, response, db, gitSegment, relativePath, (IPath)filePath);
            switch (AbstractGitHandler.getMethod((HttpServletRequest)request)) {
                case GET: {
                    boolean bl = this.handleGet(requestInfo);
                    return bl;
                }
                case POST: {
                    boolean bl = this.handlePost(requestInfo);
                    return bl;
                }
                case PUT: {
                    boolean bl = this.handlePut(requestInfo);
                    return bl;
                }
                case DELETE: {
                    boolean bl = this.handleDelete(requestInfo);
                    return bl;
                }
            }
            return false;
        }
        catch (IOException e) {
            msg = NLS.bind((String)"Failed to process a git request for {0}", (Object)path);
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
            return bl;
        }
        catch (CoreException e) {
            msg = NLS.bind((String)"Failed to process a git request for {0}", (Object)path);
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
            return bl;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    protected boolean handleGet(RequestInfo requestInfo) throws ServletException {
        return false;
    }

    protected boolean handlePost(RequestInfo requestInfo) throws ServletException {
        return false;
    }

    protected boolean handlePut(RequestInfo requestInfo) throws ServletException {
        return false;
    }

    protected boolean handleDelete(RequestInfo requestInfo) throws ServletException {
        return false;
    }

    class RequestInfo {
        HttpServletRequest request;
        HttpServletResponse response;
        Repository db;
        String gitSegment;
        String relativePath;
        IPath filePath;
        Git git;
        JSONObject jsonRequest;

        public RequestInfo(HttpServletRequest request, HttpServletResponse response, Repository db, String gitSegment, String relativePath, IPath filePath) {
            this.request = request;
            this.response = response;
            this.db = db;
            this.gitSegment = gitSegment;
            this.relativePath = relativePath;
            this.filePath = filePath;
            this.git = new Git(db);
        }

        public JSONObject getJSONRequest() {
            if (this.jsonRequest == null) {
                this.jsonRequest = this.readJSONRequest();
            }
            return this.jsonRequest;
        }

        private JSONObject readJSONRequest() {
            try {
                return OrionServlet.readJSONRequest((HttpServletRequest)this.request);
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.git", 1, "An error occured when getting JSON request", (Throwable)e));
                return new JSONObject();
            }
            catch (JSONException e) {
                LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.git", 1, "An error occured when getting JSON request", (Throwable)e));
                return new JSONObject();
            }
        }
    }
}

