/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.orion.server.core.resources.JSONSerializer;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.core.users.UserUtilities;
import org.eclipse.orion.server.git.BaseToCommitConverter;
import org.eclipse.orion.server.git.objects.GitObject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Blame")
public class Blame
extends GitObject {
    public static final String RESOURCE = "blame";
    public static final String TYPE = "Blame";
    private List<String> lines = new ArrayList<String>();
    private List<RevCommit> commits = new ArrayList<RevCommit>();
    private String filePath = null;
    private ObjectId startCommit = null;
    protected JSONSerializer jsonSerializer = new JSONSerializer();
    private URI blameLocation = null;
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();

    public Blame(URI cloneLocation, Repository db) {
        super(cloneLocation, db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("Children")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
    }

    public void addLine(String line) {
        this.lines.add(line);
    }

    public void setFilePath(String path) {
        this.filePath = path;
    }

    public void addCommit(RevCommit commit) {
        this.commits.add(commit);
    }

    public boolean commitExists(RevCommit commit) {
        return this.commits.contains(commit);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void clearLines() {
        this.lines = new ArrayList<String>();
    }

    public void setStartCommit(ObjectId id) {
        this.startCommit = id;
    }

    public ObjectId getStartCommit() {
        return this.startCommit;
    }

    public void setBlameLocation(URI location) {
        this.blameLocation = location;
    }

    @Override
    public JSONObject toJSON() throws URISyntaxException {
        return this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return this.blameLocation;
    }

    @PropertyDescription(name="Children")
    private JSONArray getBlameJSON() throws URISyntaxException, JSONException, IOException {
        if (this.lines.size() > 0 && this.commits.size() > 0) {
            ArrayList<JSONArray> commitRanges = new ArrayList<JSONArray>();
            JSONObject tempObj = null;
            String lineId = null;
            String currentCommitId = null;
            int i = 0;
            while (i < this.commits.size()) {
                commitRanges.add(new JSONArray());
                ++i;
            }
            try {
                i = 0;
                while (i < this.lines.size()) {
                    lineId = this.lines.get(i);
                    if (lineId != null && !lineId.equals(currentCommitId)) {
                        if (tempObj != null) {
                            tempObj.put("End", i);
                            int j = 0;
                            while (j < this.commits.size()) {
                                if (this.commits.get(j).getId().getName().equals(currentCommitId)) {
                                    ((JSONArray)commitRanges.get(j)).put((Object)tempObj);
                                    break;
                                }
                                ++j;
                            }
                        }
                        tempObj = new JSONObject();
                        tempObj.put("Start", i + 1);
                        currentCommitId = lineId;
                    }
                    ++i;
                }
                tempObj.put("End", this.lines.size());
                int j = 0;
                while (j < this.commits.size()) {
                    if (this.commits.get(j).getId().getName().equals(lineId)) {
                        ((JSONArray)commitRanges.get(j)).put((Object)tempObj);
                        break;
                    }
                    ++j;
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            JSONArray returnJSON = new JSONArray();
            int i2 = 0;
            while (i2 < commitRanges.size()) {
                tempObj = new JSONObject();
                RevCommit tempCommit = this.commits.get(i2);
                PersonIdent person = tempCommit.getAuthorIdent();
                URI commitURI = BaseToCommitConverter.getCommitLocation(this.cloneLocation, tempCommit.getId().getName(), BaseToCommitConverter.REMOVE_FIRST_2);
                tempObj = new JSONObject();
                tempObj.put("Time", (long)tempCommit.getCommitTime() * 1000L);
                tempObj.put("AuthorEmail", (Object)person.getEmailAddress());
                tempObj.put("AuthorName", (Object)person.getName());
                tempObj.put("AuthorImage", (Object)UserUtilities.getImageLink((String)person.getEmailAddress()));
                person = tempCommit.getCommitterIdent();
                tempObj.put("CommitterEmail", (Object)person.getEmailAddress());
                tempObj.put("CommitterName", (Object)person.getName());
                tempObj.put("CommitLocation", (Object)commitURI);
                tempObj.put("Children", commitRanges.get(i2));
                tempObj.put("Message", (Object)tempCommit.getFullMessage());
                tempObj.put("Name", (Object)tempCommit.getId().getName());
                returnJSON.put((Object)tempObj);
                ++i2;
            }
            return returnJSON;
        }
        return null;
    }
}

