/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.tasks;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.core.tasks.TaskDescription;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;
import org.eclipse.orion.server.core.resources.FileLocker;

public class TaskStore {
    private final File root;
    private static final String FILENAME_LOCK = ".lock";
    private static final String FILENAME_TEMP = "temp";

    public TaskStore(File root) {
        this.root = root;
        LogHelper.log((IStatus)new Status(1, "org.eclipse.orion.server.core", "Tasks metadata location is " + root.toString()));
        if (!root.exists()) {
            LogHelper.log((IStatus)new Status(1, "org.eclipse.orion.server.core", "Creating tasks folder " + root.toString()));
            if (!this.root.mkdirs()) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Problem creating tasks folder " + root.toString()));
            }
        }
    }

    private String getUserDirectory(String userId) {
        return new String(Base64.encode(userId.getBytes()));
    }

    private String getUserName(String userDirectoryName) {
        try {
            return new String(Base64.decode(userDirectoryName.getBytes()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String readTask(TaskDescription td) {
        File directory = new File(this.root, this.getUserDirectory(td.getUserId()));
        if (!directory.exists()) {
            return null;
        }
        FileLocker locker = new FileLocker(new File(directory, FILENAME_LOCK));
        try {
            String string;
            block20: {
                locker.lock();
                if (!td.isKeep() && !(directory = new File(directory, FILENAME_TEMP)).exists()) {
                    return null;
                }
                File taskFile = new File(directory, td.getTaskId());
                if (!taskFile.exists()) {
                    return null;
                }
                FileReader reader = null;
                try {
                    reader = new FileReader(taskFile);
                    StringWriter writer = new StringWriter();
                    IOUtilities.pipe(reader, writer, true, false);
                    string = writer.toString();
                    if (reader == null) break block20;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LogHelper.log(e);
                            locker.release();
                            return null;
                        }
                    }
                    try {
                        throw throwable;
                    }
                    catch (IOException e) {
                        LogHelper.log(e);
                        return null;
                    }
                }
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogHelper.log(e);
                    locker.release();
                    return null;
                }
            }
            return string;
        }
        finally {
            locker.release();
        }
    }

    public void writeTask(TaskDescription td, String representation) {
        File directory = new File(this.root, this.getUserDirectory(td.getUserId()));
        if (!directory.exists()) {
            directory.mkdir();
        }
        FileLocker locker = new FileLocker(new File(directory, FILENAME_LOCK));
        try {
            try {
                locker.lock();
                if (!td.isKeep() && !(directory = new File(directory, FILENAME_TEMP)).exists()) {
                    directory.mkdir();
                }
                File taskFile = new File(directory, td.getTaskId());
                FileWriter writer = new FileWriter(taskFile);
                StringReader reader = new StringReader(representation);
                IOUtilities.pipe(reader, writer, true, true);
            }
            catch (IOException e) {
                LogHelper.log(e);
                locker.release();
            }
        }
        finally {
            locker.release();
        }
    }

    public boolean removeTask(TaskDescription td) {
        File directory = new File(this.root, this.getUserDirectory(td.getUserId()));
        if (!directory.exists()) {
            return false;
        }
        FileLocker locker = new FileLocker(new File(directory, FILENAME_LOCK));
        try {
            locker.lock();
            if (!td.isKeep() && !(directory = new File(directory, FILENAME_TEMP)).exists()) {
                return false;
            }
            File taskFile = new File(directory, td.getTaskId());
            if (!taskFile.exists()) {
                return false;
            }
            boolean bl = taskFile.delete();
            return bl;
        }
        catch (IOException e) {
            LogHelper.log(e);
            return false;
        }
        finally {
            locker.release();
        }
    }

    private void delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                this.delete(c);
                ++n2;
            }
        }
        if (!f.delete()) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Cannot delete file " + f.getName()));
        }
    }

    public void removeAllTempTasks() {
        File[] children = this.root.listFiles();
        if (children == null) {
            return;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File userDirectory = fileArray[n2];
            if (userDirectory.isDirectory()) {
                this.removeAllTempTasks(userDirectory);
            }
            ++n2;
        }
    }

    private void removeAllTempTasks(File userDirectory) {
        if (!userDirectory.exists()) {
            return;
        }
        FileLocker locker = new FileLocker(new File(userDirectory, FILENAME_LOCK));
        try {
            locker.lock();
            File directory = new File(userDirectory, FILENAME_TEMP);
            if (!directory.exists()) {
                return;
            }
            try {
                this.delete(directory);
            }
            catch (IOException e) {
                LogHelper.log(e);
            }
        }
        finally {
            locker.release();
        }
    }

    private List<TaskDescription> internalReadAllTasksDescriptions(File userDirectory, boolean includeTempTasks) {
        File tempDir;
        ArrayList<TaskDescription> result = new ArrayList<TaskDescription>();
        String userId = this.getUserName(userDirectory.getName());
        if (userId == null) {
            return result;
        }
        File[] fileArray = userDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File taskFile = fileArray[n2];
            if (taskFile.isFile() && !taskFile.getName().equals(FILENAME_LOCK)) {
                result.add(new TaskDescription(userId, taskFile.getName(), true));
            }
            ++n2;
        }
        if (includeTempTasks && (tempDir = new File(userDirectory, FILENAME_TEMP)).exists() && tempDir.isDirectory()) {
            File[] fileArray2 = tempDir.listFiles();
            int n3 = fileArray2.length;
            n = 0;
            while (n < n3) {
                File taskFile = fileArray2[n];
                if (taskFile.isFile() && !taskFile.getName().equals(FILENAME_LOCK)) {
                    result.add(new TaskDescription(userId, taskFile.getName(), false));
                }
                ++n;
            }
        }
        return result;
    }

    public List<TaskDescription> readAllTasks(String userId) {
        File userDirectory = new File(this.root, this.getUserDirectory(userId));
        if (!userDirectory.exists()) {
            return new ArrayList<TaskDescription>();
        }
        FileLocker locker = new FileLocker(new File(userDirectory, FILENAME_LOCK));
        try {
            locker.lock();
            List<TaskDescription> list = this.internalReadAllTasksDescriptions(userDirectory, false);
            return list;
        }
        catch (IOException e) {
            LogHelper.log(e);
            ArrayList<TaskDescription> arrayList = new ArrayList<TaskDescription>();
            return arrayList;
        }
        finally {
            locker.release();
        }
    }

    public List<TaskDescription> readAllTasks() {
        return this.readAllTasks(false);
    }

    public List<TaskDescription> readAllTasks(boolean includeTempTasks) {
        ArrayList<TaskDescription> result = new ArrayList<TaskDescription>();
        if (this.root.exists() && this.root.isDirectory()) {
            File[] fileArray = this.root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    File userDirectory = fileArray[n2];
                    FileLocker locker = new FileLocker(new File(userDirectory, FILENAME_LOCK));
                    try {
                        try {
                            locker.lock();
                            if (userDirectory.isDirectory()) {
                                result.addAll(this.internalReadAllTasksDescriptions(userDirectory, includeTempTasks));
                            }
                        }
                        catch (IOException e) {
                            LogHelper.log(e);
                            locker.release();
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        locker.release();
                        throw throwable;
                    }
                    locker.release();
                }
                ++n2;
            }
        } else {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Tasks folder is not a directory " + this.root.toString()));
        }
        return result;
    }
}

