/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

class ContentRange {
    private int startByte;
    private int endByte;
    private int length;

    static ContentRange parse(String header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        ContentRange result = new ContentRange();
        int start = 0;
        while (!Character.isDigit(header.charAt(start))) {
            ++start;
        }
        int dash = header.indexOf(45);
        int slash = header.indexOf(47);
        if (dash < 0 || slash < 0) {
            throw new IllegalArgumentException(header);
        }
        try {
            result.startByte = Integer.parseInt(header.substring(start, dash));
            result.endByte = Integer.parseInt(header.substring(dash + 1, slash));
            result.length = Integer.parseInt(header.substring(slash + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(header);
        }
        return result;
    }

    private ContentRange() {
    }

    int getStartByte() {
        return this.startByte;
    }

    int getEndByte() {
        return this.endByte;
    }

    int getLength() {
        return this.length;
    }

    public String toString() {
        return "ContentRange(" + this.startByte + '-' + this.endByte + '/' + this.length + ')';
    }
}

