/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.git.servlets.GitBlameHandlerV1;
import org.eclipse.orion.server.git.servlets.GitBranchHandlerV1;
import org.eclipse.orion.server.git.servlets.GitCloneHandlerV1;
import org.eclipse.orion.server.git.servlets.GitCommitHandlerV1;
import org.eclipse.orion.server.git.servlets.GitConfigHandlerV1;
import org.eclipse.orion.server.git.servlets.GitDiffHandlerV1;
import org.eclipse.orion.server.git.servlets.GitIgnoreHandlerV1;
import org.eclipse.orion.server.git.servlets.GitIndexHandlerV1;
import org.eclipse.orion.server.git.servlets.GitPullRequestHandlerV1;
import org.eclipse.orion.server.git.servlets.GitRemoteHandlerV1;
import org.eclipse.orion.server.git.servlets.GitStashHandlerV1;
import org.eclipse.orion.server.git.servlets.GitStatusHandlerV1;
import org.eclipse.orion.server.git.servlets.GitSubmoduleHandlerV1;
import org.eclipse.orion.server.git.servlets.GitTagHandlerV1;
import org.eclipse.orion.server.git.servlets.GitTreeHandlerV1;

public class GitHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<String> branchHandlerV1;
    private ServletResourceHandler<String> cloneHandlerV1;
    private ServletResourceHandler<String> commitHandlerV1;
    private ServletResourceHandler<String> configHandlerV1;
    private ServletResourceHandler<String> diffHandlerV1;
    private ServletResourceHandler<String> indexHandlerV1;
    private ServletResourceHandler<String> ignoreHandlerV1;
    private ServletResourceHandler<String> remoteHandlerV1;
    private ServletResourceHandler<String> statusHandlerV1;
    private ServletResourceHandler<String> tagHandlerV1;
    private ServletResourceHandler<String> blameHandlerV1;
    private ServletResourceHandler<String> treeHandlerV1;
    private ServletResourceHandler<String> stashHandlerV1;
    private ServletResourceHandler<String> submoduleHandlerV1;
    private ServletResourceHandler<String> pullRequestHandlerV1;

    GitHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.branchHandlerV1 = new GitBranchHandlerV1(statusHandler);
        this.blameHandlerV1 = new GitBlameHandlerV1(statusHandler);
        this.cloneHandlerV1 = new GitCloneHandlerV1(statusHandler);
        this.commitHandlerV1 = new GitCommitHandlerV1(statusHandler);
        this.configHandlerV1 = new GitConfigHandlerV1(statusHandler);
        this.diffHandlerV1 = new GitDiffHandlerV1(statusHandler);
        this.indexHandlerV1 = new GitIndexHandlerV1(statusHandler);
        this.ignoreHandlerV1 = new GitIgnoreHandlerV1(statusHandler);
        this.remoteHandlerV1 = new GitRemoteHandlerV1(statusHandler);
        this.statusHandlerV1 = new GitStatusHandlerV1(statusHandler);
        this.tagHandlerV1 = new GitTagHandlerV1(statusHandler);
        this.treeHandlerV1 = new GitTreeHandlerV1(statusHandler);
        this.stashHandlerV1 = new GitStashHandlerV1(statusHandler);
        this.submoduleHandlerV1 = new GitSubmoduleHandlerV1(statusHandler);
        this.pullRequestHandlerV1 = new GitPullRequestHandlerV1(statusHandler);
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String gitPathInfo) throws ServletException {
        Cookie[] cookies;
        String tokenName;
        String[] infoParts = gitPathInfo.split("\\/", 3);
        if (infoParts.length < 3) {
            return false;
        }
        String pathString = infoParts[2];
        if (request.getContextPath().length() != 0) {
            Path path = pathString == null ? Path.EMPTY : new Path(pathString);
            Path contextPath = new Path(request.getContextPath());
            if (contextPath.isPrefixOf((IPath)path)) {
                pathString = path.removeFirstSegments(contextPath.segmentCount()).toString();
            }
        }
        if ((tokenName = PreferenceHelper.getString((String)"ltpa.token.name")) != null && (cookies = request.getCookies()) != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie currentCookie = cookies[i];
                if (tokenName.equals(currentCookie.getName())) {
                    Cookie loginCookie = new Cookie(currentCookie.getName(), currentCookie.getValue().replaceAll("(\\r|\\n)", ""));
                    request.setAttribute("SSOToken", (Object)loginCookie);
                }
                ++i;
            }
        }
        if (infoParts[1].equals("branch")) {
            return this.branchHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("clone")) {
            return this.cloneHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("commit")) {
            return this.commitHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("config")) {
            return this.configHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("diff")) {
            return this.diffHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("index")) {
            return this.indexHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("remote")) {
            return this.remoteHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("status")) {
            return this.statusHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("tag")) {
            return this.tagHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("blame")) {
            return this.blameHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("ignore")) {
            return this.ignoreHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("tree")) {
            return this.treeHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("stash")) {
            return this.stashHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("submodule")) {
            return this.submoduleHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        if (infoParts[1].equals("pullRequest")) {
            return this.pullRequestHandlerV1.handleRequest(request, response, (Object)pathString);
        }
        return false;
    }
}

