/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.search;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.search.SearchException;
import org.eclipse.orion.internal.server.search.SearchJob;
import org.eclipse.orion.internal.server.search.SearchOptions;
import org.eclipse.orion.internal.server.search.SearchResult;
import org.eclipse.orion.internal.server.search.SearchScope;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchServlet
extends OrionServlet {
    private static final String FIELD_NAMES = "Name,NameLower,Length,Directory,LastModified,Location,Path,RegEx,CaseSensitive";
    private static final List<String> FIELD_LIST = Arrays.asList("Name,NameLower,Length,Directory,LastModified,Location,Path,RegEx,CaseSensitive".split(","));
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");

    private void addAllProjectsToScope(WorkspaceInfo workspaceInfo, SearchOptions options) throws CoreException {
        List projectnames = workspaceInfo.getProjectNames();
        for (String projectName : projectnames) {
            ProjectInfo projectInfo = OrionConfiguration.getMetaStore().readProject(workspaceInfo.getUniqueId(), projectName);
            if (projectInfo == null) {
                this.logger.error("Unexpected missing project with name " + projectName + " in workspace " + workspaceInfo.getUniqueId());
                continue;
            }
            SearchScope scope = new SearchScope(projectInfo.getProjectStore(), workspaceInfo, projectInfo);
            options.getScopes().add(scope);
        }
    }

    private SearchOptions buildSearchOptions(HttpServletRequest req, HttpServletResponse resp) throws SearchException {
        SearchOptions options = new SearchOptions();
        String queryString = this.getEncodedParameter(req, "q");
        if (queryString == null) {
            return null;
        }
        if (queryString.length() > 0) {
            ArrayList<String> terms = new ArrayList<String>(Arrays.asList(queryString.split("[\\s\\+]+")));
            while (!terms.isEmpty()) {
                String term = (String)terms.remove(0);
                if (term.length() == 0) continue;
                if (this.isSearchField(term)) {
                    if (term.startsWith("NameLower:")) {
                        try {
                            term = URLDecoder.decode(term, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        options.setIsFilenamePatternCaseSensitive(false);
                        options.setFilenamePattern(term.substring(10));
                        continue;
                    }
                    if (term.startsWith("Location:")) {
                        String location = term.substring(9 + req.getContextPath().length());
                        try {
                            location = URLDecoder.decode(location, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        options.setLocation(location);
                        continue;
                    }
                    if (term.startsWith("Name:")) {
                        try {
                            term = URLDecoder.decode(term, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        options.setIsFilenamePatternCaseSensitive(true);
                        options.setFilenamePattern(term.substring(5));
                        continue;
                    }
                    if (term.startsWith("RegEx:")) {
                        options.setRegEx(true);
                        continue;
                    }
                    if (!term.startsWith("CaseSensitive:")) continue;
                    options.setIsSearchTermCaseSensitive(true);
                    continue;
                }
                try {
                    term = URLDecoder.decode(term, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                options.setSearchTerm(term);
                options.setFileSearch(true);
            }
        }
        String login = req.getRemoteUser();
        options.setUsername(login);
        this.setScopes(req, resp, options);
        return options;
    }

    private JSONObject convertListToJson(String contextPath, List<SearchResult> files, SearchOptions options) {
        JSONObject resultsJSON = new JSONObject();
        JSONObject responseJSON = new JSONObject();
        try {
            resultsJSON.put("numFound", files.size());
            resultsJSON.put("start", 0);
            JSONArray docs = new JSONArray();
            for (SearchResult file : files) {
                docs.put((Object)file.toJSON(contextPath));
            }
            resultsJSON.put("docs", (Object)docs);
            JSONObject responseHeader = new JSONObject();
            responseHeader.put("status", 0);
            JSONObject params = new JSONObject();
            params.put("wt", (Object)"json");
            params.put("fl", (Object)FIELD_NAMES);
            JSONArray fq = new JSONArray();
            if (options.getDefaultLocation() != null) {
                fq.put((Object)("Location:" + options.getDefaultLocation()));
            } else if (options.getLocation() != null) {
                fq.put((Object)("Location:" + options.getLocation()));
            } else {
                throw new RuntimeException("Scope or DefaultScope is missing");
            }
            if (options.getUsername() == null) {
                throw new RuntimeException("UserName is missing");
            }
            fq.put((Object)("UserName:" + options.getUsername()));
            params.put("fq", (Object)fq);
            params.put("rows", (Object)"10000");
            params.put("start", (Object)"0");
            params.put("sort", (Object)"Path asc");
            responseHeader.put("params", (Object)params);
            responseJSON.put("responseHeader", (Object)responseHeader);
            responseJSON.put("response", (Object)resultsJSON);
        }
        catch (JSONException e) {
            this.logger.error("SearchServlet.convertListToJson: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            this.logger.error("SearchServlet.convertListToJson: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            this.logger.error("SearchServlet.convertListToJson: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return responseJSON;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (SearchJob.isSearchJobRunning(req.getRemoteUser())) {
                resp.sendError(409, "A search task is already running for " + req.getRemoteUser() + ", try again later.");
                return;
            }
            SearchOptions options = this.buildSearchOptions(req, resp);
            SearchJob searchJob = new SearchJob(options);
            searchJob.schedule();
            searchJob.join();
            if (!searchJob.getResult().isOK()) {
                resp.sendError(500, searchJob.getResult().getMessage());
            }
            List<SearchResult> files = searchJob.getSearchResults();
            this.writeResponse(req, resp, files, options);
        }
        catch (SearchException e) {
            resp.sendError(500, e.getMessage());
        }
        catch (InterruptedException e) {
            resp.sendError(500, e.getMessage());
        }
    }

    private String getEncodedParameter(HttpServletRequest req, String key) {
        String query = req.getQueryString();
        String[] stringArray = query.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] pair = param.split("=", 2);
            if (pair.length == 2 && key.equals(pair[0])) {
                return pair[1];
            }
            ++n2;
        }
        return null;
    }

    private boolean isSearchField(String term) {
        for (String field : FIELD_LIST) {
            if (!term.startsWith(String.valueOf(field) + ":")) continue;
            return true;
        }
        return false;
    }

    private void setDefaultScopes(HttpServletRequest req, HttpServletResponse resp, SearchOptions options) throws SearchException {
        String login = req.getRemoteUser();
        try {
            UserInfo userInfo = OrionConfiguration.getMetaStore().readUserByProperty("UserName", login, false, false);
            List workspaceIds = userInfo.getWorkspaceIds();
            for (String workspaceId : workspaceIds) {
                WorkspaceInfo workspaceInfo = OrionConfiguration.getMetaStore().readWorkspace(workspaceId);
                options.setDefaultLocation("/file/" + workspaceId);
                this.addAllProjectsToScope(workspaceInfo, options);
            }
        }
        catch (CoreException e) {
            throw new SearchException(e);
        }
    }

    private boolean setScopeFromRequest(HttpServletRequest req, HttpServletResponse resp, SearchOptions options) {
        WorkspaceInfo workspaceInfo;
        Path path;
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                try {
                                    String pathInfo = options.getLocation();
                                    if (pathInfo != null) {
                                        pathInfo = pathInfo.replaceFirst("/file", "");
                                    }
                                    Path path2 = path = pathInfo == null ? Path.ROOT : new Path(pathInfo);
                                    if (pathInfo == null || pathInfo.equals(path.toString())) break block11;
                                    return false;
                                }
                                catch (CoreException e) {
                                    this.logger.error("FileGrepper.setScopeFromRequest: " + e.getLocalizedMessage(), (Throwable)e);
                                    return false;
                                }
                            }
                            if (path.segmentCount() <= 0 || !".metadata".equals(path.segment(0))) break block12;
                            return false;
                        }
                        if (path.segmentCount() != 0) break block13;
                        return false;
                    }
                    workspaceInfo = OrionConfiguration.getMetaStore().readWorkspace(path.segment(0));
                    if (workspaceInfo != null && workspaceInfo.getUniqueId() != null) break block14;
                    return false;
                }
                if (path.segmentCount() != 1) break block15;
                if (workspaceInfo != null && workspaceInfo.getUniqueId() != null) {
                    this.addAllProjectsToScope(workspaceInfo, options);
                    return true;
                }
                return false;
            }
            ProjectInfo projectInfo = OrionConfiguration.getMetaStore().readProject(workspaceInfo.getUniqueId(), path.segment(1));
            if (projectInfo == null) break block16;
            IFileStore projectStore = projectInfo.getProjectStore();
            IFileStore scopeStore = projectStore.getFileStore(path.removeFirstSegments(2));
            SearchScope scope = new SearchScope(scopeStore, workspaceInfo, projectInfo);
            options.getScopes().add(scope);
            return true;
        }
        if (path.segmentCount() == 2) {
            IFileStore workspaceStore = OrionConfiguration.getMetaStore().getWorkspaceContentLocation(workspaceInfo.getUniqueId());
            IFileStore scopeStore = workspaceStore.getChild(path.segment(1));
            SearchScope scope = new SearchScope(scopeStore, workspaceInfo, null);
            options.getScopes().add(scope);
            return true;
        }
        return false;
    }

    private void setScopes(HttpServletRequest req, HttpServletResponse resp, SearchOptions options) throws SearchException {
        if (!this.setScopeFromRequest(req, resp, options)) {
            this.setDefaultScopes(req, resp, options);
        }
    }

    private void writeResponse(HttpServletRequest req, HttpServletResponse resp, List<SearchResult> files, SearchOptions options) throws IOException {
        try {
            JSONObject json = this.convertListToJson(req.getContextPath(), files, options);
            SearchServlet.writeJSONResponse((HttpServletRequest)req, (HttpServletResponse)resp, (Object)json);
        }
        catch (IllegalStateException e) {
            resp.sendError(500, e.getMessage());
        }
    }
}

