/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.loggregator;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.orion.server.cf.loggregator.LoggregatorListener;
import org.eclipse.orion.server.cf.loggregator.LoggregatorSocket;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggregatorClient {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public void start(Target target, String loggregatorLocation, LoggregatorListener listener) throws Exception {
        this.logger.debug(NLS.bind((String)"About to connect: {0}", (Object)loggregatorLocation));
        SslContextFactory sslContextFactory = new SslContextFactory(true);
        WebSocketClient client = new WebSocketClient(sslContextFactory);
        LoggregatorSocket socket = new LoggregatorSocket(listener);
        try {
            client.start();
            URI loggregatorUri = new URI(loggregatorLocation);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            request.setHeader("Authorization", "bearer " + target.getCloud().getAccessToken().getString("access_token"));
            client.connect((Object)socket, loggregatorUri, request);
            this.logger.debug(NLS.bind((String)"Connecting to: {0}", (Object)loggregatorUri));
            socket.awaitClose(25, TimeUnit.SECONDS);
        }
        finally {
            client.stop();
        }
    }
}

