/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.ProjectInfoResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.UserInfoResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.WorkspaceResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    private final Logger logger;
    private ServletResourceHandler<WorkspaceInfo> workspaceResourceHandler = new WorkspaceResourceHandler(this.getStatusHandler());

    public WorkspaceServlet() {
        this.logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.workspace");
    }

    private boolean checkUser(String userId, HttpServletResponse response) throws ServletException {
        if (userId == null) {
            this.handleException(response, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", "User name not specified"), 403);
            return false;
        }
        if (this.logger != null && this.logger.isInfoEnabled()) {
            this.logger.info("WorkspaceAccess: " + userId);
        }
        return true;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        String pathString = req.getPathInfo();
        if (pathString == null || pathString.equals("/")) {
            this.doGetWorkspaces(req, resp);
            return;
        }
        Path path = new Path(pathString);
        int segmentCount = path.segmentCount();
        try {
            if (segmentCount > 0 && segmentCount < 3) {
                WorkspaceInfo workspace = OrionConfiguration.getMetaStore().readWorkspace(path.segment(0));
                if (this.workspaceResourceHandler.handleRequest(req, resp, workspace)) {
                    return;
                }
            } else if (segmentCount == 3) {
                WorkspaceInfo workspace = OrionConfiguration.getMetaStore().readWorkspace(path.segment(0));
                ProjectInfo project = OrionConfiguration.getMetaStore().readProject(path.segment(0), path.segment(2));
                if (workspace == null || project == null) {
                    String msg = workspace == null ? "Workspace not found" : "Project not found";
                    this.handleException(resp, msg, null, 404);
                    return;
                }
                URI baseLocation = ServletResourceHandler.getURI(req);
                OrionServlet.writeJSONResponse(req, resp, ProjectInfoResourceHandler.toJSON(workspace, project, baseLocation));
                return;
            }
        }
        catch (CoreException e) {
            this.handleException(resp, "Error reading workspace metadata", (Exception)((Object)e));
            return;
        }
        super.doGet(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        String pathString = req.getPathInfo();
        Path path = new Path(pathString == null ? "" : pathString);
        if (path.segmentCount() > 0) {
            try {
                WorkspaceInfo workspace = OrionConfiguration.getMetaStore().readWorkspace(path.segment(0));
                if (this.workspaceResourceHandler.handleRequest(req, resp, workspace)) {
                    return;
                }
            }
            catch (CoreException e) {
                this.handleException(resp, "Error reading workspace metadata", (Exception)((Object)e));
                return;
            }
        }
        super.doDelete(req, resp);
    }

    private boolean doGetWorkspaces(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String userId = this.getUserId(req);
        if (!this.checkUser(userId, resp)) {
            return true;
        }
        try {
            Activator.getDefault();
            UserInfo user = OrionConfiguration.getMetaStore().readUser(userId);
            WorkspaceServlet.writeJSONResponse(req, resp, UserInfoResourceHandler.toJSON(user, ServletResourceHandler.getURI(req)));
        }
        catch (Exception e) {
            this.handleException(resp, "An error occurred while obtaining workspace data", e);
        }
        return true;
    }

    protected synchronized void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        String pathString = req.getPathInfo();
        if (pathString == null || pathString.equals("/")) {
            this.doCreateWorkspace(req, resp);
            return;
        }
        Path path = new Path(pathString);
        if (path.segmentCount() == 1) {
            try {
                WorkspaceInfo workspace = OrionConfiguration.getMetaStore().readWorkspace(path.segment(0));
                if (this.workspaceResourceHandler.handleRequest(req, resp, workspace)) {
                    return;
                }
            }
            catch (CoreException e) {
                this.handleException(resp, "An error occurred while obtaining workspace data", (Exception)((Object)e));
                return;
            }
        }
        super.doPost(req, resp);
    }

    private void doCreateWorkspace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String userId = this.getUserId(req);
        if (!this.checkUser(userId, resp)) {
            return;
        }
        String workspaceName = req.getHeader("Slug");
        if (workspaceName == null) {
            this.handleException(resp, "Workspace name not specified", null, 400);
            return;
        }
        try {
            WorkspaceInfo workspace = new WorkspaceInfo();
            workspace.setFullName(workspaceName);
            workspace.setUserId(userId);
            OrionConfiguration.getMetaStore().createWorkspace(workspace);
            if (this.logger != null && this.logger.isInfoEnabled()) {
                this.logger.info("Workspace created for " + userId);
            }
            URI requestLocation = ServletResourceHandler.getURI(req);
            JSONObject result = WorkspaceResourceHandler.toJSON(workspace, requestLocation, requestLocation);
            WorkspaceServlet.writeJSONResponse(req, resp, result);
            String resultLocation = result.optString("Location");
            resp.setHeader("Location", resultLocation);
            String workspacePath = "/workspace/" + workspace.getUniqueId();
            AuthorizationService.addUserRight(req.getRemoteUser(), workspacePath);
            AuthorizationService.addUserRight(req.getRemoteUser(), String.valueOf(workspacePath) + "/*");
            String filePath = "/file/" + workspace.getUniqueId();
            AuthorizationService.addUserRight(req.getRemoteUser(), filePath);
            AuthorizationService.addUserRight(req.getRemoteUser(), String.valueOf(filePath) + "/*");
        }
        catch (CoreException e) {
            this.handleException(resp, e.getStatus());
            return;
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path path;
        this.traceRequest(req);
        String pathString = req.getPathInfo();
        if (pathString != null && (path = new Path(pathString)).segmentCount() == 1) {
            try {
                WorkspaceInfo workspace = OrionConfiguration.getMetaStore().readWorkspace(path.segment(0));
                if (this.workspaceResourceHandler.handleRequest(req, resp, workspace)) {
                    return;
                }
            }
            catch (CoreException e) {
                this.handleException(resp, "An error occurred while obtaining workspace data", (Exception)((Object)e));
                return;
            }
        }
        super.doPut(req, resp);
    }

    private String getUserId(HttpServletRequest req) {
        return req.getRemoteUser();
    }
}

