/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.loggregator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.server.cf.loggregator.LoggregatorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggregatorRegistry {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private static LoggregatorRegistry instance = new LoggregatorRegistry();
    private static final long CLEANER_DELAY = TimeUnit.SECONDS.toMillis(5L);
    private static final long LOG_TTL = TimeUnit.MINUTES.toMillis(10L);
    private Map<String, LoggregatorListener> logsMap;
    private Cleaner cleaner = new Cleaner();

    private LoggregatorRegistry() {
        this.logsMap = Collections.synchronizedMap(new HashMap());
    }

    public static LoggregatorRegistry getDefault() {
        return instance;
    }

    public LoggregatorListener getListener(String appId) {
        this.logger.debug("LoggregatorRegistry: Getting logger for app " + appId);
        LoggregatorListener listener = this.logsMap.get(appId);
        if (listener == null) {
            listener = new LoggregatorListener();
            this.logsMap.put(appId, listener);
        }
        this.cleaner.schedule(CLEANER_DELAY);
        return listener;
    }

    class Cleaner
    extends Job {
        public Cleaner() {
            super("Loggregator Registry Cleaner");
        }

        protected IStatus run(IProgressMonitor monitor) {
            LoggregatorRegistry.this.logger.debug("LoggregatorRegistry: Running cleaner");
            if (LoggregatorRegistry.this.logsMap.entrySet().size() == 0) {
                LoggregatorRegistry.this.logger.debug("LoggregatorRegistry: Stopping cleaner");
                return Status.OK_STATUS;
            }
            Iterator iter = LoggregatorRegistry.this.logsMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (System.currentTimeMillis() - ((LoggregatorListener)entry.getValue()).getLastAccess() <= LOG_TTL) continue;
                LoggregatorRegistry.this.logger.debug("LoggregatorRegistry: Removing logger " + (String)entry.getKey());
                iter.remove();
            }
            this.schedule(CLEANER_DELAY);
            return Status.OK_STATUS;
        }
    }
}

