/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ImportStream
extends InputStream {
    private BufferedInputStream buffered;
    private long count;

    public ImportStream(InputStream in) {
        this.buffered = new BufferedInputStream(in);
    }

    public long count() {
        return this.count;
    }

    public void resetCount() {
        this.count = 0L;
    }

    public String readLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        String line = null;
        boolean eol = false;
        while (!eol) {
            int c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    line = sb.length() > 0 ? sb.toString() : "\r\n";
                    eol = true;
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    sb.append((char)c);
                }
            }
        }
        if (line == null) {
            throw new IOException("Unexpected EOF");
        }
        return line;
    }

    @Override
    public int read() throws IOException {
        int c = this.buffered.read();
        if (c != -1) {
            ++this.count;
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.buffered.read(b);
        if (read != -1) {
            this.count += (long)read;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.buffered.read(b, off, len);
        if (read != -1) {
            this.count += (long)read;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long read = this.buffered.skip(n);
        if (read != -1L) {
            this.count += read;
        }
        return read;
    }

    public long skipAll() throws IOException {
        long read = 0L;
        long skipped = 0L;
        while ((skipped = this.skip(Long.MAX_VALUE)) > 0L) {
            read += skipped;
            this.count += skipped;
        }
        return read;
    }

    @Override
    public int available() throws IOException {
        return this.buffered.available();
    }

    @Override
    public void close() throws IOException {
        this.buffered.close();
    }
}

