/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.about;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.osgi.framework.Bundle;

public class AboutHandler
extends ServletResourceHandler<String> {
    private static final String XHTML_1 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<title>";
    private static final String XHTML_2 = "</title>\n <style type = \"text/css\"> td { padding-right : 10px; }</style></head>\n<body>\n";
    private static final String XHTML_3 = "</body>\n</html>";
    protected static final int NUMBER_OF_COLUMNS = 4;
    protected ServletResourceHandler<IStatus> statusHandler;

    public AboutHandler(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    private boolean handleGetRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        response.setContentType("text/html; charset=UTF-8");
        StringBuffer buf = new StringBuffer();
        buf.append(XHTML_1);
        String sortParam = request.getParameter("sortColumn");
        int sortColumn = 3;
        if (sortParam != null) {
            try {
                sortColumn = Integer.parseInt(sortParam);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        buf.append("About");
        buf.append(XHTML_2);
        String app = System.getProperty("eclipse.application", "org.eclipse.orion.application");
        String build = this.getBuildId();
        if (app != null || build != null) {
            buf.append("<table><tr><td><img src=\"../webapp/orion-96.png\"/></td><td>");
            buf.append("<p>");
            if (app != null) {
                buf.append("Application: " + app + "<br/>");
            }
            if (build != null) {
                buf.append("Build Id: " + build + "<br/>");
            }
            buf.append("</p></td></tr></table>");
        }
        buf.append("<table>");
        ArrayList<PluginDetails> plugins = new ArrayList<PluginDetails>();
        Bundle[] bundles = Activator.getDefault().getContext().getBundles();
        int k = 0;
        while (k < bundles.length) {
            plugins.add(this.pluginDetails(bundles[k]));
            ++k;
        }
        PluginComparator pluginComparator = new PluginComparator(sortColumn);
        Collections.sort(plugins, pluginComparator);
        String[] headerColumns = new String[]{"Provider", "PluginName", "Version", "Identifier"};
        PluginDetails header = new PluginDetails(headerColumns);
        buf.append(this.headerRowFor(header));
        for (PluginDetails details : plugins) {
            buf.append(this.tableRowFor(details));
        }
        buf.append("</table>");
        buf.append(XHTML_3);
        String output = buf.toString();
        try {
            response.getWriter().write(output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private String headerRowFor(PluginDetails details) {
        String row = "<tr>\n";
        int i = 0;
        while (i < 4) {
            row = String.valueOf(row) + "<td><a href = \"about.html?sortColumn=";
            row = String.valueOf(row) + i;
            row = String.valueOf(row) + "\">";
            row = String.valueOf(row) + details.columns[i];
            row = String.valueOf(row) + "</a></td>\n";
            ++i;
        }
        row = String.valueOf(row) + "</tr>";
        return row;
    }

    private String tableRowFor(PluginDetails details) {
        String row = "<tr>\n";
        int i = 0;
        while (i < 4) {
            row = String.valueOf(row) + "<td>";
            row = String.valueOf(row) + details.columns[i];
            row = String.valueOf(row) + "</td>\n";
            ++i;
        }
        row = String.valueOf(row) + "</tr>";
        return row;
    }

    protected PluginDetails pluginDetails(Bundle bundle) {
        String[] values = new String[]{AboutHandler.getResourceString(bundle, "Bundle-Vendor"), AboutHandler.getResourceString(bundle, "Bundle-Name"), AboutHandler.getResourceString(bundle, "Bundle-Version"), bundle.getSymbolicName()};
        PluginDetails details = new PluginDetails(values);
        return details;
    }

    private static String getResourceString(Bundle bundle, String headerName) {
        String value = (String)bundle.getHeaders().get(headerName);
        return value == null ? null : Platform.getResourceString((Bundle)bundle, (String)value);
    }

    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        switch (AboutHandler.getMethod(request)) {
            case GET: {
                return this.handleGetRequest(request, response, path);
            }
        }
        return false;
    }

    private String getBuildId() {
        String version = System.getProperty("eclipse.buildId", "unknown");
        try {
            String inputLine;
            URL url = new URL("platform:/plugin/org.eclipse.orion.server.core/about.properties");
            InputStream inputStream = url.openConnection().getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            while ((inputLine = in.readLine()) != null) {
                if (inputLine.startsWith("Build id:")) break;
            }
            in.close();
            if (inputLine.length() > 30) {
                version = inputLine.substring(inputLine.indexOf(58) + 1, inputLine.length() - 3);
            }
        }
        catch (IOException iOException) {}
        return version;
    }

    protected class PluginComparator
    implements Comparator<PluginDetails> {
        private int column;

        public PluginComparator(int column) {
            this.column = column;
        }

        @Override
        public int compare(PluginDetails pd1, PluginDetails pd2) {
            return Collator.getInstance().compare(pd1.columns[this.column], pd2.columns[this.column]);
        }
    }

    protected class PluginDetails {
        public String[] columns = new String[4];

        public PluginDetails(String[] columns) {
            this.columns = columns;
            int i = 0;
            while (i < 4) {
                if (columns[i] == null) {
                    columns[i] = "";
                }
                ++i;
            }
        }
    }
}

