/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.logs.servlets.LogHandler;
import org.eclipse.orion.server.servlets.OrionServlet;

public class LogServlet
extends OrionServlet {
    public static final String LOGAPI_URI = "/logapi";
    private static final long serialVersionUID = 1L;
    private List<String> authorizedUsers;
    private ServletResourceHandler<String> logHandler;

    public void init() throws ServletException {
        this.logHandler = new LogHandler((ServletResourceHandler<IStatus>)this.getStatusHandler());
        String users = PreferenceHelper.getString((String)"orion.auth.log.service", null);
        if (users != null) {
            this.authorizedUsers = new ArrayList<String>();
            this.authorizedUsers.addAll(Arrays.asList(users.split(",")));
        } else {
            users = "ahunterhunter,anthonyh,mbendkowski,sbrandys,johna";
            this.authorizedUsers = new ArrayList<String>();
            this.authorizedUsers.addAll(Arrays.asList(users.split(",")));
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.authorizedUsers == null) {
            response.sendError(403);
            return;
        }
        String login = request.getRemoteUser();
        if (login == null || !this.authorizedUsers.contains(login)) {
            response.sendError(403);
            return;
        }
        String pathInfo = request.getPathInfo();
        if (this.logHandler.handleRequest(request, response, (Object)pathInfo)) {
            return;
        }
        super.doGet(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

