/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.jettycustomizer;

import java.io.File;
import java.util.Dictionary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.http.jetty.JettyCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrionJettyCustomizer
extends JettyCustomizer {
    public Object customizeContext(Object context, Dictionary<String, ?> settings) {
        if (context instanceof ServletContextHandler) {
            File logsFolder;
            ServletContextHandler jettyContext = (ServletContextHandler)context;
            IPath platformLocation = OrionConfiguration.getPlatformLocation();
            File rootLocation = platformLocation.toFile();
            File metadata = new File(rootLocation, ".metadata");
            if (!metadata.exists() && !metadata.isDirectory()) {
                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
                logger.error("Could not initialize NCSA Request Log: Folder does not exist: " + metadata.toString());
            }
            if (!(logsFolder = new File(metadata, "access_logs")).exists()) {
                logsFolder.mkdir();
                if (!logsFolder.exists() && !logsFolder.isDirectory()) {
                    Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
                    logger.error("Could not initialize NCSA Request Log: Logs folder does not exist: " + logsFolder.toString());
                }
            }
            NCSARequestLog requestLog = new NCSARequestLog(String.valueOf(logsFolder.toString()) + File.separator + "orion-access-yyyy_mm_dd.log");
            requestLog.setRetainDays(90);
            requestLog.setAppend(true);
            requestLog.setExtended(true);
            requestLog.setLogTimeZone("EST");
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            jettyContext.setHandler((Handler)requestLogHandler);
            Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
            logger.info("Initialized NCSA Request Logs in " + logsFolder.toString());
        }
        return super.customizeContext(context, settings);
    }
}

