/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.DiagDictionaryEntry;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class DiagManager {
    public static final int VARIABLE = 1;
    public static final int CONSTANT = 2;
    public static final int COUNTER = 3;
    protected static final Vector<Data> regList = new Vector();
    protected static final HashMap<Class, Class> diagClasses = new HashMap();
    private static boolean allowAllReg = false;

    public static boolean register(Data diag) {
        if (allowAllReg || diagClasses.get(diag.getClass()) != null) {
            regList.add(diag);
            return true;
        }
        return false;
    }

    public static void registerClass(String diagName) throws ClassNotFoundException, IllegalAccessException {
        Class<?> cl = Class.forName(diagName);
        diagClasses.put(cl, cl);
    }

    public static void registerAllClasses(boolean b) {
        allowAllReg = b;
    }

    public static String allToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Diagnostics:");
        Enumeration<Data> e = regList.elements();
        while (e.hasMoreElements()) {
            sb.append('\n');
            Data o = e.nextElement();
            sb.append(DiagManager.toDiagString(o));
        }
        return sb.toString();
    }

    public static String toDiagString(Data diag) {
        StringBuilder d = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        int cols = 0;
        diag.update();
        String prefix = diag.getPrefix();
        String title = diag.getTitle();
        List dictionary = diag.getDictionary();
        if (dictionary == null) {
            return "";
        }
        sb.append("========== ").append(title).append(" (").append(prefix).append(") ========== \n");
        Iterator iter = dictionary.iterator();
        DiagDictionaryEntry entry = null;
        while (iter.hasNext()) {
            Object value;
            entry = (DiagDictionaryEntry)iter.next();
            String name = entry.name;
            try {
                Field f = diag.getClass().getDeclaredField(name);
                f.setAccessible(true);
                Class<?> classType = f.getType();
                value = classType == Long.TYPE ? String.valueOf(f.getLong(diag)) : (classType == Integer.TYPE ? String.valueOf(f.getInt(diag)) : (classType == Float.TYPE ? String.valueOf(f.getFloat(diag)) : (classType == Short.TYPE ? String.valueOf(f.getShort(diag)) : (classType == Byte.TYPE ? String.valueOf(f.getByte(diag)) : (classType == Boolean.TYPE ? String.valueOf(f.getBoolean(diag)) : (classType == Character.TYPE ? String.valueOf(f.getChar(diag)) : (classType == Double.TYPE ? String.valueOf(f.getDouble(diag)) : f.get(diag).toString())))))));
            }
            catch (Exception e) {
                value = "Exception getting field value for '" + name + "': " + e;
            }
            d.setLength(0);
            d.append(name).append('=').append((String)value);
            if (cols > 0 && cols + d.length() > 78) {
                sb.append('\n');
                cols = d.length();
            } else if (cols == 0) {
                cols += d.length();
            } else {
                sb.append(", ");
                cols += d.length();
            }
            cols += 2;
            sb.append((CharSequence)d);
        }
        return sb.toString();
    }

    public static void registerClasses(Properties props, String prefix) throws ClassNotFoundException, IllegalAccessException {
        String value = props.getProperty(prefix + "all");
        if (value != null && value.equalsIgnoreCase("true")) {
            DiagManager.registerAllClasses(true);
            return;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String className;
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix) || (className = key.substring(prefix.length())).length() == 0 || !(value = props.getProperty(key)).equalsIgnoreCase("true")) continue;
            DiagManager.registerClass(className);
        }
    }

    public static interface Data {
        public void update();

        public List getDictionary();

        public String getPrefix();

        public String getTitle();
    }
}

