/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket;

import com.sun.messaging.jmq.io.BigPacketException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnable;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.MQWebSocket;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.WebSocketIPService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.MQThread;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.spi.AbstractSelectableChannel;

public final class WebSocketMQIPConnection
extends IMQIPConnection
implements Runnable {
    private static boolean DEBUG = Globals.getLogger().getLevel() <= 4;
    private MQWebSocket websocket = null;
    private Thread writerThread = null;
    private Object assignWriteLock = new Object();
    private boolean writeThreadAssigned = false;

    public WebSocketMQIPConnection(WebSocketIPService svc, PacketRouter router, MQWebSocket ws) throws IOException, BrokerException {
        super(svc, null, router);
        this.websocket = ws;
        this.setRemoteIP(this.getRemoteAddress().getAddress());
        if (svc.useDedicatedWriter()) {
            this.writerThread = new MQThread(this, "GrizzlyMQIPConnection");
            this.writerThread.start();
        }
    }

    @Override
    protected InetAddress getRemoteAddress() {
        if (this.websocket == null) {
            return null;
        }
        return this.websocket.getRemoteAddress();
    }

    @Override
    protected int getRemotePort() {
        return this.websocket.getRemotePort();
    }

    @Override
    public int getLocalPort() {
        return this.websocket.getLocalPort();
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public synchronized AbstractSelectableChannel getChannel() {
        throw new RuntimeException("Unexpected call: " + this.getClass().getName() + ".getChannel()");
    }

    @Override
    protected void closeProtocolStream() throws IOException {
        this.websocket.close();
    }

    @Override
    public void sendControlMessage(Packet msg) {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyMQIPConnection:sendControlMessage: " + msg + ", " + this.isValid());
        }
        if (!this.isValid() && msg.getPacketType() != 28) {
            this.logger.log(8, "Internal Warning: message " + msg + "queued on destroyed connection " + this);
        }
        if (!this.websocket.isConnected() && msg.getPacketType() == 28) {
            return;
        }
        try {
            if (WebSocketMQIPConnection.getDEBUG() || WebSocketMQIPConnection.getDumpPacket() || WebSocketMQIPConnection.getDumpOutPacket()) {
                this.dumpControlPacket(msg);
            }
            this.websocket.writePacket(msg);
        }
        catch (Exception e) {
            this.logger.logStack(16, "Failed to send control packet " + msg + " to " + this.websocket, e);
        }
    }

    public void receivedPacket(Packet pkt) {
        this.readpkt = pkt;
    }

    @Override
    protected boolean readInPacket(Packet p) throws IOException {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyMQIPConnection:readInPacket: " + this.readpkt);
        }
        if (this.readpkt == null) {
            throw new IOException("No packet to read");
        }
        return true;
    }

    @Override
    protected boolean writeOutPacket(Packet p) throws IOException {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyMQIPConnection:writeOutPacket(" + p + ") to " + this.websocket);
        }
        this.websocket.writePacket(p);
        return true;
    }

    @Override
    protected void handleWriteException(Throwable e) throws IOException, OutOfMemoryError {
        super.handleWriteException(e);
    }

    @Override
    protected void handleBigPacketException(Packet pkt, BigPacketException e) {
        super.handleBigPacketException(pkt, e);
    }

    @Override
    protected void handleIllegalArgumentExceptionPacket(Packet pkt, IllegalArgumentException e) {
        super.handleIllegalArgumentExceptionPacket(pkt, e);
    }

    @Override
    public synchronized void threadAssigned(OperationRunnable runner, int events) {
        throw new UnsupportedOperationException("Unexpected call: GrizzlyMQIPConnection.threadAssigned()");
    }

    @Override
    protected void localFlushCtrl() {
        throw new UnsupportedOperationException("Unexpected call: GrizzlyMQIPConnection.localFlushCtrl()");
    }

    @Override
    protected void localFlush() {
        throw new UnsupportedOperationException("Unexpected call: GrizzlyMQIPConnection.localFlush()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean assignWriteThread(boolean b) {
        Object object = this.assignWriteLock;
        synchronized (object) {
            if (b && this.writeThreadAssigned) {
                return false;
            }
            this.writeThreadAssigned = b;
            return true;
        }
    }

    @Override
    public void run() {
        while (this.isValid()) {
            try {
                this.writeData(true);
            }
            catch (IOException e) {
                if (!this.isValid()) continue;
                this.logger.logStack(32, "Exception in writing data on conection " + this, e);
            }
        }
    }
}

