/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.usermgr;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.file.JMQFileUserRepository;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.CmdRunner;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.HelpPrinter;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.Output;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrException;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrOptionParser;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrOptions;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrProperties;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrUtils;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.options.BadNameValueArgException;
import com.sun.messaging.jmq.util.options.InvalidBasePropNameException;
import com.sun.messaging.jmq.util.options.InvalidHardCodedValueException;
import com.sun.messaging.jmq.util.options.MissingArgException;
import com.sun.messaging.jmq.util.options.OptionException;
import com.sun.messaging.jmq.util.options.UnrecognizedOptionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class UserMgr
implements UserMgrOptions {
    private static BrokerResources br = Globals.getBrokerResources();

    public static void main(String[] args) {
        HelpPrinter hp;
        int exitcode = 0;
        boolean errorIfNotExists = true;
        if (UserMgr.silentModeOptionSpecified(args)) {
            Output.setSilentMode(true);
        }
        if (UserMgr.createInstanceSpecified(args)) {
            errorIfNotExists = false;
        }
        if (UserMgr.shortHelpOptionSpecified(args)) {
            hp = new HelpPrinter();
            hp.printShortHelp();
            System.exit(0);
        } else if (UserMgr.longHelpOptionSpecified(args)) {
            hp = new HelpPrinter();
            hp.printLongHelp();
            System.exit(0);
        }
        if (UserMgr.versionOptionSpecified(args)) {
            UserMgr.printBanner();
            UserMgr.printVersion();
            System.exit(0);
        }
        args = UserMgr.filterSystemProperties(args);
        UserMgrProperties userMgrProps = null;
        try {
            userMgrProps = UserMgrOptionParser.parseArgs(args);
        }
        catch (OptionException e) {
            UserMgr.handleArgsParsingExceptions(e);
            System.exit(1);
        }
        try {
            UserMgr.checkInstance(userMgrProps, errorIfNotExists);
            UserMgr.checkOptions(userMgrProps);
        }
        catch (UserMgrException ome) {
            UserMgr.handleCheckOptionsExceptions(ome);
            System.exit(1);
        }
        CmdRunner cmdRunner = new CmdRunner(userMgrProps);
        exitcode = cmdRunner.runCommands();
        System.exit(exitcode);
    }

    private static void checkOptions(UserMgrProperties userMgrProps) throws UserMgrException {
        String cmd = userMgrProps.getCommand();
        if (cmd == null) {
            UserMgrException objMgrEx = new UserMgrException(0);
            objMgrEx.setProperties(userMgrProps);
            throw objMgrEx;
        }
        if (cmd.equals("add")) {
            UserMgr.checkAdd(userMgrProps);
        } else if (cmd.equals("delete")) {
            UserMgr.checkDelete(userMgrProps);
        } else if (cmd.equals("list")) {
            UserMgr.checkList();
        } else if (cmd.equals("update")) {
            UserMgr.checkUpdate(userMgrProps);
        } else if (cmd.equals(".exists")) {
            UserMgr.checkExists(userMgrProps);
        } else if (cmd.equals(".getgroup")) {
            UserMgr.checkGetGroup(userMgrProps);
        } else if (cmd.equals(".getgroupsize")) {
            UserMgr.checkGetGroupSize(userMgrProps);
        } else if (cmd.equals("encode")) {
            UserMgr.checkEncode(userMgrProps);
        } else if (cmd.equals("decode")) {
            UserMgr.checkDecode(userMgrProps);
        } else {
            UserMgrException objMgrEx = new UserMgrException(1);
            objMgrEx.setProperties(userMgrProps);
            throw objMgrEx;
        }
    }

    private static void checkAdd(UserMgrProperties userMgrProps) throws UserMgrException {
        UserMgr.promptForUserName(userMgrProps);
        UserMgr.checkUserName(userMgrProps);
        UserMgr.promptForPassword(userMgrProps);
        UserMgr.checkPassword(userMgrProps);
        String role = userMgrProps.getRole();
        if (role != null) {
            UserMgr.checkRole(userMgrProps);
        }
        UserMgr.checkNoActiveInAdd(userMgrProps);
    }

    private static void checkDelete(UserMgrProperties userMgrProps) throws UserMgrException {
        UserMgr.checkUserName(userMgrProps);
    }

    private static void checkList() {
    }

    private static void checkUpdate(UserMgrProperties userMgrProps) throws UserMgrException {
        UserMgr.checkUserName(userMgrProps);
        UserMgr.checkPasswordOrActive(userMgrProps);
    }

    private static void checkExists(UserMgrProperties userMgrProps) throws UserMgrException {
        UserMgr.checkUserName(userMgrProps);
    }

    private static void checkGetGroup(UserMgrProperties userMgrProps) throws UserMgrException {
        UserMgr.checkUserName(userMgrProps);
    }

    private static void checkGetGroupSize(UserMgrProperties userMgrProps) throws UserMgrException {
        UserMgr.checkRole(userMgrProps);
    }

    private static void checkEncode(UserMgrProperties userMgrProps) throws UserMgrException {
        UserMgr.checkSrc(userMgrProps);
    }

    private static void checkDecode(UserMgrProperties userMgrProps) throws UserMgrException {
        UserMgr.checkSrc(userMgrProps);
    }

    private static String checkPassword(UserMgrProperties userMgrProps) throws UserMgrException {
        String passwd = userMgrProps.getPassword();
        String passfile = userMgrProps.getPassfile();
        if (passwd == null && passfile == null) {
            UserMgrException ex = new UserMgrException(2);
            ex.setProperties(userMgrProps);
            throw ex;
        }
        return passwd;
    }

    private static void checkPasswordOrActive(UserMgrProperties userMgrProps) throws UserMgrException {
        String passwd = userMgrProps.getPassword();
        String passfile = userMgrProps.getPassfile();
        String activeValue = userMgrProps.getActiveValue();
        if (passfile == null && passwd == null && activeValue == null) {
            UserMgrException ex = new UserMgrException(15);
            ex.setProperties(userMgrProps);
            throw ex;
        }
        if (activeValue == null) {
            return;
        }
        if (activeValue.equalsIgnoreCase("t") || activeValue.equalsIgnoreCase(Boolean.TRUE.toString())) {
            userMgrProps.setActiveValue(Boolean.TRUE.toString());
            return;
        }
        if (activeValue.equalsIgnoreCase("f") || activeValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
            userMgrProps.setActiveValue(Boolean.FALSE.toString());
            return;
        }
        UserMgrException ex = new UserMgrException(17);
        ex.setProperties(userMgrProps);
        throw ex;
    }

    private static void checkNoActiveInAdd(UserMgrProperties userMgrProps) throws UserMgrException {
        String activeValue = userMgrProps.getActiveValue();
        if (activeValue == null) {
            return;
        }
        UserMgrException ex = new UserMgrException(19);
        ex.setProperties(userMgrProps);
        throw ex;
    }

    private static void checkSrc(UserMgrProperties userMgrProps) throws UserMgrException {
        String srcFile = userMgrProps.getSrc();
        if (srcFile == null) {
            UserMgrException ex = new UserMgrException(24);
            ex.setProperties(userMgrProps);
            throw ex;
        }
    }

    private static String promptForUserName(UserMgrProperties userMgrProps) throws UserMgrException {
        String userName = userMgrProps.getUserName();
        if (userName != null) {
            return userName;
        }
        userName = UserMgrUtils.getUserInput(userMgrProps, br.getString("B1061"));
        userMgrProps.setUserName(userName);
        return userName;
    }

    private static void promptForPassword(UserMgrProperties userMgrProps) throws UserMgrException {
        String password = userMgrProps.getPassword();
        String passfile = userMgrProps.getPassfile();
        if (passfile != null) {
            return;
        }
        if (password != null) {
            return;
        }
        password = UserMgrUtils.getPasswordInput(userMgrProps, br.getString("B1062"));
        userMgrProps.setPassword(password);
    }

    private static String checkUserName(UserMgrProperties userMgrProps) throws UserMgrException {
        String userName = userMgrProps.getUserName();
        if (userName == null) {
            UserMgrException ex = new UserMgrException(4);
            ex.setProperties(userMgrProps);
            throw ex;
        }
        if (userName.length() == 0) {
            UserMgrException ex = new UserMgrException(23);
            ex.setProperties(userMgrProps);
            throw ex;
        }
        if (!UserMgr.isValidUserName(userName)) {
            UserMgrException ex = new UserMgrException(16);
            ex.setProperties(userMgrProps);
            throw ex;
        }
        return userName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkInstance(UserMgrProperties userMgrProps, boolean errorIfNotExists) throws UserMgrException {
        File pwfile;
        String instance = userMgrProps.getInstance();
        String cmd = userMgrProps.getCommand();
        if (cmd != null) {
            if (cmd.equals("encode")) return;
            if (cmd.equals("decode")) {
                return;
            }
        }
        if (instance == null) {
            instance = "imqbroker";
            userMgrProps.setInstance(instance);
        }
        Properties props = new Properties(System.getProperties());
        props.put("imq.instancename", instance);
        Globals.init(props, false, false);
        String instancedir = Globals.getInstanceEtcDir();
        String pwdirpath = JMQFileUserRepository.getPasswordDirPath(Globals.getConfig(), true);
        File dirpath = new File(pwdirpath);
        File dir = new File(instancedir);
        boolean createpwdFileIfNotExist = true;
        if (dirpath.equals(dir)) {
            createpwdFileIfNotExist = false;
            if (!dir.exists()) {
                if (errorIfNotExists) {
                    UserMgrException ex = new UserMgrException(21);
                    ex.setProperties(userMgrProps);
                    throw ex;
                }
                try {
                    Broker.initializePasswdFile();
                }
                catch (IOException iex) {
                    UserMgrException ex = new UserMgrException(25, (Throwable)iex);
                    ex.setProperties(userMgrProps);
                    throw ex;
                }
            }
        }
        if ((pwfile = JMQFileUserRepository.getPasswordFile(Globals.getConfig(), true)).exists()) {
            userMgrProps.setPasswordFile(FileUtil.getCanonicalPath(pwfile.toString()));
            return;
        }
        if (!createpwdFileIfNotExist) {
            UserMgrException ex = new UserMgrException(7);
            ex.setProperties(userMgrProps);
            ex.setPasswordFile(FileUtil.getCanonicalPath(pwfile.toString()));
            throw ex;
        }
        try {
            pwfile.createNewFile();
            userMgrProps.setPasswordFile(FileUtil.getCanonicalPath(pwfile.toString()));
            return;
        }
        catch (IOException e) {
            UserMgrException ex = new UserMgrException(26, (Throwable)e);
            ex.setProperties(userMgrProps);
            ex.setPasswordFile(FileUtil.getCanonicalPath(pwfile.toString()));
            throw ex;
        }
    }

    private static boolean isValidUserName(String userName) {
        if (userName == null) {
            return false;
        }
        for (UserMgrOptions.OPTION_USERNAME_INVALID_CHARS oc : UserMgrOptions.OPTION_USERNAME_INVALID_CHARS.values()) {
            if (userName.indexOf(oc.getChar()) == -1) continue;
            return false;
        }
        return true;
    }

    private static String checkRole(UserMgrProperties userMgrProps) throws UserMgrException {
        String role = userMgrProps.getRole();
        if (role == null) {
            UserMgrException ex = new UserMgrException(5);
            ex.setProperties(userMgrProps);
            throw ex;
        }
        for (UserMgrOptions.OPTION_ROLE_VALID_VALUES ov : UserMgrOptions.OPTION_ROLE_VALID_VALUES.values()) {
            if (!role.equals(ov.toString())) continue;
            return role;
        }
        UserMgrException ex = new UserMgrException(6);
        ex.setProperties(userMgrProps);
        throw ex;
    }

    private static void printBanner() {
        Version version = new Version();
        Output.stdOutPrintln(version.getBanner(false));
    }

    private static boolean shortHelpOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-h") && !args[i].equals("-help")) continue;
            return true;
        }
        return false;
    }

    private static boolean longHelpOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-H") && !args[i].equals("-Help")) continue;
            return true;
        }
        return false;
    }

    private static boolean versionOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-v") && !args[i].equals("-version")) continue;
            return true;
        }
        return false;
    }

    private static boolean silentModeOptionSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-s")) continue;
            return true;
        }
        return false;
    }

    private static boolean createInstanceSpecified(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-c")) continue;
            return true;
        }
        return false;
    }

    private static String[] filterSystemProperties(String[] args) {
        ArrayList<String> newargs = new ArrayList<String>();
        boolean found = false;
        for (int n = 0; n < args.length; ++n) {
            if (args[n].startsWith("-D")) {
                found = true;
                int value_index = 0;
                String prop_name = null;
                String prop_value = "";
                value_index = args[n].indexOf(61);
                if (args[n].length() <= 2) continue;
                if (value_index < 0) {
                    prop_name = args[n].substring(2);
                } else if (value_index == args[n].length() - 1) {
                    prop_name = args[n].substring(2, value_index);
                } else {
                    prop_name = args[n].substring(2, value_index);
                    prop_value = args[n].substring(value_index + 1);
                }
                System.setProperty(prop_name, prop_value);
                continue;
            }
            newargs.add(args[n]);
        }
        if (!found) {
            return args;
        }
        return newargs.toArray(new String[newargs.size()]);
    }

    private static void printVersion() {
        Version version = new Version();
        Output.stdOutPrintln(version.getVersion());
        Output.stdOutPrintln(br.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
    }

    private static void handleArgsParsingExceptions(OptionException e) {
        String option = e.getOption();
        if (e instanceof UnrecognizedOptionException) {
            Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3029", option));
        } else if (e instanceof InvalidBasePropNameException) {
            Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3030", option));
        } else if (e instanceof InvalidHardCodedValueException) {
            Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3031", option));
        } else if (e instanceof MissingArgException) {
            Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3032", option));
        } else if (e instanceof BadNameValueArgException) {
            BadNameValueArgException bnvae = (BadNameValueArgException)e;
            String badArg = bnvae.getArg();
            Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3033", badArg, option));
        } else {
            Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3034"));
        }
    }

    private static void handleCheckOptionsExceptions(UserMgrException e) {
        UserMgrProperties userMgrProps = e.getProperties();
        String cmd = userMgrProps.getCommand();
        String role = userMgrProps.getRole();
        String userName = userMgrProps.getUserName();
        String activeValue = userMgrProps.getActiveValue();
        int type = e.getType();
        switch (type) {
            case 0: {
                UserMgr.printBanner();
                HelpPrinter hp = new HelpPrinter();
                hp.printShortHelp();
                break;
            }
            case 1: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3036", userMgrProps.getCommand()));
                break;
            }
            case 2: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3038", "-passfile", "-p"));
                break;
            }
            case 15: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3039"));
                break;
            }
            case 17: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3089", activeValue));
                break;
            }
            case 6: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3040", cmd, role));
                Output.stdErrPrintln(br.getString("B3041"));
                for (UserMgrOptions.OPTION_ROLE_VALID_VALUES ov : UserMgrOptions.OPTION_ROLE_VALID_VALUES.values()) {
                    Output.stdErrPrintln("\t" + ov);
                }
                break;
            }
            case 4: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3042", "-u"));
                break;
            }
            case 5: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3043", "-g"));
                break;
            }
            case 16: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3067", userName));
                break;
            }
            case 18: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3090"));
                break;
            }
            case 19: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3110"));
                break;
            }
            case 21: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3137", userMgrProps.getInstance()));
                break;
            }
            case 7: {
                Output.stdErrPrintln(br.getString("B3044"), br.getKString("B3046", e.getPasswordFile()));
                break;
            }
            case 23: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3166"));
                break;
            }
            case 24: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3310", "-src"));
                break;
            }
            case 25: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3243"));
                break;
            }
            case 26: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3280", e.getPasswordFile(), e.getCause().toString()));
                break;
            }
            default: {
                Output.stdErrPrintln(br.getString("B3045"), br.getKString("B3037"));
            }
        }
    }
}

