/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.api;

import com.sun.messaging.bridge.api.ByteBufferWrapper;
import com.sun.messaging.bridge.api.StompFrameMessageFactory;
import com.sun.messaging.bridge.api.StompFrameParseException;
import com.sun.messaging.jmq.util.LoggerWrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public abstract class StompFrameMessage {
    private LoggerWrapper logger = null;
    public static final String STOMP_PROTOCOL_VERSION_10 = "1.0";
    public static final String STOMP_PROTOCOL_VERSION_11 = "1.1";
    public static final String STOMP_PROTOCOL_VERSION_12 = "1.2";
    public static final String HEADER_SEPERATOR = ":";
    private static final String NEWLINESTR = "\n";
    private static final byte NEWLINE_BYTE = 10;
    private static final byte NULL_BYTE = 0;
    private static final byte[] END_OF_FRAME = new byte[]{0, 10};
    public static final int MIN_COMMAND_LEN = 3;
    protected static final int MAX_COMMAND_LEN = 1024;
    protected static final int MAX_HEADER_LEN = 10240;
    private static final int MAX_HEADERS = 1000;
    private Command _command = Command.UNKNOWN;
    private ArrayList<String> _requiredHeaders = new ArrayList();
    private LinkedHashMap<String, String> _headers = new LinkedHashMap();
    private Integer _contentLength = null;
    protected ParseStage _parseStage = ParseStage.COMMAND;
    private ByteArrayOutputStream _bao = null;
    private byte[] _body = null;
    private Exception _parseException = null;
    private boolean _fatalERROR = false;
    private boolean isTextMessage = false;

    protected StompFrameMessage(Command cmd, LoggerWrapper logger) {
        this.logger = logger;
        this._command = cmd;
        switch (cmd) {
            case CONNECT: 
            case STOMP: {
                this._requiredHeaders.add("login");
                this._requiredHeaders.add("passcode");
                break;
            }
            case SEND: {
                this._requiredHeaders.add("destination");
                break;
            }
        }
    }

    public boolean isTextMessage() {
        return this.isTextMessage;
    }

    public void setTextMessageFlag() {
        this.isTextMessage = true;
    }

    public void setFatalERROR() {
        this._fatalERROR = true;
    }

    public boolean isFatalERROR() {
        return this._fatalERROR;
    }

    public Exception getParseException() {
        return this._parseException;
    }

    public Command getCommand() {
        return this._command;
    }

    public void addHeader(String key, String val) {
        this._headers.put(key, val);
    }

    public LinkedHashMap<String, String> getHeaders() {
        return this._headers;
    }

    public String getHeader(String key) {
        return this._headers.get(key);
    }

    public byte[] getBody() {
        if (this._body != null) {
            return this._body;
        }
        if (this._bao == null) {
            return new byte[0];
        }
        this._body = this._bao.toByteArray();
        return this._body;
    }

    public String getBodyText() throws StompFrameParseException {
        String text = "";
        if (this._body != null) {
            try {
                return new String(this._body, "UTF-8");
            }
            catch (Exception e) {
                throw new StompFrameParseException(e.getMessage(), e);
            }
        }
        if (this._bao == null) {
            return text;
        }
        this._body = this._bao.toByteArray();
        try {
            text = new String(this._body, "UTF-8");
            return text;
        }
        catch (Exception e) {
            throw new StompFrameParseException(this.getKStringX_CANNOT_PARSE_BODY_TO_TEXT(this.getCommand().toString(), e.getMessage()));
        }
    }

    private void writeByteToBody(byte b) throws Exception {
        if (this._bao == null) {
            this._bao = this.getContentLength() != -1 ? new ByteArrayOutputStream(this.getContentLength()) : new ByteArrayOutputStream();
        }
        this._bao.write(b);
    }

    public void setBody(byte[] data) {
        this._body = data;
    }

    protected void writeExceptionToBody(Throwable t) throws Exception {
        if (t == null) {
            return;
        }
        if (this._bao == null) {
            this._bao = new ByteArrayOutputStream();
        }
        t.printStackTrace(new PrintStream((OutputStream)this._bao, true, "UTF-8"));
        this.addHeader("content-length", String.valueOf(this.getBodySize()));
    }

    private int getBodySize() {
        if (this._bao == null) {
            return 0;
        }
        return this._bao.size();
    }

    protected void setNextParseStage(ParseStage s) {
        this._parseStage = s;
        if (s == ParseStage.BODY) {
            for (String key : this._requiredHeaders) {
                if (this._headers.get(key) != null || this._parseException != null) continue;
                this._parseException = new StompFrameParseException(this.getKStringX_HEADER_NOT_SPECIFIED_FOR(key, this.getCommand().toString()));
                this.logger.logSevere(this._parseException.getMessage(), null);
            }
        }
        if (s == ParseStage.DONE) {
            try {
                if (this._bao != null) {
                    this._bao.close();
                }
            }
            catch (Exception e) {
                this.logger.logWarn("Exception in closing ByteArrayOutputStream:" + e.getMessage(), null);
            }
        }
    }

    public ParseStage getNextParseStage() {
        return this._parseStage;
    }

    public int getContentLength() {
        int len;
        block4: {
            if (this._contentLength != null) {
                return this._contentLength;
            }
            String val = this._headers.get("content-length");
            if (val == null) {
                return -1;
            }
            len = -1;
            try {
                len = Integer.parseInt(val.trim());
            }
            catch (NumberFormatException e) {
                if (this._parseException != null) break block4;
                this._parseException = new StompFrameParseException(this.getKStringX_INVALID_HEADER_VALUE(val, "content-length"));
                len = -1;
                this.logger.logSevere(this._parseException.getMessage(), null);
            }
        }
        this._contentLength = len;
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBufferWrapper marshall(Object obj, String protocolVersion) throws IOException {
        OutputStream bos = null;
        FilterOutputStream dos = null;
        boolean needsEscaping = !protocolVersion.equals(STOMP_PROTOCOL_VERSION_10) && this.getCommand() != Command.CONNECTED;
        try {
            bos = this.newBufferOutputStream(obj);
            dos = new DataOutputStream(bos);
            StringBuilder sbuf = new StringBuilder();
            sbuf.append((Object)this.getCommand());
            sbuf.append(NEWLINESTR);
            if (needsEscaping) {
                for (String key : this._headers.keySet()) {
                    sbuf.append(StompFrameMessage.escapeSpecialChars(key));
                    sbuf.append(HEADER_SEPERATOR);
                    sbuf.append(StompFrameMessage.escapeSpecialChars(this._headers.get(key)));
                    sbuf.append(NEWLINESTR);
                }
            } else {
                for (String key : this._headers.keySet()) {
                    sbuf.append(key);
                    sbuf.append(HEADER_SEPERATOR);
                    sbuf.append(this._headers.get(key));
                    sbuf.append(NEWLINESTR);
                }
            }
            sbuf.append(NEWLINESTR);
            dos.write(sbuf.toString().getBytes("UTF-8"));
            dos.write(this.getBody());
            dos.write(END_OF_FRAME);
            ((DataOutputStream)dos).flush();
            ByteBufferWrapper bb = this.getBuffer(bos);
            bb.flip();
            ByteBufferWrapper byteBufferWrapper = bb;
            return byteBufferWrapper;
        }
        finally {
            if (dos != null) {
                dos.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    static String unescapeSpecialChars(String keyOrValue) {
        StringBuilder result = new StringBuilder(keyOrValue.length());
        boolean backslashSeen = false;
        for (int i = 0; i < keyOrValue.length(); ++i) {
            char c = keyOrValue.charAt(i);
            if (c == '\\') {
                if (backslashSeen) {
                    result.append('\\');
                    backslashSeen = false;
                    continue;
                }
                backslashSeen = true;
                continue;
            }
            if (backslashSeen) {
                if (c == 'c') {
                    result.append(':');
                } else if (c == 'r') {
                    result.append('\r');
                } else if (c == 'n') {
                    result.append('\n');
                } else {
                    throw new IllegalArgumentException("Undefined escape sequence in header: octets 92 and " + c);
                }
                backslashSeen = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    static String escapeSpecialChars(String keyOrValue) {
        return keyOrValue.replace("\\", "\\\\").replace(HEADER_SEPERATOR, "\\c").replace("\r", "\\r").replace(NEWLINESTR, "\\n");
    }

    public void parseHeader(ByteBufferWrapper buf, String protocolVersion) throws Exception {
        boolean needsUnescaping;
        String header = null;
        boolean bl = needsUnescaping = this.getCommand() != Command.CONNECT && !protocolVersion.equals(STOMP_PROTOCOL_VERSION_10);
        if (this.logger.isFineLoggable()) {
            this.logger.logFine("in parseHeader: position=" + buf.position() + ", remaining=" + buf.remaining(), null);
        }
        try {
            while (buf.hasRemaining()) {
                byte[] line = StompFrameMessage.parseLine(buf, 10240);
                if (line == null) {
                    return;
                }
                header = new String(line, "UTF-8");
                if (this.logger.isFineLoggable()) {
                    this.logger.logFine("parseHeader: got line byte-length=" + line.length + ", header=:" + header + ", header-length=" + header.length() + ", position=" + buf.position(), null);
                }
                if (header.trim().length() == 0) {
                    this.setNextParseStage(ParseStage.BODY);
                    if (this.logger.isFinestLoggable()) {
                        this.logger.logFinest("parseHeader: DONE - position=" + buf.position(), null);
                    }
                    return;
                }
                int index = header.indexOf(HEADER_SEPERATOR);
                if (index == -1) {
                    if (this._parseException == null) {
                        this._parseException = new StompFrameParseException(this.getKStringX_INVALID_HEADER(header));
                        this.logger.logSevere(this._parseException.getMessage(), null);
                    }
                    index = header.length() - 1;
                }
                String key = header.substring(0, index).trim();
                String val = header.substring(index + 1, header.length()).trim();
                if (needsUnescaping) {
                    key = StompFrameMessage.unescapeSpecialChars(key);
                    val = StompFrameMessage.unescapeSpecialChars(val);
                }
                this.addHeader(key, val);
                if (this._headers.size() <= 1000) continue;
                throw new StompFrameParseException(this.getKStringX_MAX_HEADERS_EXCEEDED(1000));
            }
        }
        catch (Exception e) {
            if (e instanceof StompFrameParseException) {
                throw e;
            }
            throw new StompFrameParseException(this.getKStringX_EXCEPTION_PARSE_HEADER(header, e.getMessage()), e);
        }
    }

    public void readBody(ByteBufferWrapper buf) throws Exception {
        int clen = this.getContentLength();
        if (this.logger.isFinestLoggable()) {
            this.logger.logFinest("in readBody:contentLen=" + this._contentLength + ", position=" + buf.position() + ", remaining=" + buf.remaining() + ", bodySize=" + this.getBodySize(), null);
        }
        while (buf.hasRemaining()) {
            if (clen != -1 && clen == this.getBodySize()) {
                if (this.logger.isFinestLoggable()) {
                    this.logger.logFinest("Body has beed read!", null);
                }
                this.setNextParseStage(ParseStage.NULL);
                return;
            }
            byte b = buf.get();
            if (b == 0 && clen == -1) {
                byte bb;
                int pos;
                if (buf.hasRemaining()) {
                    pos = buf.position();
                    bb = buf.get();
                    if (bb != 10 && bb != 13) {
                        buf.position(pos);
                    }
                }
                if (buf.hasRemaining()) {
                    pos = buf.position();
                    bb = buf.get();
                    if (bb != 10) {
                        buf.position(pos);
                    }
                }
                if (this.logger.isFinestLoggable()) {
                    this.logger.logFinest("readBody: DONE - position=" + buf.position() + ", remaining=" + buf.remaining(), null);
                }
                this.setNextParseStage(ParseStage.DONE);
                return;
            }
            this.writeByteToBody(b);
        }
        if (this.logger.isFinestLoggable()) {
            this.logger.logFinest("leaving readBody(): BODY_SIZE=" + this.getBodySize(), null);
        }
    }

    public void readNULL(ByteBufferWrapper buf) throws Exception {
        if (this.logger.isFinestLoggable()) {
            this.logger.logFinest("in readNULL:" + buf.position() + HEADER_SEPERATOR + buf.remaining(), null);
        }
        if (buf.remaining() <= 0) {
            return;
        }
        byte b = buf.get();
        if (b != 0) {
            throw new StompFrameParseException(this.getKStringX_NO_NULL_TERMINATOR("content-length " + this.getContentLength()));
        }
        if (this.logger.isFinestLoggable()) {
            this.logger.logFinest("got NULL readNULL:" + buf.position() + HEADER_SEPERATOR + buf.remaining(), null);
        }
        this.setNextParseStage(ParseStage.DONE);
    }

    public String toString() {
        return this._command + "[" + this._headers + "]";
    }

    public String toLongString() throws Exception {
        return this._command + "[" + this._headers + "][" + this.getBodyText() + "]";
    }

    public static StompFrameMessage parseCommand(ByteBufferWrapper buf, LoggerWrapper logger, StompFrameMessageFactory factory) throws Exception {
        StompFrameMessage message = null;
        String cmd = "";
        if (logger.isFinestLoggable()) {
            logger.logFinest("parseCommand: pos:remaining[" + buf.position() + HEADER_SEPERATOR + buf.remaining() + "]", null);
        }
        try {
            while (cmd.trim().length() == 0) {
                byte[] line = StompFrameMessage.parseLine(buf, 1024);
                if (line == null) {
                    if (logger.isFinestLoggable()) {
                        logger.logFinest("parseCommand: position[" + buf.position() + "] command line not found", null);
                    }
                    return null;
                }
                cmd = new String(line, "UTF-8");
                if (!logger.isFinestLoggable()) continue;
                logger.logFinest("parseCommand: got line:" + cmd + ", position=" + buf.position(), null);
            }
            if (cmd.startsWith(Command.CONNECTED.toString())) {
                message = factory.newStompFrameMessage(Command.CONNECTED, logger);
            } else if (cmd.startsWith(Command.RECEIPT.toString())) {
                message = factory.newStompFrameMessage(Command.RECEIPT, logger);
            } else if (cmd.startsWith(Command.MESSAGE.toString())) {
                message = factory.newStompFrameMessage(Command.MESSAGE, logger);
            } else if (cmd.startsWith(Command.ERROR.toString())) {
                message = factory.newStompFrameMessage(Command.ERROR, logger);
            } else if (cmd.startsWith(Command.CONNECT.toString()) || cmd.startsWith(Command.STOMP.toString())) {
                message = factory.newStompFrameMessage(Command.CONNECT, logger);
            } else if (cmd.startsWith(Command.SEND.toString())) {
                message = factory.newStompFrameMessage(Command.SEND, logger);
            } else if (cmd.startsWith(Command.SUBSCRIBE.toString())) {
                message = factory.newStompFrameMessage(Command.SUBSCRIBE, logger);
            } else if (cmd.startsWith(Command.ACK.toString())) {
                message = factory.newStompFrameMessage(Command.ACK, logger);
            } else if (cmd.startsWith(Command.NACK.toString())) {
                message = factory.newStompFrameMessage(Command.NACK, logger);
            } else if (cmd.startsWith(Command.UNSUBSCRIBE.toString())) {
                message = factory.newStompFrameMessage(Command.UNSUBSCRIBE, logger);
            } else if (cmd.startsWith(Command.BEGIN.toString())) {
                message = factory.newStompFrameMessage(Command.BEGIN, logger);
            } else if (cmd.startsWith(Command.COMMIT.toString())) {
                message = factory.newStompFrameMessage(Command.COMMIT, logger);
            } else if (cmd.startsWith(Command.ABORT.toString())) {
                message = factory.newStompFrameMessage(Command.ABORT, logger);
            } else if (cmd.startsWith(Command.DISCONNECT.toString())) {
                message = factory.newStompFrameMessage(Command.DISCONNECT, logger);
            } else {
                message = factory.newStompFrameMessage(Command.ERROR, logger);
                String emsg = message.getKStringX_UNKNOWN_STOMP_CMD(cmd);
                message._parseException = new StompFrameParseException(emsg);
                logger.logSevere(emsg, null);
            }
            if (logger.isFinestLoggable()) {
                logger.logFinest("parseCommand: DONE - cmd=" + cmd + ", position=" + buf.position(), null);
            }
            message.setNextParseStage(ParseStage.HEADER);
        }
        catch (Exception e) {
            if (e instanceof StompFrameParseException) {
                throw e;
            }
            throw new StompFrameParseException(e.getMessage(), e);
        }
        return message;
    }

    private static byte[] parseLine(ByteBufferWrapper buf, int maxbytes) throws Exception {
        byte[] line = new byte[maxbytes];
        int pos = buf.position();
        boolean foundline = false;
        int i = 0;
        while (buf.hasRemaining()) {
            byte b = buf.get();
            if (b == 10) {
                foundline = true;
                break;
            }
            line[i++] = b;
            if (i < maxbytes - 1) continue;
            StompFrameMessage em = StompFrameMessage.newStompFrameMessageERROR();
            throw new StompFrameParseException(em.getKStringX_MAX_LINELEN_EXCEEDED(maxbytes));
        }
        if (!foundline) {
            buf.position(pos);
            return null;
        }
        byte[] tmp = new byte[i];
        System.arraycopy(line, 0, tmp, 0, i);
        return tmp;
    }

    protected static StompFrameMessage newStompFrameMessageERROR() {
        return new StompFrameMessage(Command.ERROR, null){

            @Override
            protected OutputStream newBufferOutputStream(Object obj) throws IOException {
                throw new RuntimeException("Unexpected call");
            }

            @Override
            protected ByteBufferWrapper getBuffer(OutputStream os) throws IOException {
                throw new RuntimeException("Unexpected call");
            }

            @Override
            protected String getKStringX_CANNOT_PARSE_BODY_TO_TEXT(String command, String emsg) {
                throw new RuntimeException("Unexpected call");
            }

            @Override
            protected String getKStringX_HEADER_NOT_SPECIFIED_FOR(String header, String command) {
                throw new RuntimeException("Unexpected call");
            }

            @Override
            protected String getKStringX_INVALID_HEADER_VALUE(String headerValue, String command) {
                throw new RuntimeException("Unexpected call");
            }

            @Override
            protected String getKStringX_INVALID_HEADER(String headerName) {
                throw new RuntimeException("Unexpected call");
            }

            @Override
            protected String getKStringX_MAX_HEADERS_EXCEEDED(int maxHeaders) {
                throw new RuntimeException("Unexpected call");
            }

            @Override
            protected String getKStringX_EXCEPTION_PARSE_HEADER(String headerName, String emsg) {
                throw new RuntimeException("Unexpected call");
            }

            @Override
            protected String getKStringX_NO_NULL_TERMINATOR(String contentlen) {
                throw new RuntimeException("Unexpected call");
            }

            @Override
            protected String getKStringX_UNKNOWN_STOMP_CMD(String cmd) {
                throw new RuntimeException("Unexpected call");
            }

            @Override
            protected String getKStringX_MAX_LINELEN_EXCEEDED(int maxbytes) {
                throw new RuntimeException("Unexpected call");
            }
        };
    }

    protected abstract OutputStream newBufferOutputStream(Object var1) throws IOException;

    protected abstract ByteBufferWrapper getBuffer(OutputStream var1) throws IOException;

    protected abstract String getKStringX_CANNOT_PARSE_BODY_TO_TEXT(String var1, String var2);

    protected abstract String getKStringX_HEADER_NOT_SPECIFIED_FOR(String var1, String var2);

    protected abstract String getKStringX_INVALID_HEADER_VALUE(String var1, String var2);

    protected abstract String getKStringX_INVALID_HEADER(String var1);

    protected abstract String getKStringX_MAX_HEADERS_EXCEEDED(int var1);

    protected abstract String getKStringX_EXCEPTION_PARSE_HEADER(String var1, String var2);

    protected abstract String getKStringX_NO_NULL_TERMINATOR(String var1);

    protected abstract String getKStringX_UNKNOWN_STOMP_CMD(String var1);

    protected abstract String getKStringX_MAX_LINELEN_EXCEEDED(int var1);

    public static enum Command {
        STOMP,
        CONNECT,
        DISCONNECT,
        SEND,
        SUBSCRIBE,
        UNSUBSCRIBE,
        BEGIN,
        COMMIT,
        ABORT,
        ACK,
        NACK,
        UNKNOWN,
        CONNECTED,
        MESSAGE,
        RECEIPT,
        ERROR;

    }

    public static enum ParseStage {
        COMMAND,
        HEADER,
        BODY,
        NULL,
        DONE;

    }

    public static final class ConnectHeader
    extends Enum<ConnectHeader> {
        public static final String LOGIN = "login";
        public static final String PASSCODE = "passcode";
        public static final String CLIENTID = "client-id";
        public static final String ACCEPT_VERSION = "accept-version";
        public static final String HEART_BEAT = "heart-beat";
        private static final /* synthetic */ ConnectHeader[] $VALUES;

        public static ConnectHeader[] values() {
            return (ConnectHeader[])$VALUES.clone();
        }

        public static ConnectHeader valueOf(String name) {
            return Enum.valueOf(ConnectHeader.class, name);
        }

        private static /* synthetic */ ConnectHeader[] $values() {
            return new ConnectHeader[0];
        }

        static {
            $VALUES = ConnectHeader.$values();
        }
    }

    public static final class SendHeader
    extends Enum<SendHeader> {
        public static final String DESTINATION = "destination";
        public static final String EXPIRES = "expires";
        public static final String PRIORITY = "priority";
        public static final String TYPE = "type";
        public static final String PERSISTENT = "persistent";
        public static final String REPLYTO = "reply-to";
        public static final String CORRELATIONID = "correlation-id";
        private static final /* synthetic */ SendHeader[] $VALUES;

        public static SendHeader[] values() {
            return (SendHeader[])$VALUES.clone();
        }

        public static SendHeader valueOf(String name) {
            return Enum.valueOf(SendHeader.class, name);
        }

        private static /* synthetic */ SendHeader[] $values() {
            return new SendHeader[0];
        }

        static {
            $VALUES = SendHeader.$values();
        }
    }

    public static final class CommonHeader
    extends Enum<CommonHeader> {
        public static final String RECEIPT = "receipt";
        public static final String TRANSACTION = "transaction";
        public static final String CONTENTLENGTH = "content-length";
        public static final String CONTENTTYPE = "content-type";
        private static final /* synthetic */ CommonHeader[] $VALUES;

        public static CommonHeader[] values() {
            return (CommonHeader[])$VALUES.clone();
        }

        public static CommonHeader valueOf(String name) {
            return Enum.valueOf(CommonHeader.class, name);
        }

        private static /* synthetic */ CommonHeader[] $values() {
            return new CommonHeader[0];
        }

        static {
            $VALUES = CommonHeader.$values();
        }
    }

    public static final class AckHeader
    extends Enum<AckHeader> {
        public static final String MESSAGEID = "message-id";
        public static final String SUBSCRIPTION = "subscription";
        public static final String TRANSACTION = "transaction";
        public static final String ID = "id";
        private static final /* synthetic */ AckHeader[] $VALUES;

        public static AckHeader[] values() {
            return (AckHeader[])$VALUES.clone();
        }

        public static AckHeader valueOf(String name) {
            return Enum.valueOf(AckHeader.class, name);
        }

        private static /* synthetic */ AckHeader[] $values() {
            return new AckHeader[0];
        }

        static {
            $VALUES = AckHeader.$values();
        }
    }

    public static final class ConnectedHeader
    extends Enum<ConnectedHeader> {
        public static final String SESSION = "session";
        public static final String VERSION = "version";
        public static final String SERVER = "server";
        public static final String HEART_BEAT = "heart-beat";
        private static final /* synthetic */ ConnectedHeader[] $VALUES;

        public static ConnectedHeader[] values() {
            return (ConnectedHeader[])$VALUES.clone();
        }

        public static ConnectedHeader valueOf(String name) {
            return Enum.valueOf(ConnectedHeader.class, name);
        }

        private static /* synthetic */ ConnectedHeader[] $values() {
            return new ConnectedHeader[0];
        }

        static {
            $VALUES = ConnectedHeader.$values();
        }
    }

    public static final class ErrorHeader
    extends Enum<ErrorHeader> {
        public static final String MESSAGE = "message";
        public static final String CONTENT_LENGTH = "content-length";
        public static final String CONTENT_TYPE = "content-type";
        public static final String RECEIPTID = "receipt-id";
        private static final /* synthetic */ ErrorHeader[] $VALUES;

        public static ErrorHeader[] values() {
            return (ErrorHeader[])$VALUES.clone();
        }

        public static ErrorHeader valueOf(String name) {
            return Enum.valueOf(ErrorHeader.class, name);
        }

        private static /* synthetic */ ErrorHeader[] $values() {
            return new ErrorHeader[0];
        }

        static {
            $VALUES = ErrorHeader.$values();
        }
    }

    public static final class UnsubscribeHeader
    extends Enum<UnsubscribeHeader> {
        public static final String DESTINATION = "destination";
        public static final String ID = "id";
        private static final /* synthetic */ UnsubscribeHeader[] $VALUES;

        public static UnsubscribeHeader[] values() {
            return (UnsubscribeHeader[])$VALUES.clone();
        }

        public static UnsubscribeHeader valueOf(String name) {
            return Enum.valueOf(UnsubscribeHeader.class, name);
        }

        private static /* synthetic */ UnsubscribeHeader[] $values() {
            return new UnsubscribeHeader[0];
        }

        static {
            $VALUES = UnsubscribeHeader.$values();
        }
    }

    public static final class AckMode
    extends Enum<AckMode> {
        public static final String AUTO = "auto";
        public static final String CLIENT = "client";
        public static final String CLIENT_INDIVIDUAL = "client-individual";
        private static final /* synthetic */ AckMode[] $VALUES;

        public static AckMode[] values() {
            return (AckMode[])$VALUES.clone();
        }

        public static AckMode valueOf(String name) {
            return Enum.valueOf(AckMode.class, name);
        }

        private static /* synthetic */ AckMode[] $values() {
            return new AckMode[0];
        }

        static {
            $VALUES = AckMode.$values();
        }
    }

    public static final class SubscribeHeader
    extends Enum<SubscribeHeader> {
        public static final String DESTINATION = "destination";
        public static final String SELECTOR = "selector";
        public static final String ACK = "ack";
        public static final String ID = "id";
        public static final String DURASUBNAME = "durable-subscriber-name";
        public static final String NOLOCAL = "no-local";
        private static final /* synthetic */ SubscribeHeader[] $VALUES;

        public static SubscribeHeader[] values() {
            return (SubscribeHeader[])$VALUES.clone();
        }

        public static SubscribeHeader valueOf(String name) {
            return Enum.valueOf(SubscribeHeader.class, name);
        }

        private static /* synthetic */ SubscribeHeader[] $values() {
            return new SubscribeHeader[0];
        }

        static {
            $VALUES = SubscribeHeader.$values();
        }
    }

    public static final class MessageHeader
    extends Enum<MessageHeader> {
        public static final String DESTINATION = "destination";
        public static final String MESSAGEID = "message-id";
        public static final String TIMESTAMP = "timestamp";
        public static final String EXPIRES = "expires";
        public static final String PRORITY = "priority";
        public static final String REDELIVERED = "redelivered";
        public static final String TYPE = "type";
        public static final String REPLYTO = "reply-to";
        public static final String CORRELATIONID = "correlation-id";
        public static final String SUBSCRIPTION = "subscription";
        public static final String ACK = "ack";
        private static final /* synthetic */ MessageHeader[] $VALUES;

        public static MessageHeader[] values() {
            return (MessageHeader[])$VALUES.clone();
        }

        public static MessageHeader valueOf(String name) {
            return Enum.valueOf(MessageHeader.class, name);
        }

        private static /* synthetic */ MessageHeader[] $values() {
            return new MessageHeader[0];
        }

        static {
            $VALUES = MessageHeader.$values();
        }
    }

    public static final class ResponseCommonHeader
    extends Enum<ResponseCommonHeader> {
        public static final String RECEIPTID = "receipt-id";
        private static final /* synthetic */ ResponseCommonHeader[] $VALUES;

        public static ResponseCommonHeader[] values() {
            return (ResponseCommonHeader[])$VALUES.clone();
        }

        public static ResponseCommonHeader valueOf(String name) {
            return Enum.valueOf(ResponseCommonHeader.class, name);
        }

        private static /* synthetic */ ResponseCommonHeader[] $values() {
            return new ResponseCommonHeader[0];
        }

        static {
            $VALUES = ResponseCommonHeader.$values();
        }
    }
}

