/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.internal.p2.metadata.index.CapabilityIndex;
import org.eclipse.equinox.internal.p2.metadata.index.IdIndex;
import org.eclipse.equinox.internal.p2.metadata.index.IndexProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.KeyWithLocale;
import org.eclipse.equinox.p2.metadata.index.IIndex;
import org.eclipse.equinox.p2.query.IQueryable;

public class QueryableArray
extends IndexProvider<IInstallableUnit> {
    private final List<IInstallableUnit> dataSet;
    private IIndex<IInstallableUnit> capabilityIndex;
    private IIndex<IInstallableUnit> idIndex;
    private TranslationSupport translationSupport;

    public QueryableArray(IInstallableUnit[] ius) {
        this.dataSet = CollectionUtils.unmodifiableList((Object[])ius);
    }

    public QueryableArray(Collection<IInstallableUnit> ius) {
        this.dataSet = List.copyOf(ius);
    }

    public Iterator<IInstallableUnit> everything() {
        return this.dataSet.iterator();
    }

    public boolean contains(IInstallableUnit element) {
        return this.dataSet.contains(element);
    }

    public synchronized IIndex<IInstallableUnit> getIndex(String memberName) {
        if ("providedCapabilities".equals(memberName)) {
            if (this.capabilityIndex == null) {
                this.capabilityIndex = new CapabilityIndex(this.dataSet.iterator());
            }
            return this.capabilityIndex;
        }
        if ("id".equals(memberName)) {
            if (this.idIndex == null) {
                this.idIndex = new IdIndex(this.dataSet.iterator());
            }
            return this.idIndex;
        }
        return null;
    }

    public synchronized Object getManagedProperty(Object client, String memberName, Object key) {
        if (!(client instanceof IInstallableUnit)) {
            return null;
        }
        IInstallableUnit iInstallableUnit = (IInstallableUnit)client;
        if ("translatedProperties".equals(memberName)) {
            String string;
            if (this.translationSupport == null) {
                this.translationSupport = new TranslationSupport((IQueryable)this);
            }
            if (key instanceof KeyWithLocale) {
                KeyWithLocale k = (KeyWithLocale)key;
                string = this.translationSupport.getIUProperty((IInstallableUnit)iu, k);
            } else {
                string = this.translationSupport.getIUProperty((IInstallableUnit)iu, key.toString());
            }
            return string;
        }
        return null;
    }
}

