/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Files;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPSignatureVerifier;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.CollectEvent;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitPropertyOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.PropertyOperand;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.p2.engine.phases.CertificateChecker;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.director.PlanExecutionHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.ArtifactDescriptorQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.oomph.p2.P2Exception;
import org.eclipse.oomph.p2.ProfileDefinition;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.core.CachingRepositoryManager;
import org.eclipse.oomph.p2.internal.core.Messages;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.p2.internal.core.ProfileImpl;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.WorkerPool;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class ProfileTransactionImpl
implements ProfileTransaction {
    public static final String PROP_ADDITIONAL_POOLS = "oomph.p2.additional.pools";
    public static final String ARTIFICIAL_ROOT_ID = "artificial_root";
    public static final String EXCLUDE_IU_PROPERTY = "oomph.exclude";
    public static final String SOURCE_IU_ID = "org.eclipse.oomph.p2.source.container";
    private static final String OSGI_RESOLVER_USES_MODE = "osgi.resolver.usesMode";
    private static final IRequirement BUNDLE_REQUIREMENT = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", null, null, (boolean)false, (boolean)false, (boolean)false);
    private static final Set<String> IMMUTABLE_PROPERTIES = new HashSet<String>(Arrays.asList("org.eclipse.update.install.features", "org.eclipse.equinox.p2.installFolder", "org.eclipse.equinox.p2.cache", "org.eclipse.oomph.p2.profile.type", "org.eclipse.oomph.p2.profile.definition"));
    private final Profile profile;
    private final ProfileDefinition profileDefinition;
    private final ProfileDefinition cleanProfileDefinition;
    private final Map<String, String> profileProperties = new HashMap<String, String>();
    private final Map<String, String> cleanProfileProperties = new HashMap<String, String>();
    private final Map<IUPropertyKey, String> iuProperties = new HashMap<IUPropertyKey, String>();
    private final Map<IUPropertyKey, String> cleanIUProperties = new HashMap<IUPropertyKey, String>();
    private boolean removeAll;
    private boolean mirrors;
    private boolean committed;

    public ProfileTransactionImpl(Profile profile) {
        this.profile = profile;
        this.cleanProfileDefinition = profile.getDefinition();
        this.profileDefinition = (ProfileDefinition)EcoreUtil.copy((EObject)this.cleanProfileDefinition);
        this.cleanProfileProperties.putAll(profile.getProperties());
        this.cleanProfileProperties.remove("org.eclipse.equinox.p2.installFolder");
        this.cleanProfileProperties.remove("org.eclipse.equinox.p2.cache");
        this.cleanProfileProperties.remove("org.eclipse.oomph.p2.profile.definition");
        this.profileProperties.putAll(this.cleanProfileProperties);
        for (IInstallableUnit iu : P2Util.asIterable(profile.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()))) {
            Map properties = profile.getInstallableUnitProperties(iu);
            if (properties.isEmpty()) continue;
            for (Map.Entry property : properties.entrySet()) {
                String key = (String)property.getKey();
                String value = (String)property.getValue();
                this.cleanIUProperties.put(new IUPropertyKey(iu, key), value);
            }
        }
        this.iuProperties.putAll(this.cleanIUProperties);
        this.mirrors = ProfileTransactionImpl.isMirrorsEnabled();
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public ProfileDefinition getProfileDefinition() {
        return this.profileDefinition;
    }

    @Override
    public String getProfileProperty(String key) {
        return this.profileProperties.get(key);
    }

    @Override
    public ProfileTransaction setProfileProperty(String key, String value) {
        if (IMMUTABLE_PROPERTIES.contains(key) && !ObjectUtil.equals((Object)this.profileProperties.get(key), (Object)value)) {
            throw new IllegalArgumentException(NLS.bind((String)"Property is immutable: {0}", (Object)key));
        }
        if (value != null) {
            this.profileProperties.put(key, value);
        } else {
            this.profileProperties.remove(key);
        }
        return this;
    }

    @Override
    public ProfileTransaction removeProfileProperty(String key) {
        return this.setProfileProperty(key, null);
    }

    @Override
    public String getInstallableUnitProperty(IInstallableUnit iu, String key) {
        return this.iuProperties.get(new IUPropertyKey(iu, key));
    }

    @Override
    public ProfileTransaction setInstallableUnitProperty(IInstallableUnit iu, String key, String value) {
        IUPropertyKey propertyKey = new IUPropertyKey(iu, key);
        if (value != null) {
            this.iuProperties.put(propertyKey, value);
        } else {
            this.iuProperties.remove(propertyKey);
        }
        return this;
    }

    @Override
    public ProfileTransaction removeInstallableUnitProperty(IInstallableUnit iu, String key) {
        return this.setInstallableUnitProperty(iu, key, null);
    }

    @Override
    public boolean isRemoveExistingInstallableUnits() {
        return this.removeAll;
    }

    @Override
    public ProfileTransaction setRemoveExistingInstallableUnits(boolean removeAll) {
        this.removeAll = removeAll;
        return this;
    }

    @Override
    public boolean isMirrors() {
        return this.mirrors;
    }

    @Override
    public ProfileTransaction setMirrors(boolean mirrors) {
        this.mirrors = mirrors;
        return this;
    }

    @Override
    public boolean isDirty() {
        if (this.removeAll || !this.profileProperties.equals(this.cleanProfileProperties) || !this.iuProperties.equals(this.cleanIUProperties)) {
            return true;
        }
        return this.isProfileDefinitionChanged();
    }

    private boolean isProfileDefinitionChanged() {
        if (this.profileDefinition.isIncludeSourceBundles() != this.cleanProfileDefinition.isIncludeSourceBundles()) {
            return true;
        }
        EcoreUtil.EqualityHelper equalityHelper = new EcoreUtil.EqualityHelper();
        return !ProfileTransactionImpl.equals(equalityHelper, this.profileDefinition.getRequirements(), this.cleanProfileDefinition.getRequirements()) || !ProfileTransactionImpl.equals(equalityHelper, this.profileDefinition.getRepositories(), this.cleanProfileDefinition.getRepositories());
    }

    @Override
    public boolean commit() throws CoreException {
        return this.commit(null, null);
    }

    @Override
    public boolean commit(IProgressMonitor monitor) throws CoreException {
        return this.commit(null, monitor);
    }

    @Override
    public boolean commit(ProfileTransaction.CommitContext commitContext, IProgressMonitor monitor) throws CoreException {
        if (!this.committed) {
            this.committed = true;
            monitor.beginTask("", 2);
            try {
                ProfileTransaction.Resolution resolution = this.resolve(commitContext, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                if (resolution != null) {
                    boolean bl = resolution.commit((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                    return bl;
                }
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }
        return false;
    }

    @Override
    public ProfileTransaction.Resolution resolve(IProgressMonitor monitor) throws CoreException {
        return this.resolve(null, monitor);
    }

    @Override
    public ProfileTransaction.Resolution resolve(ProfileTransaction.CommitContext commitContext, IProgressMonitor monitor) throws CoreException {
        ProfileTransaction.CommitContext context;
        ProfileTransaction.CommitContext commitContext2 = context = commitContext == null ? new ProfileTransaction.CommitContext() : commitContext;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final Agent agent = this.profile.getAgent();
        final ArrayList<Runnable> cleanup = new ArrayList<Runnable>();
        boolean includeSourceBundles = this.profileDefinition.isIncludeSourceBundles();
        monitor.beginTask("", includeSourceBundles ? 75 : 70);
        try {
            this.initMirrors(cleanup);
            final ArrayList<IMetadataRepository> metadataRepositories = new ArrayList<IMetadataRepository>();
            final HashSet<java.net.URI> artifactURIs = new HashSet<java.net.URI>();
            java.net.URI[] metadataURIs = this.collectRepositories(metadataRepositories, artifactURIs, cleanup, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)50));
            final ProfileImpl profileImpl = (ProfileImpl)this.profile;
            final IProfile delegate = profileImpl.getDelegate();
            final long timestamp = delegate.getTimestamp();
            IPlanner planner = agent.getPlanner();
            boolean isTarglet = "Targlet".equals(this.profile.getType());
            ProfileChangeRequest profileChangeRequest = isTarglet ? new ProfileChangeRequest(delegate){

                public Collection<IInstallableUnit> getRemovals() {
                    StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                    if ("getSolutionFor".equals(stackTrace[2].getMethodName())) {
                        return Collections.emptyList();
                    }
                    return super.getRemovals();
                }
            } : planner.createChangeRequest(delegate);
            final IInstallableUnit rootIU = this.adjustProfileChangeRequest((IProfileChangeRequest)profileChangeRequest, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)5));
            final ProvisioningContext provisioningContext = context.createProvisioningContext(this, (IProfileChangeRequest)profileChangeRequest);
            provisioningContext.setMetadataRepositories(metadataURIs);
            provisioningContext.setArtifactRepositories(artifactURIs.toArray(new java.net.URI[artifactURIs.size()]));
            if (isTarglet) {
                provisioningContext.setProperty("org.eclipse.equinox.p2.internal.profileius", Boolean.FALSE.toString());
            }
            IQueryable metadata = provisioningContext.getMetadata((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)5));
            final IProvisioningPlan provisioningPlan = planner.getProvisioningPlan((IProfileChangeRequest)profileChangeRequest, provisioningContext, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)10));
            P2CorePlugin.INSTANCE.coreException(provisioningPlan.getStatus());
            IQueryable futureState = provisioningPlan.getFutureState();
            for (IRequirement requirement : rootIU.getRequirements()) {
                if (!P2Util.isSimpleRequiredCapability(requirement)) continue;
                IRequiredCapability requiredCapability = (IRequiredCapability)requirement;
                for (IInstallableUnit installableUnit : P2Util.asIterable(futureState.query(QueryUtil.createIUQuery((String)requiredCapability.getName(), (VersionRange)requiredCapability.getRange()), null))) {
                    provisioningPlan.setInstallableUnitProfileProperty(installableUnit, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
                    provisioningPlan.setInstallableUnitProfileProperty(installableUnit, "org.eclipse.equinox.p2.internal.inclusion.rules", ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)installableUnit));
                }
            }
            if (includeSourceBundles) {
                IInstallableUnit sourceContainerIU = ProfileTransactionImpl.generateSourceContainerIU(provisioningPlan, (IQueryable<IInstallableUnit>)metadata, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)5));
                provisioningPlan.addInstallableUnit(sourceContainerIU);
                provisioningPlan.setInstallableUnitProfileProperty(sourceContainerIU, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
            }
            final HashMap<IInstallableUnit, ProfileTransaction.CommitContext.DeltaType> iuDeltas = new HashMap<IInstallableUnit, ProfileTransaction.CommitContext.DeltaType>();
            final HashMap<IInstallableUnit, Map<String, Pair<Object, Object>>> propertyDeltas = new HashMap<IInstallableUnit, Map<String, Pair<Object, Object>>>();
            this.computeOperandDeltas(provisioningPlan, iuDeltas, propertyDeltas);
            ProfileTransaction.CommitContext.ResolutionInfo resolutionInfo = new ProfileTransaction.CommitContext.ResolutionInfo(){

                @Override
                public IProvisioningPlan getProvisioningPlan() {
                    return provisioningPlan;
                }

                @Override
                public IInstallableUnit getArtificialRoot() {
                    return rootIU;
                }

                @Override
                public Map<IInstallableUnit, ProfileTransaction.CommitContext.DeltaType> getIUDeltas() {
                    return iuDeltas;
                }

                @Override
                public Map<IInstallableUnit, Map<String, Pair<Object, Object>>> getPropertyDeltas() {
                    return propertyDeltas;
                }

                @Override
                public List<IMetadataRepository> getMetadataRepositories() {
                    return metadataRepositories;
                }
            };
            if (!context.handleProvisioningPlan(resolutionInfo) || iuDeltas.isEmpty() && propertyDeltas.isEmpty()) {
                return null;
            }
            ProfileTransaction.Resolution resolution = new ProfileTransaction.Resolution(){
                private final ProvisioningListener provisioningListener = new ProvisioningListener();

                @Override
                public ProfileTransaction getProfileTransaction() {
                    return ProfileTransactionImpl.this;
                }

                @Override
                public IProvisioningPlan getProvisioningPlan() {
                    return provisioningPlan;
                }

                @Override
                public boolean commit(IProgressMonitor monitor) throws CoreException {
                    final String oldUsesMode = System.setProperty(ProfileTransactionImpl.OSGI_RESOLVER_USES_MODE, "ignore");
                    cleanup.add(new Runnable(){

                        @Override
                        public void run() {
                            if (oldUsesMode == null) {
                                System.clearProperty(ProfileTransactionImpl.OSGI_RESOLVER_USES_MODE);
                            } else {
                                System.setProperty(ProfileTransactionImpl.OSGI_RESOLVER_USES_MODE, oldUsesMode);
                            }
                        }
                    });
                    IProvisioningEventBus eventBus = CachingRepositoryManager.isBetterMirrorSelection() ? (IProvisioningEventBus)agent.getProvisioningAgent().getService("org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus") : null;
                    try {
                        if (eventBus != null) {
                            this.provisioningListener.setMonitor((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                            eventBus.addListener((org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener)this.provisioningListener);
                        }
                        IPhaseSet phaseSet = context.getPhaseSet(ProfileTransactionImpl.this);
                        ProfileTransactionImpl.this.init(context, agent, cleanup);
                        IEngine engine = agent.getEngine();
                        ProfileTransactionImpl.this.ensureSameBackupDevice(provisioningPlan);
                        if (Arrays.asList(phaseSet.getPhaseIds()).contains("checkTrust")) {
                            ProfileTransactionImpl.this.checkMissingPGPSignatures(agent, artifactURIs, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                        }
                        IStatus status = PlanExecutionHelper.executePlan((IProvisioningPlan)provisioningPlan, (IEngine)engine, (IPhaseSet)phaseSet, (ProvisioningContext)provisioningContext, (IProgressMonitor)new ExecutePlanMonitor(monitor, provisioningPlan));
                        context.handleExecutionResult(status);
                        P2CorePlugin.INSTANCE.coreException(status);
                        profileImpl.setDefinition(ProfileTransactionImpl.this.profileDefinition);
                        boolean bl = delegate.getTimestamp() != timestamp;
                        return bl;
                    }
                    finally {
                        if (eventBus != null) {
                            eventBus.removeListener((org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener)this.provisioningListener);
                        }
                        ProfileTransactionImpl.cleanup(cleanup);
                    }
                }

                @Override
                public void rollback() {
                    ProfileTransactionImpl.cleanup(cleanup);
                }
            };
            return resolution;
        }
        catch (Throwable t) {
            ProfileTransactionImpl.cleanup(cleanup);
            P2CorePlugin.INSTANCE.coreException(t);
            return null;
        }
        finally {
            monitor.done();
        }
    }

    private void checkMissingPGPSignatures(Agent agent, Set<java.net.URI> artifactURIs, IProgressMonitor monitor) {
        IProvisioningAgent provisioningAgent = agent.getProvisioningAgent();
        IArtifactRepositoryManager artifactRepositoryManager = agent.getArtifactRepositoryManager();
        BundlePool bundlePool = this.profile.getBundlePool();
        if (bundlePool == null) {
            return;
        }
        java.net.URI bundlePoolLocation = bundlePool.getLocation().toURI();
        LinkedHashSet<java.net.URI> uris = new LinkedHashSet<java.net.URI>();
        uris.add(bundlePoolLocation);
        uris.addAll(artifactURIs);
        RepositoryLoader repositoryLoader = new RepositoryLoader(artifactRepositoryManager, uris.toArray(new java.net.URI[uris.size()]));
        repositoryLoader.begin(monitor);
        ProvisionException exception = repositoryLoader.getException();
        if (exception != null) {
            return;
        }
        if (repositoryLoader.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            ArrayList<IQueryable> repositories = new ArrayList<IQueryable>();
            for (java.net.URI uri : uris) {
                repositories.add(artifactRepositoryManager.loadRepository(uri, monitor).descriptorQueryable());
            }
            LinkedHashMap<IArtifactKey, IArtifactDescriptor> pgpArtifacts = new LinkedHashMap<IArtifactKey, IArtifactDescriptor>();
            for (IArtifactDescriptor descriptor : QueryUtil.compoundQueryable(repositories).query((IQuery)ArtifactDescriptorQuery.ALL_DESCRIPTORS, monitor)) {
                if (descriptor.getProperty("pgp.signatures") == null) continue;
                pgpArtifacts.put(descriptor.getArtifactKey(), descriptor);
            }
            IFileArtifactRepository artifactRepository = (IFileArtifactRepository)artifactRepositoryManager.loadRepository(bundlePoolLocation, monitor);
            ArrayList<Runnable> runnables = new ArrayList<Runnable>();
            for (IArtifactDescriptor descriptor : artifactRepository.descriptorQueryable().query((IQuery)ArtifactDescriptorQuery.ALL_DESCRIPTORS, monitor)) {
                File artifactFile;
                IArtifactDescriptor other;
                if (descriptor.getProperty("pgp.signatures") != null || (other = (IArtifactDescriptor)pgpArtifacts.get(descriptor.getArtifactKey())) == null || (artifactFile = artifactRepository.getArtifactFile(descriptor)) == null || !artifactFile.isFile()) continue;
                runnables.add(() -> {
                    try {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try (PGPSignatureVerifier pgpSignatureVerifier = new PGPSignatureVerifier();){
                            class NullOutputStream
                            extends OutputStream
                            implements IAdaptable {
                                private final /* synthetic */ IArtifactDescriptor val$descriptor;

                                NullOutputStream(IArtifactDescriptor iArtifactDescriptor) {
                                    this.val$descriptor = iArtifactDescriptor;
                                }

                                public <T> T getAdapter(Class<T> adapter) {
                                    if (adapter == ArtifactDescriptor.class) {
                                        return adapter.cast(this.val$descriptor);
                                    }
                                    return null;
                                }

                                @Override
                                public void write(int b) throws IOException {
                                }

                                @Override
                                public void write(byte[] b, int off, int len) throws IOException {
                                }
                            }
                            pgpSignatureVerifier.link((OutputStream)new NullOutputStream(descriptor), monitor);
                            pgpSignatureVerifier.initialize(provisioningAgent, null, other);
                            Files.copy(artifactFile.toPath(), (OutputStream)pgpSignatureVerifier);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException ex) {
                        P2CorePlugin.INSTANCE.log(ex);
                    }
                    String property = descriptor.getProperty("pgp.signatures");
                    if (property != null) {
                        monitor.subTask(NLS.bind((String)Messages.ProfileTransactionImpl_AddPGPSignature, (Object)artifactFile));
                    }
                });
            }
            if (!runnables.isEmpty()) {
                artifactRepository.executeBatch(m -> runnables.parallelStream().forEach(Runnable::run), monitor);
            }
        }
        catch (ProvisionException ex) {
            P2CorePlugin.INSTANCE.log(ex);
        }
    }

    private void computeOperandDeltas(IProvisioningPlan provisioningPlan, Map<IInstallableUnit, ProfileTransaction.CommitContext.DeltaType> iuDeltas, Map<IInstallableUnit, Map<String, Pair<Object, Object>>> propertyDeltas) {
        Field operandsField = ReflectUtil.getField(ProvisioningPlan.class, (String)"operands");
        List operands = (List)ReflectUtil.getValue((Field)operandsField, (Object)provisioningPlan);
        Iterator<Object> it = operands.iterator();
        while (it.hasNext()) {
            Object second;
            Object first;
            Operand operand = (Operand)it.next();
            if (operand instanceof InstallableUnitOperand) {
                InstallableUnitOperand iuOperand = (InstallableUnitOperand)operand;
                first = iuOperand.first();
                second = iuOperand.second();
                if (first == null) {
                    if (second.getId().equals(ARTIFICIAL_ROOT_ID) || "true".equals(second.getProperty(EXCLUDE_IU_PROPERTY))) {
                        it.remove();
                        continue;
                    }
                    iuDeltas.put((IInstallableUnit)second, ProfileTransaction.CommitContext.DeltaType.ADDITION);
                    continue;
                }
                if (first.equals(second)) continue;
                iuDeltas.put((IInstallableUnit)first, ProfileTransaction.CommitContext.DeltaType.REMOVAL);
                if (second == null) continue;
                iuDeltas.put((IInstallableUnit)second, ProfileTransaction.CommitContext.DeltaType.ADDITION);
                continue;
            }
            if (operand instanceof InstallableUnitPropertyOperand) {
                InstallableUnitPropertyOperand iuPropertyOperand = (InstallableUnitPropertyOperand)operand;
                IInstallableUnit operandIU = iuPropertyOperand.getInstallableUnit();
                if (operandIU.getId().equals(ARTIFICIAL_ROOT_ID)) {
                    it.remove();
                    continue;
                }
                Object first2 = iuPropertyOperand.first();
                Object second2 = iuPropertyOperand.second();
                String key = iuPropertyOperand.getKey();
                this.populatePropertyDeltas(operandIU, first2, second2, key, propertyDeltas);
                continue;
            }
            if (!(operand instanceof PropertyOperand)) continue;
            PropertyOperand propertyOperand = (PropertyOperand)operand;
            first = propertyOperand.first();
            second = propertyOperand.second();
            String key = propertyOperand.getKey();
            this.populatePropertyDeltas(null, first, second, key, propertyDeltas);
        }
        it = propertyDeltas.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Set properties = ((Map)entry.getValue()).entrySet();
            Iterator it2 = properties.iterator();
            while (it2.hasNext()) {
                Map.Entry property = it2.next();
                Pair pair = (Pair)property.getValue();
                if (!ObjectUtil.equals((Object)pair.getElement1(), (Object)pair.getElement2())) continue;
                it2.remove();
            }
            if (!properties.isEmpty()) continue;
            it.remove();
        }
    }

    private void populatePropertyDeltas(IInstallableUnit operandIU, Object first, Object second, String key, Map<IInstallableUnit, Map<String, Pair<Object, Object>>> propertyDeltas) {
        Map<String, Pair<Object, Object>> propertyDelta = propertyDeltas.get(operandIU);
        if (propertyDelta == null) {
            propertyDelta = new HashMap<String, Pair<Object, Object>>();
            propertyDelta.put(key, (Pair<Object, Object>)new Pair(first, second));
            propertyDeltas.put(operandIU, propertyDelta);
        } else {
            Pair<Object, Object> pair = propertyDelta.get(key);
            if (pair == null) {
                propertyDelta.put(key, (Pair<Object, Object>)new Pair(first, second));
            } else {
                pair.setElement2(second);
            }
        }
    }

    private static boolean isMirrorsEnabled() {
        return !"false".equals(Activator.getContext().getProperty("eclipse.p2.mirrors"));
    }

    private void initMirrors(List<Runnable> cleanup) {
        final boolean wasMirrors = ProfileTransactionImpl.isMirrorsEnabled();
        if (this.mirrors != wasMirrors) {
            try {
                final Field mirrorsEnabledField = ReflectUtil.getField(SimpleArtifactRepository.class, (String)"MIRRORS_ENABLED");
                ReflectUtil.setValue((Field)mirrorsEnabledField, null, (Object)this.mirrors, (boolean)true);
                cleanup.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ReflectUtil.setValue((Field)mirrorsEnabledField, null, (Object)wasMirrors, (boolean)true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Throwable ex) {
                System.setProperty("eclipse.p2.mirrors", Boolean.toString(this.mirrors));
                cleanup.add(new Runnable(){

                    @Override
                    public void run() {
                        System.setProperty("eclipse.p2.mirrors", Boolean.toString(wasMirrors));
                    }
                });
            }
        }
    }

    private void init(ProfileTransaction.CommitContext context, Agent agent, List<Runnable> cleanup) {
        context.init();
        IProvisioningAgent provisioningAgent = agent.getProvisioningAgent();
        IProvisioningAgent selfAgent = P2Util.getCurrentProvisioningAgent();
        if (selfAgent != provisioningAgent) {
            PGPPublicKeyService provisioningAgentKeyService = (PGPPublicKeyService)provisioningAgent.getService(PGPPublicKeyService.class);
            PGPPublicKeyService selfAgentKeyService = (PGPPublicKeyService)selfAgent.getService(PGPPublicKeyService.class);
            if (provisioningAgentKeyService != null) {
                selfAgent.registerService(PGPPublicKeyService.SERVICE_NAME, (Object)provisioningAgentKeyService);
                CertificateChecker certificateChecker = new CertificateChecker(provisioningAgent);
                certificateChecker.setProfile((IProfile)this.profile);
                certificateChecker.getPreferenceTrustedKeys();
                cleanup.add(() -> {
                    if (selfAgentKeyService == null) {
                        selfAgent.unregisterService(PGPPublicKeyService.SERVICE_NAME, (Object)provisioningAgentKeyService);
                    } else {
                        selfAgent.registerService(PGPPublicKeyService.SERVICE_NAME, (Object)selfAgentKeyService);
                    }
                });
            }
        }
    }

    private java.net.URI[] collectRepositories(List<IMetadataRepository> metadataRepositories, Set<java.net.URI> artifactURIs, List<Runnable> cleanup, IProgressMonitor monitor) throws CoreException {
        boolean removeRepositories;
        Agent agent = this.profile.getAgent();
        boolean bl = removeRepositories = !"false".equals(PropertiesUtil.getProperty((String)"oomph.p2.flush"));
        if (removeRepositories) {
            agent.flushCachedRepositories();
        }
        final IMetadataRepositoryManager metadataRepositoryManager = agent.getMetadataRepositoryManager();
        Set<String> knownRepositories = P2Util.getKnownRepositories(metadataRepositoryManager);
        EList repositories = this.profileDefinition.getRepositories();
        java.net.URI[] metadataURIs = new java.net.URI[repositories.size()];
        HashSet<java.net.URI> addedArtifactURIs = new HashSet<java.net.URI>();
        int i = 0;
        while (i < metadataURIs.length) {
            try {
                Repository repository = (Repository)repositories.get(i);
                String url = repository.getURL();
                final java.net.URI uri = new java.net.URI(url);
                if (removeRepositories && !knownRepositories.contains(url)) {
                    cleanup.add(new Runnable(){

                        @Override
                        public void run() {
                            metadataRepositoryManager.removeRepository(uri);
                        }
                    });
                }
                metadataURIs[i] = uri;
                if (addedArtifactURIs.add(uri)) {
                    artifactURIs.add(uri);
                }
            }
            catch (Exception ex) {
                throw new P2Exception((Throwable)ex);
            }
            ++i;
        }
        RepositoryLoader repositoryLoader = new RepositoryLoader(metadataRepositoryManager, metadataURIs);
        repositoryLoader.begin(monitor);
        ProvisionException exception = repositoryLoader.getException();
        if (exception != null) {
            throw exception;
        }
        if (repositoryLoader.isCanceled()) {
            throw new OperationCanceledException();
        }
        int i2 = 0;
        while (i2 < metadataURIs.length) {
            IMetadataRepository metadataRepository = metadataRepositoryManager.loadRepository(metadataURIs[i2], null);
            metadataRepositories.add(metadataRepository);
            ++i2;
        }
        if (!"false".equalsIgnoreCase(PropertiesUtil.getProperty((String)PROP_ADDITIONAL_POOLS))) {
            for (BundlePool bundlePool : agent.getAgentManager().getBundlePools()) {
                java.net.URI uri;
                P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
                if (bundlePool == this.profile.getBundlePool() || !addedArtifactURIs.add(uri = bundlePool.getLocation().toURI())) continue;
                artifactURIs.add(uri);
            }
        }
        return metadataURIs;
    }

    private IInstallableUnit adjustProfileChangeRequest(final IProfileChangeRequest request, IProgressMonitor monitor) throws CoreException {
        MetadataFactory.InstallableUnitDescription rootDescription = new MetadataFactory.InstallableUnitDescription();
        rootDescription.setId(ARTIFICIAL_ROOT_ID);
        rootDescription.setVersion(Version.createOSGi((int)1, (int)0, (int)0, (String)("v" + System.currentTimeMillis())));
        rootDescription.setSingleton(true);
        rootDescription.setArtifacts(new IArtifactKey[0]);
        rootDescription.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        rootDescription.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)rootDescription.getId(), (Version)rootDescription.getVersion())});
        ArrayList<IRequirement> rootRequirements = new ArrayList<IRequirement>();
        HashMap<String, IInstallableUnit> rootIUs = new HashMap<String, IInstallableUnit>();
        HashMap<Object, IRequirement> singletonRootRequirements = new HashMap<Object, IRequirement>();
        for (IInstallableUnit rootIU : P2Util.asIterable(this.profile.query((IQuery)new UserVisibleRootQuery(), null))) {
            if (!this.removeAll) {
                String id = rootIU.getId();
                rootIUs.put(id, rootIU);
                VersionRange versionRange = this.getCleanVersionRange(rootIU);
                IMatchExpression filter = rootIU.getFilter();
                boolean isPatch = "true".equals(rootIU.getProperty("org.eclipse.equinox.p2.type.patch"));
                IRequirement rootRequirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)versionRange, (IMatchExpression)filter, (boolean)isPatch, (boolean)false);
                rootRequirements.add(rootRequirement);
                if (rootIU.isSingleton() || "true".equals(rootIU.getProperty("org.eclipse.equinox.p2.type.group"))) {
                    singletonRootRequirements.put(id, rootRequirement);
                }
            }
            request.remove(rootIU);
        }
        MultiStatus status = new MultiStatus(P2CorePlugin.INSTANCE.getSymbolicName(), 0, Messages.ProfileTransactionImpl_CouldNotBeChanged_message, null);
        for (Requirement requirement : this.profileDefinition.getRequirements()) {
            String name;
            IRequirement singletonRootRequirement;
            P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
            IRequirement rootRequirement = requirement.toIRequirement();
            rootRequirements.add(rootRequirement);
            String namespace = requirement.getNamespace();
            if (!"org.eclipse.equinox.p2.iu".equals(namespace) || (singletonRootRequirement = (IRequirement)singletonRootRequirements.get(name = requirement.getName())) == null) continue;
            rootRequirements.remove(singletonRootRequirement);
        }
        rootDescription.setRequirements(rootRequirements.toArray(new IRequirement[rootRequirements.size()]));
        IInstallableUnit rootUnit = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)rootDescription);
        request.add(rootUnit);
        request.setInstallableUnitProfileProperty(rootUnit, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
        P2CorePlugin.INSTANCE.coreException((IStatus)status);
        if (this.isProfileDefinitionChanged()) {
            request.setProfileProperty("org.eclipse.oomph.p2.profile.definition", ProfileImpl.definitionToXML(this.profileDefinition));
        }
        LinkedHashMap<String, String> mergedProfileProperties = new LinkedHashMap<String, String>(this.profileProperties);
        mergedProfileProperties.putAll(P2Util.toProfilePropertiesMap(this.profileDefinition.getProfileProperties()));
        ProfileTransactionImpl.compare(this.cleanProfileProperties, mergedProfileProperties, new CompareHandler<String>(){

            @Override
            public void handleAddition(String key, String value) {
                if (!IMMUTABLE_PROPERTIES.contains(key)) {
                    request.setProfileProperty(key, value);
                }
            }

            @Override
            public void handleRemoval(String key) {
                if (!IMMUTABLE_PROPERTIES.contains(key)) {
                    request.removeProfileProperty(key);
                }
            }
        });
        ProfileTransactionImpl.compare(this.cleanIUProperties, this.iuProperties, new CompareHandler<IUPropertyKey>(){

            @Override
            public void handleAddition(IUPropertyKey key, String value) {
                request.setInstallableUnitProfileProperty(key.getInstallableUnit(), key.getPropertyKey(), value);
            }

            @Override
            public void handleRemoval(IUPropertyKey key) {
                request.removeInstallableUnitProfileProperty(key.getInstallableUnit(), key.getPropertyKey());
            }
        });
        return rootUnit;
    }

    private VersionRange getCleanVersionRange(IInstallableUnit rootIU) {
        String id = rootIU.getId();
        Version version = rootIU.getVersion();
        for (Requirement requirement : this.cleanProfileDefinition.getRequirements()) {
            VersionRange versionRange;
            if (!requirement.getName().equals(id) || (versionRange = requirement.getVersionRange()) != null && !versionRange.isIncluded(version)) continue;
            return versionRange;
        }
        return new VersionRange(version.toString());
    }

    private void ensureSameBackupDevice(IProvisioningPlan provisioningPlan) throws CoreException {
        if (this.profile.isCurrent() && "win32".equals(Platform.getOS())) {
            try {
                final Constructor backStoreConstructor = ReflectUtil.getConstructor((Class)CommonPlugin.loadClass((String)"org.eclipse.equinox.p2.touchpoint.natives", (String)"org.eclipse.equinox.internal.p2.touchpoint.natives.BackupStore"), (Class[])new Class[]{File.class, String.class});
                Location location = Platform.getInstallLocation();
                URI installationLocation = URI.createURI((String)FileLocator.resolve((URL)location.getURL()).toString());
                URI tempDir = URI.createFileURI((String)PropertiesUtil.getProperty((String)"java.io.tmpdir"));
                if (!ObjectUtil.equals((Object)installationLocation.device(), (Object)tempDir.device())) {
                    Field field = ReflectUtil.getField(NativeTouchpoint.class, (String)"backups");
                    Map backups = (Map)ReflectUtil.getValue((Field)field, null);
                    final File localTempFolder = new File(installationLocation.toFileString(), "backup");
                    final IProfile planProfile = provisioningPlan.getProfile();
                    backups.put(planProfile, new IBackupStore(){
                        private IBackupStore delegate;

                        public boolean backup(File file) throws IOException {
                            this.loadDelegate();
                            return this.delegate.backup(file);
                        }

                        public boolean backupDirectory(File file) throws IOException {
                            this.loadDelegate();
                            return this.delegate.backupDirectory(file);
                        }

                        public void discard() {
                            if (this.delegate == null) {
                                return;
                            }
                            this.delegate.discard();
                        }

                        public void restore() throws IOException {
                            if (this.delegate == null) {
                                return;
                            }
                            this.delegate.restore();
                        }

                        private void loadDelegate() {
                            if (this.delegate != null) {
                                return;
                            }
                            this.delegate = (IBackupStore)ReflectUtil.newInstance((Constructor)backStoreConstructor, (Object[])new Object[]{localTempFolder, NativeTouchpoint.escape((String)planProfile.getProfileId())});
                        }

                        public String getBackupName() {
                            this.loadDelegate();
                            return this.delegate.getBackupName();
                        }

                        public boolean backupCopy(File file) throws IOException {
                            this.loadDelegate();
                            return this.delegate.backupCopy(file);
                        }

                        public void backupCopyAll(File file) throws IOException {
                            this.loadDelegate();
                            this.delegate.backupCopyAll(file);
                        }

                        public void backupAll(File file) throws IOException {
                            this.loadDelegate();
                            this.delegate.backupAll(file);
                        }
                    });
                }
            }
            catch (IOException ex) {
                P2CorePlugin.INSTANCE.coreException(ex);
            }
            catch (ReflectUtil.ReflectionException reflectionException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private static void cleanup(List<Runnable> cleanup) {
        for (Runnable runnable : cleanup) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                P2CorePlugin.INSTANCE.log(t);
            }
        }
        cleanup.clear();
    }

    private static IInstallableUnit generateSourceContainerIU(IProvisioningPlan provisioningPlan, IQueryable<IInstallableUnit> metadata, IProgressMonitor monitor) {
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        IQueryResult ius = provisioningPlan.getFutureState().query(QueryUtil.createIUAnyQuery(), monitor);
        for (IInstallableUnit iu : P2Util.asIterable(ius)) {
            Version version;
            VersionRange versionRange;
            String id;
            IInstallableUnit sourceIU;
            P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
            if (!iu.satisfies(BUNDLE_REQUIREMENT) || (sourceIU = ProfileTransactionImpl.queryInstallableUnit(metadata, id = iu.getId() + ".source", versionRange = new VersionRange(version = iu.getVersion(), true, version, true), monitor)) == null) continue;
            provisioningPlan.addInstallableUnit(sourceIU);
            IRequirement sourceRequirement = MetadataFactory.createRequirement((String)"osgi.bundle", (String)id, (VersionRange)versionRange, null, (boolean)true, (boolean)false, (boolean)true);
            requirements.add(sourceRequirement);
        }
        Version sourceContainerIUVersion = ProfileTransactionImpl.getSourceContainerIUVersion(provisioningPlan.getProfile(), monitor);
        IProvidedCapability capability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)SOURCE_IU_ID, (Version)sourceContainerIUVersion);
        MetadataFactory.InstallableUnitDescription sourceIUDescription = new MetadataFactory.InstallableUnitDescription();
        sourceIUDescription.setSingleton(true);
        sourceIUDescription.setId(SOURCE_IU_ID);
        sourceIUDescription.setVersion(sourceContainerIUVersion);
        sourceIUDescription.addRequirements(requirements);
        sourceIUDescription.setCapabilities(new IProvidedCapability[]{capability});
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)sourceIUDescription);
    }

    private static Version getSourceContainerIUVersion(IProfile profile, IProgressMonitor monitor) {
        IQuery query = QueryUtil.createIUQuery((String)SOURCE_IU_ID);
        IQueryResult result = profile.query(query, monitor);
        if (result.isEmpty()) {
            return Version.createOSGi((int)1, (int)0, (int)0);
        }
        IInstallableUnit currentSourceIU = (IInstallableUnit)result.iterator().next();
        Integer major = (Integer)currentSourceIU.getVersion().getSegment(0);
        return Version.createOSGi((int)(major + 1), (int)0, (int)0);
    }

    private static IInstallableUnit queryInstallableUnit(IQueryable<IInstallableUnit> metadata, String id, VersionRange versionRange, IProgressMonitor monitor) {
        IQuery iuQuery = QueryUtil.createIUQuery((String)id, (VersionRange)versionRange);
        IQuery latestQuery = QueryUtil.createLatestQuery((IQuery)iuQuery);
        Iterator iterator = metadata.query(latestQuery, monitor).iterator();
        if (iterator.hasNext()) {
            return (IInstallableUnit)iterator.next();
        }
        return null;
    }

    private static <T extends EObject> boolean equals(EcoreUtil.EqualityHelper equalityHelper, Collection<T> c1, Collection<T> c2) {
        for (EObject o : c1) {
            if (ProfileTransactionImpl.contains(equalityHelper, c2, o)) continue;
            return false;
        }
        for (EObject o : c2) {
            if (ProfileTransactionImpl.contains(equalityHelper, c1, o)) continue;
            return false;
        }
        return true;
    }

    private static <T extends EObject> boolean contains(EcoreUtil.EqualityHelper equalityHelper, Collection<T> c, T object) {
        for (EObject o : c) {
            if (!equalityHelper.equals(object, o)) continue;
            return true;
        }
        return false;
    }

    private static <K> void compare(Map<K, String> clean, Map<K, String> dirty, CompareHandler<K> handler) {
        K key;
        for (Map.Entry<K, String> entry : dirty.entrySet()) {
            key = entry.getKey();
            String dirtyValue = entry.getValue();
            String cleanValue = clean.get(key);
            if (cleanValue != null && cleanValue.equals(dirtyValue)) continue;
            handler.handleAddition(key, dirtyValue);
        }
        for (Map.Entry<K, String> entry : clean.entrySet()) {
            key = entry.getKey();
            if (dirty.containsKey(key)) continue;
            handler.handleRemoval(key);
        }
    }

    public static interface CompareHandler<K> {
        public void handleAddition(K var1, String var2);

        public void handleRemoval(K var1);
    }

    private static final class ExecutePlanMonitor
    extends ProgressMonitorWrapper {
        private static final String INSTALLING_PREFIX = Messages.ProfileTransactionImpl_Installing_task + " ";
        private final Map<String, LinkedList<Version>> versions = new HashMap<String, LinkedList<Version>>();
        private final IQueryable<IInstallableUnit> additions;

        private ExecutePlanMonitor(IProgressMonitor monitor, IProvisioningPlan provisioningPlan) {
            super(monitor);
            this.additions = provisioningPlan.getAdditions();
        }

        public void subTask(String name) {
            String id;
            Version version;
            if (((String)name).startsWith(INSTALLING_PREFIX) && (version = this.getVersion(id = ((String)name).substring(INSTALLING_PREFIX.length()))) != null) {
                name = (String)name + " [" + String.valueOf(version) + "]";
            }
            super.subTask((String)name);
        }

        private Version getVersion(String id) {
            LinkedList<Object> list = this.versions.get(id);
            if (list != null) {
                if (list.isEmpty()) {
                    return null;
                }
                return list.remove(0);
            }
            Version firstVersion = null;
            IQueryResult ius = this.additions.query(QueryUtil.createIUQuery((String)id), null);
            if (!ius.isEmpty()) {
                for (IInstallableUnit iu : P2Util.asIterable(ius)) {
                    if (firstVersion == null) {
                        firstVersion = iu.getVersion();
                        continue;
                    }
                    if (list == null) {
                        list = new LinkedList();
                        this.versions.put(id, list);
                    }
                    list.add(iu.getVersion());
                }
            }
            return firstVersion;
        }
    }

    private static final class IUPropertyKey {
        private static final int PRIME = 31;
        private final IInstallableUnit iu;
        private final String propertyKey;
        private final int hashCode;

        public IUPropertyKey(IInstallableUnit iu, String propertyKey) {
            this.iu = iu;
            this.propertyKey = propertyKey;
            this.hashCode = 31 * (31 + iu.hashCode()) + propertyKey.hashCode();
        }

        public IInstallableUnit getInstallableUnit() {
            return this.iu;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            IUPropertyKey other = (IUPropertyKey)obj;
            return this.iu.equals((Object)other.iu) && this.propertyKey.equals(other.propertyKey);
        }

        public String toString() {
            return this.iu.toString() + " / " + this.propertyKey;
        }
    }

    private static final class ProvisioningListener
    implements SynchronousProvisioningListener {
        private long startTime;
        private IProgressMonitor monitor;

        private ProvisioningListener() {
        }

        public void setMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void notify(EventObject event) {
            if (event instanceof CollectEvent) {
                CollectEvent collectEvent = (CollectEvent)event;
                final IArtifactRepository repository = collectEvent.getRepository();
                IArtifactRequest[] requests = collectEvent.getDownloadRequests();
                if (requests != null && requests.length > 0) {
                    if (collectEvent.getType() == 3) {
                        this.startTime = System.currentTimeMillis();
                        if (repository != null) {
                            this.monitor.subTask(NLS.bind((String)Messages.ProfileTransactionImpl_CollectingArtifacts_task, (Object)requests.length, (Object)repository.getLocation()));
                            if (!repository.isModifiable()) {
                                Arrays.sort(requests, new Comparator<IArtifactRequest>(){

                                    @Override
                                    public int compare(IArtifactRequest o1, IArtifactRequest o2) {
                                        int size1 = this.getDownloadSize(o1);
                                        int size2 = this.getDownloadSize(o2);
                                        return size1 - size2;
                                    }

                                    private int getDownloadSize(IArtifactRequest request) {
                                        IArtifactDescriptor artifactDescriptor;
                                        String property;
                                        IArtifactKey artifactKey = request.getArtifactKey();
                                        IArtifactDescriptor[] artifactDescriptors = repository.getArtifactDescriptors(artifactKey);
                                        if (artifactDescriptors != null && artifactDescriptors.length != 0 && (property = (artifactDescriptor = artifactDescriptors[0]).getProperty("download.size")) != null) {
                                            long size;
                                            block4: {
                                                size = Long.parseLong(property);
                                                if (size <= Integer.MAX_VALUE) break block4;
                                                return Integer.MAX_VALUE;
                                            }
                                            try {
                                                return (int)size;
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                // empty catch block
                                            }
                                        }
                                        return Integer.MAX_VALUE;
                                    }
                                });
                                int length = requests.length;
                                if (length >= 4) {
                                    List<IArtifactRequest> list = Arrays.asList(requests);
                                    List<IArtifactRequest> subList = list.subList(length / 2, length);
                                    Collections.reverse(subList);
                                }
                            }
                        }
                    } else if (collectEvent.getType() == 4 && repository != null) {
                        this.processStats(repository);
                        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
                        this.monitor.subTask(NLS.bind((String)Messages.ProfileTransactionImpl_CollectingArtifactsFor_task, (Object[])new Object[]{requests.length, repository.getLocation(), numberFormat.format((double)(System.currentTimeMillis() - this.startTime) / 1000.0)}));
                    }
                }
            }
        }

        private void processStats(IArtifactRepository repository) {
            block4: {
                block3: {
                    if (!(repository instanceof SimpleArtifactRepository)) break block3;
                    Object value = ReflectUtil.getValue((String)"mirrors", (Object)repository);
                    if (!(value instanceof CachingRepositoryManager.Artifact.BetterMirrorSelector)) break block4;
                    CachingRepositoryManager.Artifact.BetterMirrorSelector mirrorSelector = (CachingRepositoryManager.Artifact.BetterMirrorSelector)((Object)value);
                    for (String stats : mirrorSelector.getStats()) {
                        this.monitor.subTask(stats);
                    }
                    break block4;
                }
                if (repository instanceof CompositeArtifactRepository) {
                    CompositeArtifactRepository compositeArtifactRepository = (CompositeArtifactRepository)repository;
                    for (IArtifactRepository childRepository : compositeArtifactRepository.getLoadedChildren()) {
                        this.processStats(childRepository);
                    }
                }
            }
        }
    }

    private static final class RepositoryLoader<T>
    extends WorkerPool<RepositoryLoader<T>, java.net.URI, Worker<T>> {
        private final IRepositoryManager<T> manager;
        private final java.net.URI[] uris;
        private final List<IRepository<T>> repositories = Collections.synchronizedList(new ArrayList());
        private ProvisionException exception;

        public RepositoryLoader(IRepositoryManager<T> manager, java.net.URI ... uris) {
            this.manager = manager;
            this.uris = uris;
        }

        public void begin(IProgressMonitor monitor) {
            try {
                monitor.beginTask("", this.uris.length + 1);
                monitor.worked(1);
                this.begin(Messages.ProfileTransactionImpl_LoadRepositories_task, monitor);
            }
            finally {
                monitor.done();
            }
        }

        public ProvisionException getException() {
            return this.exception;
        }

        protected void run(String taskName, IProgressMonitor monitor) {
            this.perform(this.uris);
        }

        protected Worker<T> createWorker(java.net.URI key, int workerID, boolean secondary) {
            return new Worker(NLS.bind((String)Messages.ProfileTransactionImpl_RepositoryLoader_thread, (Object)key), this, key, workerID, secondary);
        }

        private static class Worker<T>
        extends WorkerPool.Worker<java.net.URI, RepositoryLoader<T>> {
            public Worker(String name, RepositoryLoader<T> workPool, java.net.URI key, int id, boolean secondary) {
                super(name, workPool, (Object)key, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                RepositoryLoader workPool = (RepositoryLoader)this.getWorkPool();
                if (workPool.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    IRepositoryManager manager = workPool.manager;
                    java.net.URI key = (java.net.URI)this.getKey();
                    IMetadataRepository repository = manager instanceof IMetadataRepositoryManager ? ((IMetadataRepositoryManager)manager).loadRepository(key, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1)) : ((IArtifactRepositoryManager)manager).loadRepository(key, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                    workPool.repositories.add(repository);
                    return Status.OK_STATUS;
                }
                catch (ProvisionException ex) {
                    workPool.cancel();
                    workPool.exception = ex;
                    return P2CorePlugin.INSTANCE.getStatus((Object)ex);
                }
                catch (OperationCanceledException ex) {
                    return Status.CANCEL_STATUS;
                }
            }
        }
    }
}

