/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server;

import java.util.concurrent.Executor;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.quic.server.QuicServerConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3ServerConnector
extends QuicServerConnector {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3ServerConnector.class);
    private HttpField altSvcHttpField;

    public HTTP3ServerConnector(Server server, SslContextFactory.Server sslContextFactory, ConnectionFactory ... factories) {
        this(server, null, null, null, sslContextFactory, factories);
    }

    public HTTP3ServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, SslContextFactory.Server sslContextFactory, ConnectionFactory ... factories) {
        super(server, executor, scheduler, bufferPool, sslContextFactory, factories);
        this.getQuicConfiguration().setMaxBidirectionalRemoteStreams(128);
        this.getQuicConfiguration().setMaxUnidirectionalRemoteStreams(8);
        this.getQuicConfiguration().setUnidirectionalStreamRecvWindow(0x100000);
    }

    protected void doStart() throws Exception {
        LOG.info("HTTP/3+QUIC support is experimental and not suited for production use.");
        super.doStart();
        this.altSvcHttpField = new PreEncodedHttpField(HttpHeader.ALT_SVC, String.format("h3=\":%d\"", this.getLocalPort()));
    }

    public HttpField getAltSvcHttpField() {
        return this.altSvcHttpField;
    }
}

