/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server;

import java.util.Objects;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.internal.HTTP3Stream;
import org.eclipse.jetty.http3.server.AbstractHTTP3ServerConnectionFactory;
import org.eclipse.jetty.http3.server.HTTP3ServerConnector;
import org.eclipse.jetty.http3.server.internal.HTTP3StreamServer;
import org.eclipse.jetty.http3.server.internal.HttpChannelOverHTTP3;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3Session;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3StreamConnection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3ServerConnectionFactory
extends AbstractHTTP3ServerConnectionFactory {
    public HTTP3ServerConnectionFactory() {
        this(new HttpConfiguration());
    }

    public HTTP3ServerConnectionFactory(HttpConfiguration configuration) {
        super(configuration, new HTTP3SessionListener());
        configuration.addCustomizer((connector, httpConfig, request) -> {
            HttpField altSvc;
            HTTP3ServerConnector http3Connector = (HTTP3ServerConnector)((Object)((Object)connector.getServer().getBean(HTTP3ServerConnector.class)));
            if (http3Connector != null && HttpVersion.HTTP_2.is(request.getHttpVersion().asString()) && (altSvc = http3Connector.getAltSvcHttpField()) != null) {
                request.getResponse().getHttpFields().add(altSvc);
            }
        });
    }

    private static class HTTP3SessionListener
    implements Session.Server.Listener {
        private static final Logger LOG = LoggerFactory.getLogger(HTTP3SessionListener.class);

        private HTTP3SessionListener() {
        }

        public Stream.Server.Listener onRequest(Stream.Server stream, HeadersFrame frame) {
            HTTP3Stream http3Stream = (HTTP3Stream)stream;
            HTTP3StreamListener listener = new HTTP3StreamListener((EndPoint)http3Stream.getEndPoint());
            listener.onRequest((Stream)stream, frame);
            return listener;
        }

        public boolean onIdleTimeout(Session session) {
            boolean result = session.getStreams().stream().map(stream -> (HTTP3Stream)stream).map(stream -> (HttpChannelOverHTTP3)((Object)((Object)stream.getAttachment()))).filter(Objects::nonNull).map(channel -> channel.getState().isIdle()).reduce(true, Boolean::logicalAnd);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} idle timeout on {}", (Object)(result ? "confirmed" : "ignored"), (Object)session);
            }
            return result;
        }

        public void onFailure(Session session, long error, String reason, Throwable failure) {
            session.getStreams().stream().map(stream -> (HTTP3Stream)stream).forEach(stream -> stream.onFailure(error, failure));
        }
    }

    private static class HTTP3StreamListener
    implements Stream.Server.Listener {
        private final EndPoint endPoint;

        public HTTP3StreamListener(EndPoint endPoint) {
            this.endPoint = endPoint;
        }

        private ServerHTTP3StreamConnection getConnection() {
            return (ServerHTTP3StreamConnection)this.endPoint.getConnection();
        }

        public void onRequest(Stream stream, HeadersFrame frame) {
            HTTP3StreamServer http3Stream = (HTTP3StreamServer)stream;
            Runnable task = this.getConnection().onRequest(http3Stream, frame);
            if (task != null) {
                ServerHTTP3Session protocolSession = (ServerHTTP3Session)http3Stream.getSession().getProtocolSession();
                protocolSession.offer(task, false);
            }
        }

        public void onDataAvailable(Stream.Server stream) {
            HTTP3Stream http3Stream = (HTTP3Stream)stream;
            Runnable task = this.getConnection().onDataAvailable(http3Stream);
            if (task != null) {
                ServerHTTP3Session protocolSession = (ServerHTTP3Session)http3Stream.getSession().getProtocolSession();
                protocolSession.offer(task, false);
            }
        }

        public void onTrailer(Stream.Server stream, HeadersFrame frame) {
            HTTP3Stream http3Stream = (HTTP3Stream)stream;
            Runnable task = this.getConnection().onTrailer(http3Stream, frame);
            if (task != null) {
                ServerHTTP3Session protocolSession = (ServerHTTP3Session)http3Stream.getSession().getProtocolSession();
                protocolSession.offer(task, false);
            }
        }

        public boolean onIdleTimeout(Stream.Server stream, Throwable failure) {
            HTTP3Stream http3Stream = (HTTP3Stream)stream;
            return this.getConnection().onIdleTimeout((HTTP3Stream)stream, failure, task -> {
                if (task != null) {
                    ServerHTTP3Session protocolSession = (ServerHTTP3Session)http3Stream.getSession().getProtocolSession();
                    protocolSession.offer((Runnable)task, true);
                }
            });
        }

        public void onFailure(Stream.Server stream, long error, Throwable failure) {
            HTTP3Stream http3Stream = (HTTP3Stream)stream;
            Runnable task = this.getConnection().onFailure((HTTP3Stream)stream, failure);
            if (task != null) {
                ServerHTTP3Session protocolSession = (ServerHTTP3Session)http3Stream.getSession().getProtocolSession();
                protocolSession.offer(task, true);
            }
        }
    }
}

