/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.unixsocket.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Map;
import java.util.concurrent.Executor;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.DuplexHttpDestination;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.http.HttpClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.unixsocket.common.UnixSocketEndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class HttpClientTransportOverUnixSockets
extends AbstractConnectorHttpClientTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransportOverUnixSockets.class);
    private final ClientConnectionFactory factory = new HttpClientConnectionFactory();

    public HttpClientTransportOverUnixSockets(String unixSocket) {
        this(new UnixSocketClientConnector(unixSocket));
    }

    private HttpClientTransportOverUnixSockets(ClientConnector connector) {
        super(connector);
        this.setConnectionPoolFactory(destination -> {
            HttpClient httpClient = this.getHttpClient();
            int maxConnections = httpClient.getMaxConnectionsPerDestination();
            return new DuplexConnectionPool(destination, maxConnections, (Callback)destination);
        });
    }

    public Origin newOrigin(HttpRequest request) {
        return this.getHttpClient().createOrigin(request, null);
    }

    public HttpDestination newHttpDestination(Origin origin) {
        return new DuplexHttpDestination(this.getHttpClient(), origin);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        Connection connection = this.factory.newConnection(endPoint, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", (Object)connection);
        }
        return connection;
    }

    private static class UnixSocketClientConnector
    extends ClientConnector {
        private final String unixSocket;

        private UnixSocketClientConnector(String unixSocket) {
            this.unixSocket = unixSocket;
        }

        protected SelectorManager newSelectorManager() {
            return new UnixSocketSelectorManager(this.getExecutor(), this.getScheduler(), this.getSelectors());
        }

        public void connect(SocketAddress address, Map<String, Object> context) {
            InetSocketAddress socketAddress = (InetSocketAddress)address;
            InetAddress inetAddress = socketAddress.getAddress();
            if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress()) {
                UnixSocketChannel channel = null;
                try {
                    UnixSocketAddress unixAddress = new UnixSocketAddress(this.unixSocket);
                    channel = UnixSocketChannel.open((UnixSocketAddress)unixAddress);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created {} for {}", (Object)channel, (Object)unixAddress);
                    }
                    this.accept((SelectableChannel)channel, context);
                }
                catch (Throwable x) {
                    IO.close(channel);
                    this.connectFailed(x, context);
                }
            } else {
                this.connectFailed(new ConnectException("UnixSocket cannot connect to " + socketAddress.getHostString()), context);
            }
        }

        private class UnixSocketSelectorManager
        extends ClientConnector.ClientSelectorManager {
            private UnixSocketSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
                super((ClientConnector)UnixSocketClientConnector.this, executor, scheduler, selectors);
            }

            protected Selector newSelector() throws IOException {
                return NativeSelectorProvider.getInstance().openSelector();
            }

            protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey key) {
                UnixSocketEndPoint endPoint = new UnixSocketEndPoint((UnixSocketChannel)channel, selector, key, this.getScheduler());
                endPoint.setIdleTimeout(UnixSocketClientConnector.this.getIdleTimeout().toMillis());
                return endPoint;
            }
        }
    }
}

