/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.conscrypt.client;

import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLEngine;
import org.conscrypt.Conscrypt;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConscryptClientALPNProcessor
implements ALPNProcessor.Client {
    private static final Logger LOG = LoggerFactory.getLogger(ConscryptClientALPNProcessor.class);

    public void init() {
        if (Security.getProvider("Conscrypt") == null) {
            Security.addProvider((Provider)new OpenSSLProvider());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added Conscrypt provider");
            }
        }
    }

    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("org.conscrypt.");
    }

    public void configure(SSLEngine sslEngine, Connection connection) {
        try {
            ALPNClientConnection alpn = (ALPNClientConnection)connection;
            String[] protocols = alpn.getProtocols().toArray(new String[0]);
            Conscrypt.setApplicationProtocols((SSLEngine)sslEngine, (String[])protocols);
            ((SslConnection.DecryptedEndPoint)connection.getEndPoint()).getSslConnection().addHandshakeListener((SslHandshakeListener)new ALPNListener(alpn));
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private final class ALPNListener
    implements SslHandshakeListener {
        private final ALPNClientConnection alpnConnection;

        private ALPNListener(ALPNClientConnection connection) {
            this.alpnConnection = connection;
        }

        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            try {
                SSLEngine sslEngine = this.alpnConnection.getSSLEngine();
                String protocol = Conscrypt.getApplicationProtocol((SSLEngine)sslEngine);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Selected {} for {}", (Object)protocol, (Object)this.alpnConnection);
                }
                this.alpnConnection.selected(protocol);
            }
            catch (Throwable e) {
                LOG.warn("Unable to process Conscrypt ApplicationProtocol for {}", (Object)this.alpnConnection, (Object)e);
                this.alpnConnection.selected(null);
            }
        }
    }
}

