/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import org.eclipse.jetty.maven.plugin.MavenQuickStartConfiguration;
import org.eclipse.jetty.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.maven.plugin.ServerSupport;
import org.eclipse.jetty.maven.plugin.WebAppPropertyConverter;
import org.eclipse.jetty.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.webapp.Configuration;

public class QuickStartGenerator {
    private File quickstartXml;
    private MavenWebAppContext webApp;
    private File webAppPropsFile;
    private String contextXml;
    private boolean prepared = false;
    private Server server;
    private QueuedThreadPool tpool;

    public QuickStartGenerator(File quickstartXml, MavenWebAppContext webApp) {
        this.quickstartXml = quickstartXml;
        this.webApp = webApp;
    }

    public MavenWebAppContext getWebApp() {
        return this.webApp;
    }

    public File getQuickstartXml() {
        return this.quickstartXml;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public File getWebAppPropsFile() {
        return this.webAppPropsFile;
    }

    public void setWebAppPropsFile(File webAppPropsFile) {
        this.webAppPropsFile = webAppPropsFile;
    }

    public String getContextXml() {
        return this.contextXml;
    }

    public void setContextXml(String contextXml) {
        this.contextXml = contextXml;
    }

    private void prepareWebApp() throws Exception {
        if (this.webApp == null) {
            this.webApp = new MavenWebAppContext();
        }
        this.webApp.addConfiguration(new Configuration[]{new MavenQuickStartConfiguration()});
        this.webApp.setAttribute("org.eclipse.jetty.quickstart.mode", QuickStartConfiguration.Mode.GENERATE);
        this.webApp.setAttribute("org.eclipse.jetty.quickstart.xml", Resource.newResource((File)this.quickstartXml));
        this.webApp.setAttribute("org.eclipse.jetty.quickstart.origin", "o");
        this.webApp.setCopyWebDir(false);
        this.webApp.setCopyWebInf(false);
    }

    public void generate() throws Exception {
        if (this.quickstartXml == null) {
            throw new IllegalStateException("No quickstart xml output file");
        }
        if (!this.prepared) {
            this.prepared = true;
            this.prepareWebApp();
            if (this.server == null) {
                this.server = new Server();
            }
            ServerSupport.configureHandlers(this.server, null, null);
            ServerSupport.configureDefaultConfigurationClasses(this.server);
            if (this.tpool == null) {
                this.tpool = (QueuedThreadPool)this.server.getBean(QueuedThreadPool.class);
            }
            ServerSupport.addWebApplication(this.server, this.webApp);
            this.webApp.setPersistTempDirectory(true);
        }
        try {
            if (this.tpool != null) {
                this.tpool.start();
            } else {
                this.webApp.setAttribute("org.eclipse.jetty.annotations.multiThreaded", Boolean.FALSE.toString());
            }
            this.webApp.start();
            if (this.webAppPropsFile != null) {
                WebAppPropertyConverter.toProperties(this.webApp, this.webAppPropsFile, this.contextXml);
            }
        }
        finally {
            this.webApp.stop();
            if (this.tpool != null) {
                this.tpool.stop();
            }
        }
    }
}

