/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.setup.Configuration;
import org.eclipse.oomph.setup.EclipseIniTask;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.ProjectContainer;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.WorkspaceTask;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.CatalogSelector;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationProcessor {
    protected final SetupWizard setupWizard;
    protected final Configuration configuration;
    protected final Workspace workspace;
    protected Installation installation;
    private final ScopeStatus status = new ScopeStatus(null, "Problems were encountered processing the configuration");

    public ConfigurationProcessor(SetupWizard setupWizard) {
        this.setupWizard = setupWizard;
        this.configuration = setupWizard.getConfiguration();
        if (this.configuration == null) {
            this.installation = null;
            this.workspace = null;
        } else {
            this.installation = this.configuration.getInstallation();
            this.workspace = this.configuration.getWorkspace();
        }
        this.status.add((IStatus)new ScopeStatus((Scope)this.installation, "Problems were encountered processing the installation"));
        this.status.add((IStatus)new ScopeStatus(null, "Problems were encountered processing the workspace"));
    }

    public IStatus getStatus() {
        this.status.computeSeverity();
        int okCount = 0;
        IStatus result = null;
        IStatus[] iStatusArray = this.status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status.isOK()) {
                ++okCount;
            } else {
                result = status;
            }
            ++n2;
        }
        if (okCount == 1) {
            return result;
        }
        return this.status;
    }

    public boolean processInstallation() {
        return this.installation == null ? this.handleNullInstallation() : this.handleInstallation();
    }

    protected MultiStatus getStatus(Scope scope) {
        if (scope instanceof Installation) {
            return (MultiStatus)this.status.getChildren()[0];
        }
        MultiStatus containerStatus = (MultiStatus)this.status.getChildren()[scope instanceof ProductVersion ? 0 : 1];
        IStatus[] iStatusArray = containerStatus.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            ScopeStatus scopeStatus = (ScopeStatus)status;
            if (scopeStatus.getScope() == scope) {
                return scopeStatus;
            }
            ++n2;
        }
        ScopeStatus scopeStatus = new ScopeStatus(scope);
        containerStatus.add((IStatus)scopeStatus);
        return scopeStatus;
    }

    public boolean processWorkspace() {
        return this.workspace == null ? this.handleNullWorkspace() : this.handleWorkspace();
    }

    protected boolean handleNullInstallation() {
        return true;
    }

    protected boolean handleInstallation() {
        ProductVersion productVersion = this.installation.getProductVersion();
        return productVersion == null ? this.handleNullProductVersion() : this.handleProductVersion(productVersion);
    }

    protected boolean handleNullProductVersion() {
        this.addStatus(4, (Scope)this.installation, "No product version is specified");
        return false;
    }

    protected boolean handleProductVersion(ProductVersion productVersion) {
        if (productVersion.eIsProxy()) {
            return this.handleProxyProductVersion(productVersion);
        }
        Product product = productVersion.getProduct();
        if (product == null) {
            return this.handleNullProduct(productVersion);
        }
        ProductCatalog productCatalog = product.getProductCatalog();
        CatalogManager catalogManager = this.setupWizard.getCatalogManager();
        if (productCatalog == null) {
            boolean added = false;
            CatalogSelector catalogSelector = new CatalogSelector(catalogManager, true);
            for (Scope scope : catalogSelector.getCatalogs()) {
                if (!ConfigurationProcessor.isUserProductCatalog(scope)) continue;
                ProductCatalog userProductCatalog = (ProductCatalog)scope;
                userProductCatalog.getProducts().add((Object)product);
                BaseUtil.saveEObject((EObject)userProductCatalog);
                catalogManager.selectCatalog(true, (Scope)userProductCatalog, true);
                added = true;
                break;
            }
            if (!added) {
                return this.handleNoUserProductCatalog(productVersion);
            }
        } else {
            Index index = catalogManager.getIndex();
            Index productCatalogIndex = productCatalog.getIndex();
            if (productCatalogIndex == index) {
                if (!"self".equals(productCatalog.getName())) {
                    catalogManager.selectCatalog(true, (Scope)productCatalog, true);
                }
            } else if (!this.addCatalog(true, (Scope)productCatalog, (Scope)productVersion)) {
                return this.handleNoRedirectableProductCatalog(productVersion);
            }
        }
        if ("self.empty.product.version".equals(productVersion.getQualifiedName())) {
            return this.applyEmptyProductVersion();
        }
        return this.applyProductVersion(productVersion);
    }

    protected boolean applyEmptyProductVersion() {
        return false;
    }

    protected boolean applyProductVersion(ProductVersion productVersion) {
        return false;
    }

    protected void applyInstallation() {
        SetupContext setupContext = SetupContext.create((ResourceSet)this.setupWizard.getResourceSet(), null);
        Installation setupInstallation = setupContext.getInstallation();
        this.applyAttributes((Scope)setupInstallation, (Scope)this.installation);
        this.applySetupTasks((SetupTaskContainer)setupInstallation, (SetupTaskContainer)this.installation);
        this.setupWizard.addAppliedConfigurationResource(this.installation.eResource());
    }

    protected void applyAttributes(Scope targetScope, Scope sourceScope) {
        String description;
        String label;
        String name = sourceScope.getName();
        if (!StringUtil.isEmpty((String)name)) {
            targetScope.setName(name);
        }
        if (!StringUtil.isEmpty((String)(label = sourceScope.getLabel()))) {
            targetScope.setLabel(label);
        }
        if (!StringUtil.isEmpty((String)(description = sourceScope.getDescription()))) {
            targetScope.setDescription(description);
        }
        targetScope.getAnnotations().addAll((Collection)sourceScope.getAnnotations());
    }

    protected void applySetupTasks(SetupTaskContainer targetSetupTaskContainer, SetupTaskContainer sourceSetTaskContainer) {
        targetSetupTaskContainer.getSetupTasks().addAll((Collection)sourceSetTaskContainer.getSetupTasks());
    }

    protected boolean handleNoRedirectableProductCatalog(ProductVersion productVersion) {
        return false;
    }

    protected boolean handleNoUserProductCatalog(ProductVersion productVersion) {
        this.addStatus(4, (Scope)productVersion, "Cannot add the product to the user product catalog because the index doesn't contain one");
        return false;
    }

    protected boolean handleProxyProductVersion(ProductVersion productVersion) {
        this.addStatus(4, (Scope)productVersion, "The product version cannot be resolved");
        return false;
    }

    protected boolean handleNullProduct(ProductVersion productVersion) {
        this.addStatus(4, (Scope)productVersion, "The product version is not contained by a product");
        return false;
    }

    protected boolean handleNullWorkspace() {
        return true;
    }

    protected boolean handleWorkspace() {
        if (this.setupWizard.isSimple()) {
            String[] stringArray;
            Shell shell = this.setupWizard.getShell();
            if (this.installation == null) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "Switch to Advanced Mode";
                stringArray = stringArray2;
                stringArray2[1] = "Cancel";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "Switch to Avanced Mode";
                stringArray3[1] = "Apply only Installation";
                stringArray = stringArray3;
                stringArray3[2] = "Cancel";
            }
            int answer = new MessageDialog(shell, "Configuration Handling", null, "The configuration contains a workspace that can only be handled by the advanced mode of the installer.", 4, stringArray, 0).open();
            switch (answer) {
                case 0: {
                    if (this.configuration != null) {
                        this.setupWizard.addAppliedConfigurationResource(this.configuration.eResource());
                    }
                    Collection<? extends Resource> configurationResources = this.setupWizard.getAppliedConfigurationResources();
                    this.handleSwitchToAdvancedMode();
                    this.setupWizard.setConfigurationResources(configurationResources);
                    return false;
                }
                case 1: {
                    return this.installation != null;
                }
            }
            return false;
        }
        ArrayList<Stream> projectStreams = new ArrayList<Stream>();
        for (Stream stream : this.workspace.getStreams()) {
            if (stream.eIsProxy()) {
                this.addStatus(4, (Scope)stream, "The referenced stream cannot be resolved");
                continue;
            }
            Project project = stream.getProject();
            if (project == null) {
                this.addStatus(4, (Scope)stream, "The referenced stream is not contained by a project");
                continue;
            }
            Project rootProject = project;
            ProjectCatalog projectCatalog = null;
            ProjectContainer projectContainer = project.getProjectContainer();
            while (projectContainer != null) {
                if (projectContainer instanceof Project) {
                    rootProject = (Project)projectContainer;
                } else if (projectContainer instanceof ProjectCatalog) {
                    projectCatalog = (ProjectCatalog)projectContainer;
                    break;
                }
                projectContainer = projectContainer.getProjectContainer();
            }
            if (projectCatalog == null) {
                ProjectContainer logicalProjectContainer = rootProject.getLogicalProjectContainer();
                if (logicalProjectContainer == null) {
                    this.addStatus(4, (Scope)stream, "The referenced stream's root project is not contained by a project catalog and it doesn't specify a logical project container: " + EcoreUtil.getURI((EObject)rootProject));
                    continue;
                }
                if (logicalProjectContainer.eIsProxy()) {
                    this.addStatus(4, (Scope)stream, "The referenced stream's root project is not contained by a project catalog and its logical project container cannot be resolved: " + EcoreUtil.getURI((EObject)logicalProjectContainer));
                    continue;
                }
                if (logicalProjectContainer instanceof Project) {
                    this.addStatus(4, (Scope)stream, "The referenced stream's root project is not contained by a project catalog and is not contained by its logical project container: " + EcoreUtil.getURI((EObject)logicalProjectContainer));
                    continue;
                }
                ProjectCatalog logicalProjectCatalog = (ProjectCatalog)logicalProjectContainer;
                if (!this.handleStream(logicalProjectCatalog, stream)) continue;
                if (logicalProjectCatalog.getProjects().contains((Object)rootProject)) {
                    projectStreams.add(stream);
                    continue;
                }
                if (this.handleUserProject(logicalProjectCatalog, rootProject)) {
                    projectStreams.add(stream);
                    continue;
                }
                this.addStatus(4, (Scope)stream, "Cannot add the stream's root project: " + EcoreUtil.getURI((EObject)rootProject));
                this.addStatus(4, (Scope)stream, "The target project catalog does not contain an extensible user project: " + EcoreUtil.getURI((EObject)logicalProjectCatalog));
                continue;
            }
            if (!this.handleStream(projectCatalog, stream)) continue;
            projectStreams.add(stream);
        }
        if (projectStreams.isEmpty() ? this.applyNoStreams() : this.applyStreams(projectStreams)) {
            return this.applyWorkspace();
        }
        return false;
    }

    protected boolean applyWorkspace() {
        SetupContext setupContext = SetupContext.create((Installation)this.installation, Collections.emptyList(), null);
        Workspace setupWorkspace = setupContext.getWorkspace();
        this.applyAttributes((Scope)setupWorkspace, (Scope)this.workspace);
        this.applySetupTasks((SetupTaskContainer)setupWorkspace, (SetupTaskContainer)this.workspace);
        if (setupWorkspace.getStreams().isEmpty() && !setupWorkspace.getSetupTasks().isEmpty()) {
            WorkspaceTask workspaceTask = SetupFactory.eINSTANCE.createWorkspaceTask();
            workspaceTask.setID("workspace");
            setupWorkspace.getSetupTasks().add(0, (Object)workspaceTask);
        }
        this.setupWizard.addAppliedConfigurationResource(this.workspace.eResource());
        return true;
    }

    protected boolean applyStreams(List<Stream> streams) {
        return true;
    }

    protected boolean applyNoStreams() {
        return true;
    }

    protected boolean handleNoRedirectableProjectCatalog(Stream stream) {
        return false;
    }

    protected boolean handleUserProject(ProjectCatalog projectCatalog, Project project) {
        CatalogManager catalogManager = this.setupWizard.getCatalogManager();
        for (Project catalogProject : projectCatalog.getProjects()) {
            if (!ConfigurationProcessor.isUserProject(catalogProject)) continue;
            catalogProject.getProjects().add((Object)project);
            BaseUtil.saveEObject((EObject)catalogProject);
            catalogManager.selectCatalog(false, (Scope)projectCatalog, true);
            return true;
        }
        return false;
    }

    protected boolean handleStream(ProjectCatalog projectCatalog, Stream stream) {
        Index index;
        CatalogManager catalogManager = this.setupWizard.getCatalogManager();
        Index projectIndex = projectCatalog.getIndex();
        if (projectIndex != (index = catalogManager.getIndex()) && !this.addCatalog(false, (Scope)projectCatalog, (Scope)stream)) {
            return this.handleNoRedirectableProjectCatalog(stream);
        }
        catalogManager.selectCatalog(false, (Scope)projectCatalog, true);
        return true;
    }

    protected boolean addCatalog(boolean product, Scope catalogScope, Scope originatingScope) {
        String label;
        CatalogManager catalogManager = this.setupWizard.getCatalogManager();
        Scope catalog = catalogManager.getCatalog(product, "redirectable");
        String string = label = product ? "product" : "project";
        if (catalog == null) {
            this.addStatus(4, originatingScope, "Cannot add the catalog " + EcoreUtil.getURI((EObject)catalogScope));
            ResourceSet resourceSet = this.setupWizard.getResourceSet();
            Resource resource = resourceSet.getResource(URI.createURI((String)("index:/redirectable." + label + "s.setup")), false);
            if (resource == null) {
                this.addStatus(4, originatingScope, "There is no redirectable " + label + " catalog is in the index");
            } else {
                this.addStatus(4, originatingScope, "The redirectable " + label + " catalog in the index is already redirected to " + resourceSet.getURIConverter().normalize(resource.getURI()));
            }
            return false;
        }
        Resource catalogResource = catalog.eResource();
        URI sourceURI = catalogResource.getURI();
        URI targetURI = catalogScope.eResource().getURI();
        EcoreUtil.replace((EObject)catalog, (EObject)catalogScope);
        catalogManager.selectCatalog(product, catalogScope, true);
        catalogResource.getResourceSet().getURIConverter().getURIMap().put(targetURI, sourceURI);
        EList setupTasks = (product ? this.installation : this.workspace).getSetupTasks();
        EclipseIniTask redirectionEclipseIniTask = SetupFactory.eINSTANCE.createEclipseIniTask();
        redirectionEclipseIniTask.setVm(true);
        redirectionEclipseIniTask.setOption("-Doomph.redirection." + (product ? "products" : "projects") + "=");
        redirectionEclipseIniTask.setValue(sourceURI + "->" + targetURI);
        setupTasks.add(0, (Object)redirectionEclipseIniTask);
        return true;
    }

    protected void addStatus(int severity, Scope scope, String message) {
        MultiStatus containerStatus = this.getStatus(scope);
        containerStatus.add((IStatus)new Status(severity, SetupUIPlugin.PLUGIN_ID, message));
    }

    protected void handleSwitchToAdvancedMode() {
    }

    public static boolean isUserProject(Project project) {
        Resource resource = project.eResource();
        return resource != null && SetupContext.isUserScheme((String)resource.getURI().scheme());
    }

    public static boolean isUserProductCatalog(Scope scope) {
        if (scope instanceof ProductCatalog) {
            Resource resource = scope.eResource();
            return resource != null && SetupContext.isUserScheme((String)resource.getURI().scheme());
        }
        return false;
    }

    private static class ScopeStatus
    extends MultiStatus {
        private final Scope scope;

        public ScopeStatus(Scope scope) {
            super(SetupUIPlugin.PLUGIN_ID, 0, "Processing " + EcoreUtil.getURI((EObject)scope), null);
            this.scope = scope;
        }

        public ScopeStatus(Scope scope, String message) {
            super(SetupUIPlugin.PLUGIN_ID, 0, message, null);
            this.scope = scope;
        }

        public Scope getScope() {
            return this.scope;
        }

        public int computeSeverity() {
            IStatus[] iStatusArray = this.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                int newSev;
                IStatus status = iStatusArray[n2];
                int n3 = newSev = status instanceof ScopeStatus ? ((ScopeStatus)status).computeSeverity() : status.getSeverity();
                if (newSev > this.getSeverity()) {
                    this.setSeverity(newSev);
                }
                ++n2;
            }
            return this.getSeverity();
        }
    }
}

