/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.ProfileDefinition;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.p2.impl.P2TaskImpl;
import org.eclipse.oomph.setup.ui.UnsignedContentDialog;
import org.eclipse.oomph.setup.ui.wizards.ProgressPage;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.util.Confirmer;
import org.eclipse.oomph.util.PropertiesUtil;

public class SelfCommitContext
extends ProfileTransaction.CommitContext {
    private final User user;
    private boolean repositoryChanged;
    private IProvisioningPlan provisioningPlan;

    public SelfCommitContext(User user) throws CoreException {
        this.user = user;
    }

    public ProfileTransaction migrateProfile(ProfileTransaction transaction) throws CoreException {
        boolean installer = false;
        String productID = PropertiesUtil.getProductID();
        VersionRange deprecatedVersionRange = new VersionRange("[1.0.0,1.1.0)");
        ProfileDefinition profileDefinition = transaction.getProfileDefinition();
        for (Requirement requirement : profileDefinition.getRequirements()) {
            if (!"org.eclipse.equinox.p2.iu".equals(requirement.getNamespace()) || !productID.equals(requirement.getName())) continue;
            installer = true;
            if (!deprecatedVersionRange.equals((Object)requirement.getVersionRange())) break;
            requirement.setVersionRange(new VersionRange("[1.0.0,2.0.0)"));
            transaction.commit((IProgressMonitor)new NullProgressMonitor());
            Profile profile = transaction.getProfile();
            transaction = profile.change();
            break;
        }
        this.repositoryChanged = installer ? this.changeRepositoryIfNeeded(profileDefinition) : false;
        return transaction;
    }

    public boolean handleProvisioningPlan(ProfileTransaction.CommitContext.ResolutionInfo info) throws CoreException {
        if (this.repositoryChanged && info.getIUDeltas().isEmpty() && info.getPropertyDeltas().size() <= 1) {
            return false;
        }
        this.provisioningPlan = info.getProvisioningPlan();
        return true;
    }

    public Confirmer getUnsignedContentConfirmer() {
        if (this.user == null) {
            return Confirmer.ACCEPT;
        }
        P2TaskImpl.processLicenses((IProvisioningPlan)this.provisioningPlan, (Confirmer)ProgressPage.LICENSE_CONFIRMER, (User)this.user, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
        return UnsignedContentDialog.createUnsignedContentConfirmer(this.user, true);
    }

    private boolean changeRepositoryIfNeeded(ProfileDefinition profileDefinition) {
        EList repositories = profileDefinition.getRepositories();
        URIConverter uriConverter = SetupCoreUtil.createResourceSet().getURIConverter();
        String installerUpdateURL = uriConverter.normalize(URI.createURI((String)SetupUtil.INSTALLER_UPDATE_URL)).toString();
        Repository repository = P2Factory.eINSTANCE.createRepository(installerUpdateURL);
        if (repositories.isEmpty()) {
            repositories.add((Object)repository);
            return true;
        }
        if (!installerUpdateURL.equals(((Repository)repositories.get(0)).getURL())) {
            repositories.set(0, (Object)repository);
            return true;
        }
        return false;
    }
}

