/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class CheckboxTreeAndListGroup
extends EventManager
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    private Object root;
    private Object currentTreeSelection;
    private final List<Object> expandedTreeNodes = new ArrayList<Object>();
    private final Map<Object, List<Object>> checkedStateStore = new HashMap<Object, List<Object>>(9);
    private final List<Object> whiteCheckedTreeItems = new ArrayList<Object>();
    private final ITreeContentProvider treeContentProvider;
    private final IStructuredContentProvider listContentProvider;
    private final ILabelProvider treeLabelProvider;
    private final ILabelProvider listLabelProvider;
    private final ViewerComparator treeComparator;
    private final ViewerComparator listComparator;
    private CheckboxTreeViewer treeViewer;
    private CheckboxTableViewer listViewer;

    public CheckboxTreeAndListGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, int style, int width, int height) {
        this(parent, rootObject, treeContentProvider, treeLabelProvider, null, listContentProvider, listLabelProvider, null, style, width, height);
    }

    public CheckboxTreeAndListGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, ViewerComparator treeComparator, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, ViewerComparator listComparator, int style, int width, int height) {
        this.root = rootObject;
        this.treeContentProvider = treeContentProvider;
        this.listContentProvider = listContentProvider;
        this.treeLabelProvider = treeLabelProvider;
        this.listLabelProvider = listLabelProvider;
        this.treeComparator = treeComparator;
        this.listComparator = listComparator;
        this.createContents(parent, width, height, style);
    }

    public void aboutToOpen() {
        Object primary;
        this.determineWhiteCheckedDescendents(this.root);
        this.checkNewTreeElements(this.treeContentProvider.getElements(this.root));
        this.currentTreeSelection = null;
        Object[] elements = this.treeContentProvider.getElements(this.root);
        Object object = primary = elements.length > 0 ? elements[0] : null;
        if (primary != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(primary));
        }
        this.treeViewer.getControl().setFocus();
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.addListenerObject(listener);
    }

    private void addToHierarchyToCheckedStore(Object treeElement) {
        Object parent;
        if (!this.checkedStateStore.containsKey(treeElement)) {
            this.checkedStateStore.put(treeElement, new ArrayList());
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.addToHierarchyToCheckedStore(parent);
        }
    }

    protected boolean areAllChildrenWhiteChecked(Object treeElement) {
        Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!this.whiteCheckedTreeItems.contains(element)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean areAllElementsChecked(Object treeElement) {
        List<Object> checkedElements = this.checkedStateStore.get(treeElement);
        if (checkedElements == null) {
            return false;
        }
        return this.getListItemsSize(treeElement) == checkedElements.size();
    }

    protected void checkNewTreeElements(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentElement = objectArray[n2];
            boolean checked = this.checkedStateStore.containsKey(currentElement);
            this.treeViewer.setChecked(currentElement, checked);
            this.treeViewer.setGrayed(currentElement, checked && !this.whiteCheckedTreeItems.contains(currentElement));
            ++n2;
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), () -> {
            if (event.getCheckable().equals(this.treeViewer)) {
                this.treeItemChecked(event.getElement(), event.getChecked());
            } else {
                this.listItemChecked(event.getElement(), event.getChecked(), true);
            }
            this.notifyCheckStateChangeListeners(event);
        });
    }

    protected void createContents(Composite parent, int width, int height, int style) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createTreeViewer(composite, width / 2, height);
        this.createListViewer(composite, width / 2, height);
        this.initialize();
    }

    protected void createListViewer(Composite parent, int width, int height) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(parent.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.setComparator(this.listComparator);
        this.listViewer.addCheckStateListener((ICheckStateListener)this);
    }

    protected void createTreeViewer(Composite parent, int width, int height) {
        Tree tree = new Tree(parent, 2080);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.setComparator(this.treeComparator);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected boolean determineShouldBeAtLeastGrayChecked(Object treeElement) {
        List<Object> checked = this.checkedStateStore.get(treeElement);
        if (checked != null && !checked.isEmpty()) {
            return true;
        }
        Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (this.checkedStateStore.containsKey(child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean determineShouldBeWhiteChecked(Object treeElement) {
        return this.areAllChildrenWhiteChecked(treeElement) && this.areAllElementsChecked(treeElement);
    }

    protected void determineWhiteCheckedDescendents(Object treeElement) {
        Object[] objectArray = this.treeContentProvider.getElements(treeElement);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.determineWhiteCheckedDescendents(child);
            ++n2;
        }
        if (this.determineShouldBeWhiteChecked(treeElement)) {
            this.setWhiteChecked(treeElement, true);
        }
    }

    public void expandAll() {
        this.treeViewer.expandAll();
    }

    public Iterator<?> getAllCheckedListItems() {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator<List<Object>> listCollectionsEnum = this.checkedStateStore.values().iterator();
        while (listCollectionsEnum.hasNext()) {
            Iterator<Object> currentCollection = listCollectionsEnum.next().iterator();
            while (currentCollection.hasNext()) {
                result.add(currentCollection.next());
            }
        }
        return result.iterator();
    }

    public Set<Object> getAllCheckedTreeItems() {
        return this.checkedStateStore.keySet();
    }

    public int getCheckedElementCount() {
        return this.checkedStateStore.size();
    }

    protected int getListItemsSize(Object treeElement) {
        Object[] elements = this.listContentProvider.getElements(treeElement);
        return elements.length;
    }

    public Table getListTable() {
        return this.listViewer.getTable();
    }

    protected void grayCheckHierarchy(Object treeElement) {
        Object parent;
        if (this.checkedStateStore.containsKey(treeElement)) {
            return;
        }
        this.checkedStateStore.put(treeElement, new ArrayList());
        if (this.determineShouldBeWhiteChecked(treeElement)) {
            this.setWhiteChecked(treeElement, true);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.grayCheckHierarchy(parent);
        }
    }

    public void initialCheckListItem(Object element) {
        Object parent;
        this.currentTreeSelection = parent = this.treeContentProvider.getParent(element);
        this.listItemChecked(element, true, false);
        this.updateHierarchy(parent);
    }

    public void initialCheckTreeItem(Object element) {
        this.treeItemChecked(element, true);
    }

    protected void initialize() {
        this.treeViewer.setInput(this.root);
    }

    protected void listItemChecked(Object listElement, boolean state, boolean updatingFromSelection) {
        List<Object> checkedListItems = this.checkedStateStore.get(this.currentTreeSelection);
        if (state) {
            if (checkedListItems == null) {
                this.grayCheckHierarchy(this.currentTreeSelection);
                checkedListItems = this.checkedStateStore.get(this.currentTreeSelection);
            }
            checkedListItems.add(listElement);
        } else {
            checkedListItems.remove(listElement);
            if (checkedListItems.isEmpty()) {
                this.ungrayCheckHierarchy(this.currentTreeSelection);
            }
        }
        if (updatingFromSelection) {
            this.updateHierarchy(this.currentTreeSelection);
        }
    }

    protected void notifyCheckStateChangeListeners(final CheckStateChangedEvent event) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final ICheckStateListener checkStateListener = (ICheckStateListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    checkStateListener.checkStateChanged(event);
                }
            });
            ++n2;
        }
    }

    protected void populateListViewer(Object treeElement) {
        this.listViewer.setInput(treeElement);
        List<Object> listItemsToCheck = this.checkedStateStore.get(treeElement);
        if (listItemsToCheck != null) {
            Iterator<Object> listItemsEnum = listItemsToCheck.iterator();
            while (listItemsEnum.hasNext()) {
                this.listViewer.setChecked(listItemsEnum.next(), true);
            }
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.removeListenerObject(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = event.getStructuredSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            this.currentTreeSelection = null;
            this.listViewer.setInput(this.currentTreeSelection);
            return;
        }
        if (selectedElement != this.currentTreeSelection) {
            this.populateListViewer(selectedElement);
        }
        this.currentTreeSelection = selectedElement;
    }

    public void setAllSelections(boolean selection) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), () -> {
            this.setTreeChecked(this.root, selection);
            this.listViewer.setAllChecked(selection);
        });
    }

    public void setListProviders(IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
        this.listViewer.setContentProvider((IContentProvider)contentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setListComparator(ViewerComparator comparator) {
        this.listViewer.setComparator(comparator);
    }

    public void setRoot(Object newRoot) {
        this.root = newRoot;
        this.initialize();
    }

    protected void setTreeChecked(Object treeElement, boolean state) {
        if (treeElement.equals(this.currentTreeSelection)) {
            this.listViewer.setAllChecked(state);
        }
        if (state) {
            ArrayList<Object> listItemsChecked = new ArrayList<Object>(Arrays.asList(this.listContentProvider.getElements(treeElement)));
            this.checkedStateStore.put(treeElement, listItemsChecked);
        } else {
            this.checkedStateStore.remove(treeElement);
        }
        this.setWhiteChecked(treeElement, state);
        this.treeViewer.setChecked(treeElement, state);
        this.treeViewer.setGrayed(treeElement, false);
        Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.setTreeChecked(child, state);
            ++n2;
        }
    }

    public void setTreeProviders(ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setTreeComparator(ViewerComparator comparator) {
        this.treeViewer.setComparator(comparator);
    }

    protected void setWhiteChecked(Object treeElement, boolean isWhiteChecked) {
        if (isWhiteChecked) {
            if (!this.whiteCheckedTreeItems.contains(treeElement)) {
                this.whiteCheckedTreeItems.add(treeElement);
            }
        } else {
            this.whiteCheckedTreeItems.remove(treeElement);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object item = event.getElement();
        if (!this.expandedTreeNodes.contains(item)) {
            this.expandedTreeNodes.add(item);
            this.checkNewTreeElements(this.treeContentProvider.getChildren(item));
        }
    }

    protected void treeItemChecked(Object treeElement, boolean state) {
        this.setTreeChecked(treeElement, state);
        Object parent = this.treeContentProvider.getParent(treeElement);
        if (parent == null) {
            return;
        }
        if (state) {
            this.grayCheckHierarchy(parent);
        } else {
            this.ungrayCheckHierarchy(parent);
        }
        this.updateHierarchy(treeElement);
    }

    protected void ungrayCheckHierarchy(Object treeElement) {
        Object parent;
        if (!this.determineShouldBeAtLeastGrayChecked(treeElement)) {
            this.checkedStateStore.remove(treeElement);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.ungrayCheckHierarchy(parent);
        }
    }

    protected void updateHierarchy(Object treeElement) {
        Object parent;
        boolean whiteChecked = this.determineShouldBeWhiteChecked(treeElement);
        boolean shouldBeAtLeastGray = this.determineShouldBeAtLeastGrayChecked(treeElement);
        this.treeViewer.setChecked(treeElement, shouldBeAtLeastGray);
        this.setWhiteChecked(treeElement, whiteChecked);
        if (!whiteChecked) {
            this.treeViewer.setGrayed(treeElement, shouldBeAtLeastGray);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.updateHierarchy(parent);
        }
    }

    public void updateSelections(Map<Object, List<Object>> items) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), () -> {
            for (Map.Entry entry : items.entrySet()) {
                Object key1 = entry.getKey();
                List selections = (List)entry.getValue();
                if (selections.isEmpty()) {
                    this.checkedStateStore.remove(key1);
                    continue;
                }
                this.checkedStateStore.put(key1, selections);
                Object parent = this.treeContentProvider.getParent(key1);
                if (parent == null) continue;
                this.addToHierarchyToCheckedStore(parent);
            }
            for (Map.Entry entry : items.entrySet()) {
                Object key2 = entry.getKey();
                this.updateHierarchy(key2);
                if (this.currentTreeSelection == null || !this.currentTreeSelection.equals(key2)) continue;
                this.listViewer.setAllChecked(false);
                this.listViewer.setCheckedElements(((List)entry.getValue()).toArray());
            }
        });
    }
}

