/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import org.eclipse.oomph.internal.ui.FlatButton;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class SimpleCheckbox
extends FlatButton {
    private static final Color COLOR_BACKGROUND = SetupInstallerPlugin.getColor((int)245, (int)245, (int)245);
    private static final Color COLOR_HOVER = SetupInstallerPlugin.getColor((int)217, (int)217, (int)217);
    private boolean checked;

    public SimpleCheckbox(Composite parent) {
        super(parent, 32);
        this.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/checkmark_checked.png"));
        this.setIconTextGap(10);
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleCheckbox.this.setChecked(!SimpleCheckbox.this.isChecked());
            }
        });
        this.setFont(SimpleInstallerDialog.getFont(0, "bold"));
        this.setForeground(AbstractSimpleDialog.COLOR_LABEL_FOREGROUND);
        this.setDisabledBackgroundColor(null);
    }

    protected void drawImage(GC gc, int x, int y) {
        Image img = this.getImage();
        Rectangle imgBounds = img.getBounds();
        Color oldBG = gc.getBackground();
        Color bgColor = this.isHover() ? COLOR_HOVER : COLOR_BACKGROUND;
        gc.setBackground(bgColor);
        gc.fillRoundRectangle(x, y, imgBounds.width, imgBounds.height, this.getCornerWidth(), this.getCornerWidth());
        gc.setBackground(oldBG);
        if (this.isChecked()) {
            gc.drawImage(img, x, y);
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.redraw();
    }
}

