/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.Blob;
import org.eclipse.userstorage.internal.util.IOUtil;

public abstract class InternalStorageCache {
    private IStorageService service;

    public IStorageService getService() {
        return this.service;
    }

    void setService(IStorageService service) {
        IStorageService oldService = this.service;
        this.service = service;
        if (service != oldService) {
            this.storageChanged(oldService, service);
        }
    }

    protected abstract void storageChanged(IStorageService var1, IStorageService var2);

    void internalLoadProperties(String applicationToken, String key, Map<String, String> properties) throws IOException {
        this.loadProperties(applicationToken, key, properties);
    }

    void internalSaveProperties(String applicationToken, String key, Map<String, String> properties) throws IOException {
        this.saveProperties(applicationToken, key, properties);
    }

    InputStream internalGetInputStream(String applicationToken, String key) throws IOException {
        return this.getInputStream(applicationToken, key);
    }

    OutputStream internalGetOutputStream(String applicationToken, String key, Map<String, String> properties) throws IOException {
        return new TransactionalOutputStream(applicationToken, key, properties);
    }

    void internalDelete(String applicationToken, String key) throws IOException {
        this.delete(applicationToken, key);
    }

    public abstract Iterator<String> getKeys(String var1) throws IOException;

    protected abstract void loadProperties(String var1, String var2, Map<String, String> var3) throws IOException;

    protected abstract void saveProperties(String var1, String var2, Map<String, String> var3) throws IOException;

    protected abstract InputStream getInputStream(String var1, String var2) throws IOException;

    protected abstract OutputStream getOutputStream(String var1, String var2) throws IOException;

    protected abstract void delete(String var1, String var2) throws IOException;

    private final class TransactionalOutputStream
    extends OutputStream
    implements IOUtil.EndOfFileAware {
        private final String applicationToken;
        private final String key;
        private final Map<String, String> properties;
        private OutputStream output;
        private boolean fullyWritten;

        private TransactionalOutputStream(String applicationToken, String key, Map<String, String> properties) {
            this.applicationToken = applicationToken;
            this.key = key;
            this.properties = properties;
        }

        private void init() throws IOException {
            if (this.output == null) {
                InternalStorageCache.this.saveProperties(this.applicationToken, this.key, Blob.NO_PROPERTIES);
                this.output = InternalStorageCache.this.getOutputStream(this.applicationToken, this.key);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.init();
            this.output.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.init();
            this.output.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.init();
            this.output.write(b, off, len);
        }

        @Override
        public void reachedEndOfFile() {
            try {
                this.init();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fullyWritten = true;
        }

        @Override
        public void close() throws IOException {
            if (this.output != null) {
                try {
                    if (this.fullyWritten) {
                        InternalStorageCache.this.saveProperties(this.applicationToken, this.key, this.properties);
                    }
                }
                finally {
                    this.output.close();
                    this.output = null;
                }
            }
        }
    }
}

